/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Index;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CompositePath;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingMode;
import com.azure.cosmos.models.SpatialSpec;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class IndexingPolicy {
    private static final String DEFAULT_PATH = "/*";
    private List<IncludedPath> includedPaths;
    private List<ExcludedPath> excludedPaths;
    private List<List<CompositePath>> compositeIndexes;
    private List<SpatialSpec> spatialIndexes;
    private JsonSerializable jsonSerializable;

    public IndexingPolicy() {
        this.jsonSerializable = new JsonSerializable();
        this.setAutomatic(true);
        this.setIndexingMode(IndexingMode.CONSISTENT);
    }

    IndexingPolicy(Index[] defaultIndexOverrides) {
        this();
        if (defaultIndexOverrides == null) {
            throw new IllegalArgumentException("defaultIndexOverrides is null.");
        }
        IncludedPath includedPath = new IncludedPath(DEFAULT_PATH);
        includedPath.setIndexes(new ArrayList<Index>(Arrays.asList(defaultIndexOverrides)));
        this.getIncludedPaths().add(includedPath);
    }

    IndexingPolicy(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    IndexingPolicy(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public Boolean isAutomatic() {
        return this.jsonSerializable.getBoolean("automatic");
    }

    public IndexingPolicy setAutomatic(boolean automatic) {
        this.jsonSerializable.set("automatic", automatic);
        return this;
    }

    public IndexingMode getIndexingMode() {
        IndexingMode result = IndexingMode.LAZY;
        try {
            result = IndexingMode.valueOf(StringUtils.upperCase(this.jsonSerializable.getString("indexingMode")));
        }
        catch (IllegalArgumentException e) {
            this.jsonSerializable.getLogger().warn("INVALID indexingMode value {}.", (Object)this.jsonSerializable.getString("indexingMode"));
        }
        return result;
    }

    public IndexingPolicy setIndexingMode(IndexingMode indexingMode) {
        this.jsonSerializable.set("indexingMode", indexingMode.toString());
        return this;
    }

    public List<IncludedPath> getIncludedPaths() {
        if (this.includedPaths == null) {
            this.includedPaths = this.jsonSerializable.getList("includedPaths", IncludedPath.class, new boolean[0]);
            if (this.includedPaths == null) {
                this.includedPaths = new ArrayList<IncludedPath>();
            }
        }
        return this.includedPaths;
    }

    public IndexingPolicy setIncludedPaths(List<IncludedPath> includedPaths) {
        this.includedPaths = includedPaths;
        return this;
    }

    public List<ExcludedPath> getExcludedPaths() {
        if (this.excludedPaths == null) {
            this.excludedPaths = this.jsonSerializable.getList("excludedPaths", ExcludedPath.class, new boolean[0]);
            if (this.excludedPaths == null) {
                this.excludedPaths = new ArrayList<ExcludedPath>();
            }
        }
        return this.excludedPaths;
    }

    public IndexingPolicy setExcludedPaths(List<ExcludedPath> excludedPaths) {
        this.excludedPaths = excludedPaths;
        return this;
    }

    public List<List<CompositePath>> getCompositeIndexes() {
        if (this.compositeIndexes == null) {
            this.compositeIndexes = new ArrayList<List<CompositePath>>();
            ArrayNode compositeIndexes = (ArrayNode)this.jsonSerializable.get("compositeIndexes");
            for (int i = 0; i < compositeIndexes.size(); ++i) {
                ArrayNode compositeIndex = (ArrayNode)compositeIndexes.get(i);
                ArrayList<CompositePath> compositePaths = new ArrayList<CompositePath>();
                for (int j = 0; j < compositeIndex.size(); ++j) {
                    CompositePath candidateCompositePath = new CompositePath(compositeIndex.get(j).toString());
                    compositePaths.add(candidateCompositePath);
                }
                this.compositeIndexes.add(compositePaths);
            }
        }
        return this.compositeIndexes;
    }

    public IndexingPolicy setCompositeIndexes(List<List<CompositePath>> compositeIndexes) {
        this.compositeIndexes = compositeIndexes;
        this.jsonSerializable.set("compositeIndexes", this.compositeIndexes);
        return this;
    }

    public List<SpatialSpec> getSpatialIndexes() {
        if (this.spatialIndexes == null) {
            this.spatialIndexes = this.jsonSerializable.getList("spatialIndexes", SpatialSpec.class, new boolean[0]);
            if (this.spatialIndexes == null) {
                this.spatialIndexes = new ArrayList<SpatialSpec>();
            }
        }
        return this.spatialIndexes;
    }

    public IndexingPolicy setSpatialIndexes(List<SpatialSpec> spatialIndexes) {
        this.spatialIndexes = spatialIndexes;
        this.jsonSerializable.set("spatialIndexes", this.spatialIndexes);
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
        if (this.getIndexingMode() != IndexingMode.NONE && this.getIncludedPaths().size() == 0 && this.getExcludedPaths().size() == 0) {
            IncludedPath includedPath = new IncludedPath(DEFAULT_PATH);
            this.getIncludedPaths().add(includedPath);
        }
        if (this.includedPaths != null) {
            for (IncludedPath includedPath : this.includedPaths) {
                includedPath.populatePropertyBag();
            }
            this.jsonSerializable.set("includedPaths", this.includedPaths);
        }
        if (this.excludedPaths != null) {
            for (ExcludedPath excludedPath : this.excludedPaths) {
                excludedPath.populatePropertyBag();
            }
            this.jsonSerializable.set("excludedPaths", this.excludedPaths);
        }
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

