/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class InvalidPartitionExceptionRetryPolicy
extends DocumentClientRetryPolicy {
    private final RxCollectionCache clientCollectionCache;
    private final DocumentClientRetryPolicy nextPolicy;
    private final String collectionLink;
    private final CosmosQueryRequestOptions cosmosQueryRequestOptions;
    private RxDocumentServiceRequest request;
    private volatile boolean retried = false;

    public InvalidPartitionExceptionRetryPolicy(RxCollectionCache collectionCache, DocumentClientRetryPolicy nextPolicy, String resourceFullName, CosmosQueryRequestOptions cosmosQueryRequestOptions) {
        this.clientCollectionCache = collectionCache;
        this.nextPolicy = nextPolicy;
        this.collectionLink = Utils.getCollectionName(resourceFullName);
        this.cosmosQueryRequestOptions = cosmosQueryRequestOptions;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.nextPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        CosmosException clientException = Utils.as(e, CosmosException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 410) && Exceptions.isSubStatusCode(clientException, 1000)) {
            if (!this.retried) {
                if (this.cosmosQueryRequestOptions != null) {
                    this.clientCollectionCache.refresh(BridgeInternal.getMetaDataDiagnosticContext(this.request.requestContext.cosmosDiagnostics), this.collectionLink, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(this.cosmosQueryRequestOptions));
                } else {
                    this.clientCollectionCache.refresh(BridgeInternal.getMetaDataDiagnosticContext(this.request.requestContext.cosmosDiagnostics), this.collectionLink, null);
                }
                this.retried = true;
                return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
            }
            return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
        }
        return this.nextPolicy.shouldRetry(e);
    }
}

