/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.IRetryPolicy;
import java.util.concurrent.Callable;
import reactor.core.publisher.Mono;

public class ObservableHelper {
    public static <T> Mono<T> inlineIfPossible(Callable<Mono<T>> function, IRetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            try {
                return function.call();
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }
        return BackoffRetryUtility.executeRetry(function, retryPolicy);
    }

    public static <T> Mono<T> inlineIfPossibleAsObs(Callable<Mono<T>> function, IRetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            return Mono.defer(() -> {
                try {
                    return (Mono)function.call();
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
            });
        }
        return BackoffRetryUtility.executeRetry(() -> (Mono)function.call(), retryPolicy);
    }
}

