/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.implementation.changefeed.HealthMonitor;
import com.azure.cosmos.implementation.changefeed.HealthMonitoringRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class TraceHealthMonitor
implements HealthMonitor {
    private final Logger logger = LoggerFactory.getLogger(TraceHealthMonitor.class);

    TraceHealthMonitor() {
    }

    @Override
    public Mono<Void> inspect(HealthMonitoringRecord record) {
        return Mono.fromRunnable(() -> {
            if (record.getSeverity() == HealthMonitoringRecord.HealthSeverity.ERROR) {
                this.logger.error("Unhealthiness detected in the operation {} for {}.", new Object[]{record.operation.name(), record.lease.getId(), record.throwable});
            }
        });
    }
}

