/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.AggregateDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.DistinctDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.OrderByDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.SkipDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.TopDocumentQueryExecutionContext;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class PipelinedDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private int actualPageSize;
    private UUID correlatedActivityId;
    private QueryInfo queryInfo;

    private PipelinedDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int actualPageSize, UUID correlatedActivityId, QueryInfo queryInfo) {
        this.component = component;
        this.actualPageSize = actualPageSize;
        this.correlatedActivityId = correlatedActivityId;
        this.queryInfo = queryInfo;
    }

    public static <T extends Resource> Flux<PipelinedDocumentQueryExecutionContext<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec expression, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        Function<String, Flux> createBaseComponentFunction = queryInfo.hasOrderBy() ? continuationToken -> {
            CosmosQueryRequestOptions orderByCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(cosmosQueryRequestOptions);
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(orderByCosmosQueryRequestOptions, continuationToken);
            return OrderByDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, orderByCosmosQueryRequestOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        } : continuationToken -> {
            CosmosQueryRequestOptions parallelCosmosQueryRequestOptions = ModelBridgeInternal.createQueryRequestOptions(cosmosQueryRequestOptions);
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(parallelCosmosQueryRequestOptions, continuationToken);
            return ParallelDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, parallelCosmosQueryRequestOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        };
        Function<String, Flux> createAggregateComponentFunction = queryInfo.hasAggregates() ? continuationToken -> AggregateDocumentQueryExecutionContext.createAsync(createBaseComponentFunction, queryInfo.getAggregates(), continuationToken) : createBaseComponentFunction;
        Function<String, Flux> createDistinctComponentFunction = queryInfo.hasDistinct() ? continuationToken -> DistinctDocumentQueryExecutionContext.createAsync(createAggregateComponentFunction, queryInfo.getDistinctQueryType(), continuationToken) : createAggregateComponentFunction;
        Function<String, Flux> createSkipComponentFunction = queryInfo.hasOffset() ? continuationToken -> SkipDocumentQueryExecutionContext.createAsync(createDistinctComponentFunction, queryInfo.getOffset(), continuationToken) : createDistinctComponentFunction;
        Function<String, Flux> createTopComponentFunction = queryInfo.hasTop() ? continuationToken -> TopDocumentQueryExecutionContext.createAsync(createSkipComponentFunction, queryInfo.getTop(), queryInfo.getTop(), continuationToken) : createSkipComponentFunction;
        Function<String, Flux> createTakeComponentFunction = queryInfo.hasLimit() ? continuationToken -> {
            int totalLimit = queryInfo.getLimit();
            if (queryInfo.hasOffset()) {
                totalLimit = queryInfo.getOffset() + queryInfo.getLimit();
            }
            return TopDocumentQueryExecutionContext.createAsync(createTopComponentFunction, queryInfo.getLimit(), totalLimit, continuationToken);
        } : createTopComponentFunction;
        int actualPageSize = Utils.getValueOrDefault(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(cosmosQueryRequestOptions), 100);
        if (actualPageSize == -1) {
            actualPageSize = Integer.MAX_VALUE;
        }
        int pageSize = Math.min(actualPageSize, Utils.getValueOrDefault(queryInfo.getTop(), actualPageSize));
        return createTakeComponentFunction.apply(ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(cosmosQueryRequestOptions)).map(c -> new PipelinedDocumentQueryExecutionContext(c, pageSize, correlatedActivityId, queryInfo));
    }

    public static <T extends Resource> Flux<PipelinedDocumentQueryExecutionContext<T>> createReadManyAsync(IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuery, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceId, String collectionLink, UUID activityId, Class<T> klass, ResourceType resourceTypeEnum) {
        Flux<IDocumentQueryExecutionComponent<T>> documentQueryExecutionComponentFlux = ParallelDocumentQueryExecutionContext.createReadManyQueryAsync(queryClient, collectionResourceId, sqlQuery, rangeQueryMap, cosmosQueryRequestOptions, resourceId, collectionLink, activityId, klass, resourceTypeEnum);
        return documentQueryExecutionComponentFlux.map(c -> new PipelinedDocumentQueryExecutionContext(c, -1, activityId, null));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize);
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }
}

