/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.CosmosItemProperties;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.Utils;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;

public class CosmosItemResponse<T> {
    private final Class<T> itemClassType;
    private final byte[] responseBodyAsByteArray;
    private T item;
    private final ResourceResponse<Document> resourceResponse;
    private CosmosItemProperties props;

    CosmosItemResponse(ResourceResponse<Document> response, Class<T> classType) {
        this.itemClassType = classType;
        this.responseBodyAsByteArray = response.getBodyAsByteArray();
        this.resourceResponse = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getItem() {
        if (this.item != null) {
            return this.item;
        }
        SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(this.getDiagnostics());
        if (this.item == null && this.itemClassType == CosmosItemProperties.class) {
            Instant serializationStartTime = Instant.now();
            this.item = this.getProperties();
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
            serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
            return this.item;
        }
        if (this.item == null) {
            CosmosItemResponse cosmosItemResponse = this;
            synchronized (cosmosItemResponse) {
                if (this.item == null && !Utils.isEmpty(this.responseBodyAsByteArray)) {
                    Instant serializationStartTime = Instant.now();
                    this.item = Utils.parse(this.responseBodyAsByteArray, this.itemClassType);
                    Instant serializationEndTime = Instant.now();
                    SerializationDiagnosticsContext.SerializationDiagnostics diagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_DESERIALIZATION);
                    serializationDiagnosticsContext.addSerializationDiagnostics(diagnostics);
                }
            }
        }
        return this.item;
    }

    CosmosItemProperties getProperties() {
        this.ensureCosmosItemPropertiesInitialized();
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCosmosItemPropertiesInitialized() {
        CosmosItemResponse cosmosItemResponse = this;
        synchronized (cosmosItemResponse) {
            this.props = Utils.isEmpty(this.responseBodyAsByteArray) ? null : new CosmosItemProperties(this.responseBodyAsByteArray);
        }
    }

    public String getMaxResourceQuota() {
        return this.resourceResponse.getMaxResourceQuota();
    }

    public String getCurrentResourceQuotaUsage() {
        return this.resourceResponse.getCurrentResourceQuotaUsage();
    }

    public String getActivityId() {
        return this.resourceResponse.getActivityId();
    }

    public double getRequestCharge() {
        return this.resourceResponse.getRequestCharge();
    }

    public int getStatusCode() {
        return this.resourceResponse.getStatusCode();
    }

    public String getSessionToken() {
        return this.resourceResponse.getSessionToken();
    }

    public Map<String, String> getResponseHeaders() {
        return this.resourceResponse.getResponseHeaders();
    }

    public CosmosDiagnostics getDiagnostics() {
        return this.resourceResponse.getDiagnostics();
    }

    public Duration getDuration() {
        return this.resourceResponse.getDuration();
    }

    public String getETag() {
        return this.resourceResponse.getETag();
    }
}

