/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.http.ProxyOptions;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.GatewayConnectionConfig;
import com.azure.cosmos.ThrottlingRetryOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public final class ConnectionPolicy {
    private static final int defaultGatewayMaxConnectionPoolSize = GatewayConnectionConfig.getDefaultConfig().getMaxConnectionPoolSize();
    private static final ConnectionPolicy defaultPolicy = new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
    private ConnectionMode connectionMode;
    private boolean endpointDiscoveryEnabled;
    private Duration idleConnectionTimeout;
    private boolean multipleWriteRegionsEnabled;
    private List<String> preferredRegions;
    private boolean readRequestsFallbackEnabled;
    private ThrottlingRetryOptions throttlingRetryOptions;
    private String userAgentSuffix;
    private int maxConnectionPoolSize;
    private Duration requestTimeout;
    private ProxyOptions proxy;
    private Duration connectTimeout;
    private Duration idleEndpointTimeout;
    private int maxConnectionsPerEndpoint;
    private int maxRequestsPerConnection;

    public ConnectionPolicy(GatewayConnectionConfig gatewayConnectionConfig) {
        this(ConnectionMode.GATEWAY);
        this.idleConnectionTimeout = gatewayConnectionConfig.getIdleConnectionTimeout();
        this.maxConnectionPoolSize = gatewayConnectionConfig.getMaxConnectionPoolSize();
        this.requestTimeout = BridgeInternal.getRequestTimeoutFromGatewayConnectionConfig(gatewayConnectionConfig);
        this.proxy = gatewayConnectionConfig.getProxy();
    }

    public ConnectionPolicy(DirectConnectionConfig directConnectionConfig) {
        this(ConnectionMode.DIRECT);
        this.connectTimeout = directConnectionConfig.getConnectTimeout();
        this.idleConnectionTimeout = directConnectionConfig.getIdleConnectionTimeout();
        this.idleEndpointTimeout = directConnectionConfig.getIdleEndpointTimeout();
        this.maxConnectionsPerEndpoint = directConnectionConfig.getMaxConnectionsPerEndpoint();
        this.maxRequestsPerConnection = directConnectionConfig.getMaxRequestsPerConnection();
        this.requestTimeout = BridgeInternal.getRequestTimeoutFromDirectConnectionConfig(directConnectionConfig);
    }

    private ConnectionPolicy(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        this.endpointDiscoveryEnabled = true;
        this.maxConnectionPoolSize = defaultGatewayMaxConnectionPoolSize;
        this.multipleWriteRegionsEnabled = true;
        this.readRequestsFallbackEnabled = true;
        this.throttlingRetryOptions = new ThrottlingRetryOptions();
        this.userAgentSuffix = "";
    }

    public static ConnectionPolicy getDefaultPolicy() {
        return defaultPolicy;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public ConnectionPolicy setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ConnectionPolicy setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public ConnectionPolicy setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public ConnectionPolicy setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ConnectionPolicy setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public ThrottlingRetryOptions getThrottlingRetryOptions() {
        return this.throttlingRetryOptions;
    }

    public ConnectionPolicy setThrottlingRetryOptions(ThrottlingRetryOptions throttlingRetryOptions) {
        if (throttlingRetryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.throttlingRetryOptions = throttlingRetryOptions;
        return this;
    }

    public boolean isEndpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    public ConnectionPolicy setEndpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    public boolean isMultipleWriteRegionsEnabled() {
        return this.multipleWriteRegionsEnabled;
    }

    public boolean isReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    public ConnectionPolicy setMultipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
        this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
        return this;
    }

    public ConnectionPolicy setReadRequestsFallbackEnabled(boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
        return this;
    }

    public List<String> getPreferredRegions() {
        return this.preferredRegions != null ? this.preferredRegions : Collections.emptyList();
    }

    public ConnectionPolicy setPreferredRegions(List<String> preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    public ConnectionPolicy setProxy(ProxyOptions proxy) {
        this.proxy = proxy;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public ConnectionPolicy setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getIdleEndpointTimeout() {
        return this.idleEndpointTimeout;
    }

    public ConnectionPolicy setIdleEndpointTimeout(Duration idleEndpointTimeout) {
        this.idleEndpointTimeout = idleEndpointTimeout;
        return this;
    }

    public int getMaxConnectionsPerEndpoint() {
        return this.maxConnectionsPerEndpoint;
    }

    public ConnectionPolicy setMaxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
        this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        return this;
    }

    public int getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public ConnectionPolicy setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        return this;
    }

    public String toString() {
        return "ConnectionPolicy{requestTimeout=" + this.requestTimeout + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", throttlingRetryOptions=" + this.throttlingRetryOptions + ", endpointDiscoveryEnabled=" + this.endpointDiscoveryEnabled + ", preferredRegions=" + this.preferredRegions + ", multipleWriteRegionsEnabled=" + this.multipleWriteRegionsEnabled + ", proxyType=" + (this.proxy != null ? this.proxy.getType() : null) + ", inetSocketProxyAddress=" + (this.proxy != null ? this.proxy.getAddress() : null) + ", readRequestsFallbackEnabled=" + this.readRequestsFallbackEnabled + ", connectTimeout=" + this.connectTimeout + ", idleEndpointTimeout=" + this.idleEndpointTimeout + ", maxConnectionsPerEndpoint=" + this.maxConnectionsPerEndpoint + ", maxRequestsPerConnection=" + this.maxRequestsPerConnection + '}';
    }
}

