/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.DiagnosticsInstantSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SerializationDiagnosticsContext {
    public volatile List<SerializationDiagnostics> serializationDiagnosticsList;

    public void addSerializationDiagnostics(SerializationDiagnostics serializationDiagnostics) {
        if (this.serializationDiagnosticsList == null) {
            this.serializationDiagnosticsList = Collections.synchronizedList(new ArrayList());
        }
        this.serializationDiagnosticsList.add(serializationDiagnostics);
    }

    public static enum SerializationType {
        DATABASE_DESERIALIZATION,
        DATABASE_SERIALIZATION,
        CONTAINER_DESERIALIZATION,
        CONTAINER_SERIALIZATION,
        ITEM_DESERIALIZATION,
        ITEM_SERIALIZATION,
        PARTITION_KEY_FETCH_SERIALIZATION;

    }

    static class SerializationDiagnosticsSerializer
    extends StdSerializer<SerializationDiagnostics> {
        private static final long serialVersionUID = -1679638551521266979L;

        public SerializationDiagnosticsSerializer() {
            super(SerializationDiagnostics.class);
        }

        public void serialize(SerializationDiagnostics serializationDiagnostics, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            Duration durationinMS = serializationDiagnostics.startTimeUTC == null ? null : (serializationDiagnostics.endTimeUTC == null ? Duration.ZERO : Duration.between(serializationDiagnostics.startTimeUTC, serializationDiagnostics.endTimeUTC));
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("serializationType", (Object)serializationDiagnostics.serializationType);
            jsonGenerator.writeStringField("startTimeUTC", DiagnosticsInstantSerializer.formatDateTime(serializationDiagnostics.startTimeUTC));
            jsonGenerator.writeStringField("endTimeUTC", DiagnosticsInstantSerializer.formatDateTime(serializationDiagnostics.endTimeUTC));
            if (durationinMS != null) {
                jsonGenerator.writeNumberField("durationInMicroSec", durationinMS.toNanos() / 1000L);
            }
            jsonGenerator.writeEndObject();
        }
    }

    @JsonSerialize(using=SerializationDiagnosticsSerializer.class)
    public static class SerializationDiagnostics {
        public volatile Instant startTimeUTC;
        public volatile Instant endTimeUTC;
        public volatile SerializationType serializationType;

        public SerializationDiagnostics(Instant startTimeUTC, Instant endTimeUTC, SerializationType serializationType) {
            this.startTimeUTC = startTimeUTC;
            this.endTimeUTC = endTimeUTC;
            this.serializationType = serializationType;
        }
    }
}

