/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ErrorUtils {
    private static final Logger logger = LoggerFactory.getLogger(ErrorUtils.class);

    static Mono<String> getErrorResponseAsync(HttpResponse responseMessage, HttpRequest request) {
        Mono responseAsString = responseMessage.bodyAsString().switchIfEmpty(Mono.just((Object)""));
        if (request.httpMethod() == HttpMethod.DELETE) {
            return Mono.just((Object)"");
        }
        return responseAsString;
    }

    static void logGoneException(URI physicalAddress, String activityId) {
        logger.trace("Listener not found. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }

    protected static void logGoneException(String physicalAddress, String activityId) {
        logger.trace("Listener not found. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }

    static void logException(URI physicalAddress, String activityId) {
        logger.trace("Store Request Failed. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }

    protected static void logException(String physicalAddress, String activityId) {
        logger.trace("Store Request Failed. Store Physical Address {} ActivityId {}", (Object)physicalAddress, (Object)activityId);
    }
}

