/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.JavaStreamUtils;
import com.azure.cosmos.implementation.MutableVolatile;
import com.azure.cosmos.implementation.Quadruple;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.directconnectivity.AddressSelector;
import com.azure.cosmos.implementation.directconnectivity.BarrierRequestHelper;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.ReadMode;
import com.azure.cosmos.implementation.directconnectivity.ReplicatedResourceClient;
import com.azure.cosmos.implementation.directconnectivity.StoreReader;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class QuorumReader {
    private static final Logger logger = LoggerFactory.getLogger(QuorumReader.class);
    private final int maxNumberOfReadBarrierReadRetries;
    private final int maxNumberOfPrimaryReadRetries;
    private final int maxNumberOfReadQuorumRetries;
    private final int delayBetweenReadBarrierCallsInMs;
    private final int maxBarrierRetriesForMultiRegion;
    private final int barrierRetryIntervalInMsForMultiRegion;
    private final int maxShortBarrierRetriesForMultiRegion;
    private final int shortBarrierRetryIntervalInMsForMultiRegion;
    private final StoreReader storeReader;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    private final IAuthorizationTokenProvider authorizationTokenProvider;

    public QuorumReader(Configs configs, TransportClient transportClient, AddressSelector addressSelector, StoreReader storeReader, GatewayServiceConfigurationReader serviceConfigReader, IAuthorizationTokenProvider authorizationTokenProvider) {
        this.storeReader = storeReader;
        this.serviceConfigReader = serviceConfigReader;
        this.authorizationTokenProvider = authorizationTokenProvider;
        this.maxNumberOfReadBarrierReadRetries = configs.getMaxNumberOfReadBarrierReadRetries();
        this.maxNumberOfPrimaryReadRetries = configs.getMaxNumberOfPrimaryReadRetries();
        this.maxNumberOfReadQuorumRetries = configs.getMaxNumberOfReadQuorumRetries();
        this.delayBetweenReadBarrierCallsInMs = configs.getDelayBetweenReadBarrierCallsInMs();
        this.maxBarrierRetriesForMultiRegion = configs.getMaxBarrierRetriesForMultiRegion();
        this.barrierRetryIntervalInMsForMultiRegion = configs.getBarrierRetryIntervalInMsForMultiRegion();
        this.maxShortBarrierRetriesForMultiRegion = configs.getMaxShortBarrierRetriesForMultiRegion();
        this.shortBarrierRetryIntervalInMsForMultiRegion = configs.getShortBarrierRetryIntervalInMsForMultiRegion();
    }

    public QuorumReader(TransportClient transportClient, AddressSelector addressSelector, StoreReader storeReader, GatewayServiceConfigurationReader serviceConfigReader, IAuthorizationTokenProvider authorizationTokenProvider, Configs configs) {
        this(configs, transportClient, addressSelector, storeReader, serviceConfigReader, authorizationTokenProvider);
    }

    public Mono<StoreResponse> readStrongAsync(RxDocumentServiceRequest entity, int readQuorumValue, ReadMode readMode) {
        MutableVolatile<Boolean> shouldRetryOnSecondary = new MutableVolatile<Boolean>(false);
        MutableVolatile<Boolean> hasPerformedReadFromPrimary = new MutableVolatile<Boolean>(false);
        return Flux.defer(() -> {
            if (entity.requestContext.timeoutHelper.isElapsed()) {
                return Flux.error((Throwable)((Object)new GoneException()));
            }
            shouldRetryOnSecondary.v = false;
            Mono<ReadQuorumResult> secondaryQuorumReadResultObs = this.readQuorumAsync(entity, readQuorumValue, false, readMode);
            return secondaryQuorumReadResultObs.flux().flatMap(secondaryQuorumReadResult -> {
                switch (secondaryQuorumReadResult.quorumResult) {
                    case QuorumMet: {
                        try {
                            return Flux.just((Object)secondaryQuorumReadResult.getResponse());
                        }
                        catch (CosmosException e) {
                            return Flux.error((Throwable)((Object)e));
                        }
                    }
                    case QuorumSelected: {
                        Mono<RxDocumentServiceRequest> barrierRequestObs = BarrierRequestHelper.createAsync(entity, this.authorizationTokenProvider, secondaryQuorumReadResult.selectedLsn, secondaryQuorumReadResult.globalCommittedSelectedLsn);
                        return barrierRequestObs.flux().flatMap(barrierRequest -> {
                            Mono<Boolean> readBarrierObs = this.waitForReadBarrierAsync((RxDocumentServiceRequest)barrierRequest, true, readQuorumValue, secondaryQuorumReadResult.selectedLsn, secondaryQuorumReadResult.globalCommittedSelectedLsn, readMode);
                            return readBarrierObs.flux().flatMap(readBarrier -> {
                                if (readBarrier.booleanValue()) {
                                    try {
                                        return Flux.just((Object)secondaryQuorumReadResult.getResponse());
                                    }
                                    catch (Exception e) {
                                        return Flux.error((Throwable)e);
                                    }
                                }
                                logger.warn("QuorumSelected: Could not converge on the LSN {} GlobalCommittedLSN {} after primary read barrier with read quorum {} for strong read, Responses: {}", new Object[]{secondaryQuorumReadResult.selectedLsn, secondaryQuorumReadResult.globalCommittedSelectedLsn, readQuorumValue, String.join((CharSequence)";", secondaryQuorumReadResult.storeResponses)});
                                entity.requestContext.quorumSelectedStoreResponse = secondaryQuorumReadResult.selectedResponse;
                                entity.requestContext.storeResponses = secondaryQuorumReadResult.storeResponses;
                                entity.requestContext.quorumSelectedLSN = secondaryQuorumReadResult.selectedLsn;
                                entity.requestContext.globalCommittedSelectedLSN = secondaryQuorumReadResult.globalCommittedSelectedLsn;
                                return Flux.empty();
                            });
                        });
                    }
                    case QuorumNotSelected: {
                        if (((Boolean)hasPerformedReadFromPrimary.v).booleanValue()) {
                            logger.warn("QuorumNotSelected: Primary read already attempted. Quorum could not be selected after retrying on secondaries.");
                            return Flux.error((Throwable)((Object)new GoneException("READ Quorum size of %d is not met for the request.")));
                        }
                        logger.warn("QuorumNotSelected: Quorum could not be selected with read quorum of {}", (Object)readQuorumValue);
                        Mono<ReadPrimaryResult> responseObs = this.readPrimaryAsync(entity, readQuorumValue, false);
                        return responseObs.flux().flatMap(response -> {
                            if (response.isSuccessful && response.shouldRetryOnSecondary) {
                                assert (false) : "QuorumNotSelected: PrimaryResult has both Successful and shouldRetryOnSecondary flags set";
                                logger.error("PrimaryResult has both Successful and shouldRetryOnSecondary flags set");
                            } else {
                                if (response.isSuccessful) {
                                    logger.debug("QuorumNotSelected: ReadPrimary successful");
                                    try {
                                        return Flux.just((Object)response.getResponse());
                                    }
                                    catch (CosmosException e) {
                                        return Flux.error((Throwable)((Object)e));
                                    }
                                }
                                if (response.shouldRetryOnSecondary) {
                                    shouldRetryOnSecondary.v = true;
                                    logger.warn("QuorumNotSelected: ReadPrimary did not succeed. Will retry on secondary.");
                                    hasPerformedReadFromPrimary.v = true;
                                } else {
                                    logger.warn("QuorumNotSelected: Could not get successful response from ReadPrimary");
                                    return Flux.error((Throwable)((Object)new GoneException(String.format("READ Quorum size of %d is not met for the request.", readQuorumValue))));
                                }
                            }
                            return Flux.empty();
                        });
                    }
                }
                logger.error("Unknown ReadQuorum result {}", (Object)secondaryQuorumReadResult.quorumResult.toString());
                return Flux.error((Throwable)((Object)new InternalServerErrorException("Unknown server error occurred when processing this request.")));
            });
        }).repeat((long)this.maxNumberOfReadQuorumRetries).takeUntil(dummy -> (Boolean)shouldRetryOnSecondary.v == false).concatWith((Publisher)Flux.defer(() -> {
            logger.warn("Could not complete read quorum with read quorum value of {}", (Object)readQuorumValue);
            return Flux.error((Throwable)((Object)new GoneException(String.format("READ Quorum size of %d is not met for the request.", readQuorumValue))));
        })).take(1L).single();
    }

    private Mono<ReadQuorumResult> readQuorumAsync(RxDocumentServiceRequest entity, int readQuorum, boolean includePrimary, ReadMode readMode) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Mono.error((Throwable)((Object)new GoneException()));
        }
        return this.ensureQuorumSelectedStoreResponse(entity, readQuorum, includePrimary, readMode).flatMap(res -> {
            if (res.getLeft() != null) {
                return Mono.just((Object)((ReadQuorumResult)res.getKey()));
            }
            long readLsn = (Long)((Quadruple)res.getValue()).getValue0();
            long globalCommittedLSN = (Long)((Quadruple)res.getValue()).getValue1();
            StoreResult storeResult = (StoreResult)((Quadruple)res.getValue()).getValue2();
            List storeResponses = (List)((Quadruple)res.getValue()).getValue3();
            Mono<RxDocumentServiceRequest> barrierRequestObs = BarrierRequestHelper.createAsync(entity, this.authorizationTokenProvider, readLsn, globalCommittedLSN);
            return barrierRequestObs.flatMap(barrierRequest -> {
                Mono<Boolean> waitForObs = this.waitForReadBarrierAsync((RxDocumentServiceRequest)barrierRequest, false, readQuorum, readLsn, globalCommittedLSN, readMode);
                return waitForObs.flatMap(waitFor -> {
                    if (!waitFor.booleanValue()) {
                        return Mono.just((Object)new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumSelected, readLsn, globalCommittedLSN, storeResult, storeResponses));
                    }
                    return Mono.just((Object)new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumMet, readLsn, globalCommittedLSN, storeResult, storeResponses));
                });
            });
        });
    }

    private Mono<Pair<ReadQuorumResult, Quadruple<Long, Long, StoreResult, List<String>>>> ensureQuorumSelectedStoreResponse(RxDocumentServiceRequest entity, int readQuorum, boolean includePrimary, ReadMode readMode) {
        if (entity.requestContext.quorumSelectedStoreResponse == null) {
            Mono<List<StoreResult>> responseResultObs = this.storeReader.readMultipleReplicaAsync(entity, includePrimary, readQuorum, true, false, readMode);
            return responseResultObs.flatMap(responseResult -> {
                Utils.ValueHolder<Object> storeResult;
                Utils.ValueHolder<Long> globalCommittedLSN;
                Utils.ValueHolder<Long> readLsn;
                List<String> storeResponses = responseResult.stream().map(response -> response.toString()).collect(Collectors.toList());
                int responseCount = (int)responseResult.stream().filter(response -> response.isValid).count();
                if (responseCount < readQuorum) {
                    return Mono.just(Pair.of(new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumNotSelected, -1L, -1L, null, storeResponses), null));
                }
                boolean isGlobalStrongReadCandidate = ReplicatedResourceClient.isGlobalStrongEnabled() && this.serviceConfigReader.getDefaultConsistencyLevel() == ConsistencyLevel.STRONG && (entity.requestContext.originalRequestConsistencyLevel == null || entity.requestContext.originalRequestConsistencyLevel == ConsistencyLevel.STRONG);
                if (this.isQuorumMet((List<StoreResult>)responseResult, readQuorum, false, isGlobalStrongReadCandidate, readLsn = new Utils.ValueHolder<Long>(-1L), globalCommittedLSN = new Utils.ValueHolder<Long>(-1L), (Utils.ValueHolder<StoreResult>)(storeResult = new Utils.ValueHolder<Object>(null)))) {
                    return Mono.just(Pair.of(new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumMet, (Long)readLsn.v, (Long)globalCommittedLSN.v, (StoreResult)storeResult.v, storeResponses), null));
                }
                entity.requestContext.forceRefreshAddressCache = false;
                Quadruple<Long, Long, StoreResult, List<String>> state = Quadruple.with((Long)readLsn.v, (Long)globalCommittedLSN.v, (StoreResult)storeResult.v, storeResponses);
                return Mono.just(Pair.of(null, state));
            });
        }
        Utils.ValueHolder<Long> readLsn = Utils.ValueHolder.initialize(entity.requestContext.quorumSelectedLSN);
        Utils.ValueHolder<Long> globalCommittedLSN = Utils.ValueHolder.initialize(entity.requestContext.globalCommittedSelectedLSN);
        Utils.ValueHolder<StoreResult> storeResult = Utils.ValueHolder.initialize(entity.requestContext.quorumSelectedStoreResponse);
        List<String> storeResponses = entity.requestContext.storeResponses;
        Quadruple<Long, Long, StoreResult, List<String>> state = Quadruple.with((Long)readLsn.v, (Long)globalCommittedLSN.v, (StoreResult)storeResult.v, storeResponses);
        return Mono.just(Pair.of(null, state));
    }

    private Mono<ReadPrimaryResult> readPrimaryAsync(RxDocumentServiceRequest entity, int readQuorum, boolean useSessionToken) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Mono.error((Throwable)((Object)new GoneException()));
        }
        entity.requestContext.forceRefreshAddressCache = false;
        Mono<StoreResult> storeResultObs = this.storeReader.readPrimaryAsync(entity, true, useSessionToken);
        return storeResultObs.flatMap(storeResult -> {
            if (!storeResult.isValid) {
                try {
                    return Mono.error((Throwable)((Object)storeResult.getException()));
                }
                catch (InternalServerErrorException e) {
                    return Mono.error((Throwable)((Object)e));
                }
            }
            if (storeResult.currentReplicaSetSize <= 0 || storeResult.lsn < 0L || storeResult.quorumAckedLSN < 0L) {
                String message = String.format("INVALID value received from response header. CurrentReplicaSetSize %d, StoreLSN %d, QuorumAckedLSN %d", storeResult.currentReplicaSetSize, storeResult.lsn, storeResult.quorumAckedLSN);
                logger.error(message);
                return Mono.error((Throwable)((Object)new GoneException(String.format("READ Quorum size of %d is not met for the request.", readQuorum))));
            }
            if (storeResult.currentReplicaSetSize > readQuorum) {
                logger.warn("Unexpected response. Replica Set size is {} which is greater than min value {}", (Object)storeResult.currentReplicaSetSize, (Object)readQuorum);
                return Mono.just((Object)new ReadPrimaryResult(entity.requestContext.requestChargeTracker, false, true, null));
            }
            if (storeResult.lsn != storeResult.quorumAckedLSN) {
                logger.warn("Store LSN {} and quorum acked LSN {} don't match", (Object)storeResult.lsn, (Object)storeResult.quorumAckedLSN);
                long higherLsn = storeResult.lsn > storeResult.quorumAckedLSN ? storeResult.lsn : storeResult.quorumAckedLSN;
                Mono<RxDocumentServiceRequest> waitForLsnRequestObs = BarrierRequestHelper.createAsync(entity, this.authorizationTokenProvider, higherLsn, null);
                return waitForLsnRequestObs.flatMap(waitForLsnRequest -> {
                    Mono<PrimaryReadOutcome> primaryWaitForLsnResponseObs = this.waitForPrimaryLsnAsync((RxDocumentServiceRequest)waitForLsnRequest, higherLsn, readQuorum);
                    return primaryWaitForLsnResponseObs.map(primaryWaitForLsnResponse -> {
                        if (primaryWaitForLsnResponse == PrimaryReadOutcome.QuorumNotMet) {
                            return new ReadPrimaryResult(entity.requestContext.requestChargeTracker, false, false, null);
                        }
                        if (primaryWaitForLsnResponse == PrimaryReadOutcome.QuorumInconclusive) {
                            return new ReadPrimaryResult(entity.requestContext.requestChargeTracker, false, true, null);
                        }
                        return new ReadPrimaryResult(entity.requestContext.requestChargeTracker, true, false, (StoreResult)storeResult);
                    });
                });
            }
            return Mono.just((Object)new ReadPrimaryResult(entity.requestContext.requestChargeTracker, true, false, (StoreResult)storeResult));
        });
    }

    private Mono<PrimaryReadOutcome> waitForPrimaryLsnAsync(RxDocumentServiceRequest barrierRequest, long lsnToWaitFor, int readQuorum) {
        return Flux.defer(() -> {
            if (barrierRequest.requestContext.timeoutHelper.isElapsed()) {
                return Flux.error((Throwable)((Object)new GoneException()));
            }
            barrierRequest.requestContext.forceRefreshAddressCache = false;
            Mono<StoreResult> storeResultObs = this.storeReader.readPrimaryAsync(barrierRequest, true, false);
            return storeResultObs.flux().flatMap(storeResult -> {
                if (!storeResult.isValid) {
                    try {
                        return Flux.error((Throwable)((Object)storeResult.getException()));
                    }
                    catch (InternalServerErrorException e) {
                        return Flux.error((Throwable)((Object)e));
                    }
                }
                if (storeResult.currentReplicaSetSize > readQuorum) {
                    logger.warn("Unexpected response. Replica Set size is {} which is greater than min value {}", (Object)storeResult.currentReplicaSetSize, (Object)readQuorum);
                    return Flux.just((Object)((Object)PrimaryReadOutcome.QuorumInconclusive));
                }
                if (storeResult.lsn < lsnToWaitFor || storeResult.quorumAckedLSN < lsnToWaitFor) {
                    logger.warn("Store LSN {} or quorum acked LSN {} are lower than expected LSN {}", new Object[]{storeResult.lsn, storeResult.quorumAckedLSN, lsnToWaitFor});
                    return Flux.just((Object)0L).delayElements(Duration.ofMillis(this.delayBetweenReadBarrierCallsInMs)).flatMap(dummy -> Flux.empty());
                }
                return Flux.just((Object)((Object)PrimaryReadOutcome.QuorumMet));
            });
        }).repeat((long)this.maxNumberOfPrimaryReadRetries).defaultIfEmpty((Object)PrimaryReadOutcome.QuorumNotMet).take(1L).single();
    }

    private Mono<Boolean> waitForReadBarrierAsync(RxDocumentServiceRequest barrierRequest, boolean allowPrimary, int readQuorum, long readBarrierLsn, long targetGlobalCommittedLSN, ReadMode readMode) {
        AtomicInteger readBarrierRetryCount = new AtomicInteger(this.maxNumberOfReadBarrierReadRetries);
        AtomicInteger readBarrierRetryCountMultiRegion = new AtomicInteger(this.maxBarrierRetriesForMultiRegion);
        AtomicLong maxGlobalCommittedLsn = new AtomicLong(0L);
        return Flux.defer(() -> {
            if (barrierRequest.requestContext.timeoutHelper.isElapsed()) {
                return Flux.error((Throwable)((Object)new GoneException()));
            }
            Mono<List<StoreResult>> responsesObs = this.storeReader.readMultipleReplicaAsync(barrierRequest, allowPrimary, readQuorum, true, false, readMode, false, true);
            return responsesObs.flux().flatMap(responses -> {
                long maxGlobalCommittedLsnInResponses;
                long l = maxGlobalCommittedLsnInResponses = responses.size() > 0 ? responses.stream().mapToLong(response -> response.globalCommittedLSN).max().getAsLong() : 0L;
                if (responses.stream().filter(response -> response.lsn >= readBarrierLsn).count() >= (long)readQuorum && (targetGlobalCommittedLSN <= 0L || maxGlobalCommittedLsnInResponses >= targetGlobalCommittedLSN)) {
                    return Flux.just((Object)true);
                }
                maxGlobalCommittedLsn.set(maxGlobalCommittedLsn.get() > maxGlobalCommittedLsnInResponses ? maxGlobalCommittedLsn.get() : maxGlobalCommittedLsnInResponses);
                barrierRequest.requestContext.forceRefreshAddressCache = false;
                if (readBarrierRetryCount.decrementAndGet() == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("QuorumReader: waitForReadBarrierAsync - Last barrier for single-region requests. Responses: {}", (Object)JavaStreamUtils.toString(responses, "; "));
                    }
                    return Flux.just((Object)false);
                }
                return Flux.empty();
            });
        }).repeatWhen(obs -> obs.flatMap(aVoid -> Flux.just((Object)0L).delayElements(Duration.ofMillis(this.delayBetweenReadBarrierCallsInMs)))).take(1L).flatMap(barrierRequestSucceeded -> Flux.defer(() -> {
            if (barrierRequestSucceeded.booleanValue()) {
                return Flux.just((Object)true);
            }
            if (targetGlobalCommittedLSN > 0L) {
                return Flux.defer(() -> {
                    if (barrierRequest.requestContext.timeoutHelper.isElapsed()) {
                        return Flux.error((Throwable)((Object)new GoneException()));
                    }
                    Mono<List<StoreResult>> responsesObs = this.storeReader.readMultipleReplicaAsync(barrierRequest, allowPrimary, readQuorum, true, false, readMode, false, true);
                    return responsesObs.flux().flatMap(responses -> {
                        long maxGlobalCommittedLsnInResponses;
                        long l = maxGlobalCommittedLsnInResponses = responses.size() > 0 ? responses.stream().mapToLong(response -> response.globalCommittedLSN).max().getAsLong() : 0L;
                        if (responses.stream().filter(response -> response.lsn >= readBarrierLsn).count() >= (long)readQuorum && maxGlobalCommittedLsnInResponses >= targetGlobalCommittedLSN) {
                            return Flux.just((Object)true);
                        }
                        maxGlobalCommittedLsn.set(maxGlobalCommittedLsn.get() > maxGlobalCommittedLsnInResponses ? maxGlobalCommittedLsn.get() : maxGlobalCommittedLsnInResponses);
                        if (readBarrierRetryCountMultiRegion.getAndDecrement() == 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("QuorumReader: waitForReadBarrierAsync - Last barrier for mult-region strong requests. Responses: {}", (Object)JavaStreamUtils.toString(responses, "; "));
                            }
                            return Flux.just((Object)false);
                        }
                        return Flux.empty();
                    });
                }).repeatWhen(obs -> obs.flatMap(aVoid -> {
                    if (this.maxBarrierRetriesForMultiRegion - readBarrierRetryCountMultiRegion.get() > this.maxShortBarrierRetriesForMultiRegion) {
                        return Flux.just((Object)0L).delayElements(Duration.ofMillis(this.barrierRetryIntervalInMsForMultiRegion));
                    }
                    return Flux.just((Object)0L).delayElements(Duration.ofMillis(this.shortBarrierRetryIntervalInMsForMultiRegion));
                })).take(1L);
            }
            return Flux.empty();
        })).concatWith((Publisher)Flux.defer(() -> {
            logger.debug("QuorumReader: waitForReadBarrierAsync - TargetGlobalCommittedLsn: {}, MaxGlobalCommittedLsn: {}.", (Object)targetGlobalCommittedLSN, (Object)maxGlobalCommittedLsn);
            return Flux.just((Object)false);
        })).take(1L).single();
    }

    private boolean isQuorumMet(List<StoreResult> readResponses, int readQuorum, boolean isPrimaryIncluded, boolean isGlobalStrongRead, Utils.ValueHolder<Long> readLsn, Utils.ValueHolder<Long> globalCommittedLSN, Utils.ValueHolder<StoreResult> selectedResponse) {
        long maxLsn = 0L;
        long minLsn = Long.MAX_VALUE;
        int replicaCountMaxLsn = 0;
        List validReadResponses = readResponses.stream().filter(response -> response.isValid).collect(Collectors.toList());
        int validResponsesCount = validReadResponses.size();
        if (validResponsesCount == 0) {
            readLsn.v = 0L;
            globalCommittedLSN.v = -1L;
            selectedResponse.v = null;
            return false;
        }
        assert (!validReadResponses.isEmpty());
        long numberOfReadRegions = validReadResponses.stream().map(res -> res.numberOfReadRegions).max(Comparator.naturalOrder()).get();
        boolean checkForGlobalStrong = isGlobalStrongRead && numberOfReadRegions > 0L;
        for (StoreResult response2 : validReadResponses) {
            if (response2.lsn == maxLsn) {
                ++replicaCountMaxLsn;
            } else if (response2.lsn > maxLsn) {
                replicaCountMaxLsn = 1;
                maxLsn = response2.lsn;
            }
            if (response2.lsn >= minLsn) continue;
            minLsn = response2.lsn;
        }
        long maxLsnFinal = maxLsn;
        selectedResponse.v = validReadResponses.stream().filter(s -> s.lsn == maxLsnFinal).findFirst().get();
        readLsn.v = ((StoreResult)selectedResponse.v).itemLSN == -1L ? maxLsn : Math.min(((StoreResult)selectedResponse.v).itemLSN, maxLsn);
        globalCommittedLSN.v = checkForGlobalStrong ? (Long)readLsn.v : -1L;
        long maxGlobalCommittedLSN = validReadResponses.stream().mapToLong(res -> res.globalCommittedLSN).max().getAsLong();
        logger.debug("QuorumReader: MaxLSN {} ReplicaCountMaxLSN {} bCheckGlobalStrong {} MaxGlobalCommittedLSN {} NumberOfReadRegions {} SelectedResponseItemLSN {}", new Object[]{maxLsn, replicaCountMaxLsn, checkForGlobalStrong, maxGlobalCommittedLSN, numberOfReadRegions, ((StoreResult)selectedResponse.v).itemLSN});
        boolean isQuorumMet = false;
        if (!((Long)readLsn.v <= 0L || replicaCountMaxLsn < readQuorum || checkForGlobalStrong && maxGlobalCommittedLSN < maxLsn)) {
            isQuorumMet = true;
        }
        if (!(isQuorumMet || validResponsesCount < readQuorum || ((StoreResult)selectedResponse.v).itemLSN == -1L || minLsn == Long.MAX_VALUE || ((StoreResult)selectedResponse.v).itemLSN > minLsn || checkForGlobalStrong && ((StoreResult)selectedResponse.v).itemLSN > maxGlobalCommittedLSN)) {
            isQuorumMet = true;
        }
        return isQuorumMet;
    }

    private static enum PrimaryReadOutcome {
        QuorumNotMet,
        QuorumInconclusive,
        QuorumMet;

    }

    private class ReadPrimaryResult
    extends ReadResult {
        public final boolean shouldRetryOnSecondary;
        public final boolean isSuccessful;

        public ReadPrimaryResult(RequestChargeTracker requestChargeTracker, boolean isSuccessful, boolean shouldRetryOnSecondary, StoreResult response) {
            super(requestChargeTracker, response);
            this.isSuccessful = isSuccessful;
            this.shouldRetryOnSecondary = shouldRetryOnSecondary;
        }

        @Override
        protected boolean isValidResult() {
            return this.isSuccessful;
        }
    }

    private class ReadQuorumResult
    extends ReadResult {
        public final ReadQuorumResultKind quorumResult;
        public final StoreResult selectedResponse;
        public final List<String> storeResponses;
        public final long selectedLsn;
        public final long globalCommittedSelectedLsn;

        public ReadQuorumResult(RequestChargeTracker requestChargeTracker, ReadQuorumResultKind QuorumResult, long selectedLsn, long globalCommittedSelectedLsn, StoreResult selectedResponse, List<String> storeResponses) {
            super(requestChargeTracker, selectedResponse);
            this.quorumResult = QuorumResult;
            this.selectedLsn = selectedLsn;
            this.globalCommittedSelectedLsn = globalCommittedSelectedLsn;
            this.selectedResponse = selectedResponse;
            this.storeResponses = storeResponses;
        }

        @Override
        protected boolean isValidResult() {
            return this.quorumResult == ReadQuorumResultKind.QuorumMet || this.quorumResult == ReadQuorumResultKind.QuorumSelected;
        }
    }

    private abstract class ReadResult {
        private final StoreResult response;
        private final RequestChargeTracker requestChargeTracker;

        protected ReadResult(RequestChargeTracker requestChargeTracker, StoreResult response) {
            this.requestChargeTracker = requestChargeTracker;
            this.response = response;
        }

        public StoreResponse getResponse() {
            if (!this.isValidResult()) {
                logger.error("getResponse called for invalid result");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request.");
            }
            return this.response.toResponse(this.requestChargeTracker);
        }

        protected abstract boolean isValidResult();
    }

    private static enum ReadQuorumResultKind {
        QuorumMet,
        QuorumSelected,
        QuorumNotSelected;

    }
}

