/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdClientChannelHandler;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdClientChannelHealthChecker;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdHealthCheckRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdReporter;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestManager;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdServiceEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdThreadFactory;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.AttributeKey;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.time.Instant;
import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdClientChannelPool
implements ChannelPool {
    private static final TimeoutException ACQUISITION_TIMEOUT = (TimeoutException)ThrowableUtil.unknownStackTrace((Throwable)new TimeoutException("acquisition took longer than the configured maximum time"), RntbdClientChannelPool.class, (String)"<init>");
    private static final ClosedChannelException CHANNEL_CLOSED_ON_ACQUIRE = (ClosedChannelException)ThrowableUtil.unknownStackTrace((Throwable)new ClosedChannelException(), RntbdClientChannelPool.class, (String)"acquire");
    private static final IllegalStateException POOL_CLOSED_ON_ACQUIRE = (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new StacklessIllegalStateException("service endpoint was closed"), RntbdClientChannelPool.class, (String)"acquire");
    private static final IllegalStateException POOL_CLOSED_ON_RELEASE = (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new StacklessIllegalStateException("service endpoint was closed"), RntbdClientChannelPool.class, (String)"release");
    private static final AttributeKey<RntbdClientChannelPool> POOL_KEY = AttributeKey.newInstance((String)RntbdClientChannelPool.class.getName());
    private static final IllegalStateException TOO_MANY_PENDING_ACQUISITIONS = (IllegalStateException)ThrowableUtil.unknownStackTrace((Throwable)new StacklessIllegalStateException("too many outstanding acquire operations"), RntbdClientChannelPool.class, (String)"acquire");
    private static final EventExecutor closer = new DefaultEventExecutor((ThreadFactory)new RntbdThreadFactory("channel-pool-closer", true, 5));
    private static final HashedWheelTimer acquisitionAndIdleEndpointDetectionTimer = new HashedWheelTimer((ThreadFactory)new RntbdThreadFactory("channel-acquisition-timer", true, 5));
    private static final Logger logger = LoggerFactory.getLogger(RntbdClientChannelPool.class);
    private final long acquisitionTimeoutInNanos;
    private final Runnable acquisitionTimeoutTask;
    private final PooledByteBufAllocatorMetric allocatorMetric;
    private final Bootstrap bootstrap;
    private final EventExecutor executor;
    private final ChannelHealthChecker healthChecker;
    private final int maxChannels;
    private final int maxPendingAcquisitions;
    private final int maxRequestsPerChannel;
    private final ChannelPoolHandler poolHandler;
    private final boolean releaseHealthCheck;
    private final AtomicReference<Timeout> acquisitionAndIdleEndpointDetectionTimeout = new AtomicReference();
    private final ConcurrentHashMap<Channel, Channel> acquiredChannels = new ConcurrentHashMap();
    private final Deque<Channel> availableChannels = new ConcurrentLinkedDeque<Channel>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean connecting = new AtomicBoolean();
    private final Queue<AcquireTask> pendingAcquisitions = new ConcurrentLinkedQueue<AcquireTask>();

    RntbdClientChannelPool(RntbdServiceEndpoint endpoint, Bootstrap bootstrap, RntbdEndpoint.Config config) {
        this(endpoint, bootstrap, config, new RntbdClientChannelHealthChecker(config));
    }

    private RntbdClientChannelPool(RntbdServiceEndpoint endpoint, Bootstrap bootstrap, RntbdEndpoint.Config config, RntbdClientChannelHealthChecker healthChecker) {
        Preconditions.checkNotNull(endpoint, "expected non-null endpoint");
        Preconditions.checkNotNull(bootstrap, "expected non-null bootstrap");
        Preconditions.checkNotNull(config, "expected non-null config");
        Preconditions.checkNotNull(healthChecker, "expected non-null healthChecker");
        this.poolHandler = new RntbdClientChannelHandler(config, healthChecker);
        this.executor = bootstrap.config().group().next();
        this.healthChecker = healthChecker;
        this.bootstrap = (Bootstrap)bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                Preconditions.checkState(channel.eventLoop().inEventLoop());
                RntbdClientChannelPool.this.poolHandler.channelCreated(channel);
            }
        });
        this.acquisitionTimeoutInNanos = config.connectionAcquisitionTimeoutInNanos();
        this.allocatorMetric = config.allocator().metric();
        this.maxChannels = config.maxChannelsPerEndpoint();
        this.maxRequestsPerChannel = config.maxRequestsPerChannel();
        this.maxPendingAcquisitions = Integer.MAX_VALUE;
        this.releaseHealthCheck = true;
        this.acquisitionTimeoutTask = this.acquisitionTimeoutInNanos <= 0L ? null : new AcquireTimeoutTask(this){

            @Override
            public void onTimeout(AcquireTask task) {
                task.promise.setFailure((Throwable)ACQUISITION_TIMEOUT);
            }
        };
        this.newTimeout(endpoint, config.idleEndpointTimeoutInNanos(), config.requestTimerResolutionInNanos());
    }

    public int channels() {
        return this.acquiredChannels.size() + this.availableChannels.size() + (this.connecting.get() ? 1 : 0);
    }

    public int channelsAcquired() {
        return this.acquiredChannels.size();
    }

    public int channelsAvailable() {
        return this.availableChannels.size();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int maxChannels() {
        return this.maxChannels;
    }

    public int maxRequestsPerChannel() {
        return this.maxRequestsPerChannel;
    }

    public SocketAddress remoteAddress() {
        return this.bootstrap.config().remoteAddress();
    }

    public int requestQueueLength() {
        return this.pendingAcquisitions.size();
    }

    public long usedDirectMemory() {
        return this.allocatorMetric.usedDirectMemory();
    }

    public long usedHeapMemory() {
        return this.allocatorMetric.usedHeapMemory();
    }

    public Future<Channel> acquire() {
        return this.acquire((Promise<Channel>)this.bootstrap.config().group().next().newPromise());
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        this.throwIfClosed();
        try {
            if (this.executor.inEventLoop()) {
                this.acquireChannel(promise);
            } else {
                this.executor.execute(() -> this.acquireChannel(promise));
            }
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
        return promise;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.executor.inEventLoop()) {
                this.doClose();
            } else {
                this.executor.submit(this::doClose).awaitUninterruptibly();
            }
        }
    }

    public Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)channel.eventLoop().newPromise());
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        Preconditions.checkNotNull(channel, "expected non-null channel");
        Preconditions.checkNotNull(promise, "expected non-null promise");
        Promise anotherPromise = this.executor.newPromise();
        try {
            EventLoop loop = channel.eventLoop();
            if (loop.inEventLoop()) {
                this.releaseChannel(channel, (Promise<Void>)anotherPromise);
            } else {
                loop.execute(() -> this.releaseChannel(channel, (Promise<Void>)anotherPromise));
            }
        }
        catch (Throwable cause) {
            if (this.executor.inEventLoop()) {
                this.closeChannelAndFail(channel, cause, anotherPromise);
            }
            this.executor.submit(() -> this.closeChannelAndFail(channel, cause, anotherPromise));
        }
        anotherPromise.addListener((GenericFutureListener)((FutureListener)future -> {
            this.ensureInEventLoop();
            if (this.isClosed()) {
                promise.setFailure((Throwable)POOL_CLOSED_ON_RELEASE);
                this.closeChannel(channel);
                return;
            }
            if (future.isSuccess()) {
                this.runTasksInPendingAcquisitionQueue();
                promise.setSuccess(null);
            } else {
                Throwable cause = future.cause();
                if (!(cause instanceof IllegalArgumentException)) {
                    this.runTasksInPendingAcquisitionQueue();
                }
                promise.setFailure(cause);
            }
        }));
        return promise;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private void acquireChannel(Promise<Channel> promise) {
        this.ensureInEventLoop();
        if (this.isClosed()) {
            promise.setFailure((Throwable)POOL_CLOSED_ON_ACQUIRE);
            return;
        }
        try {
            Channel candidate = this.pollChannel();
            if (candidate != null) {
                this.doAcquireChannel(promise, candidate);
                return;
            }
            int channelCount = this.channels();
            if (channelCount < this.maxChannels) {
                if (this.connecting.compareAndSet(false, true)) {
                    Promise<Channel> anotherPromise = this.newChannelPromise(promise);
                    ChannelFuture future = ((Bootstrap)this.bootstrap.clone().attr(POOL_KEY, (Object)this)).connect();
                    if (future.isDone()) {
                        this.notifyChannelConnect(future, anotherPromise);
                    } else {
                        future.addListener(ignored -> this.notifyChannelConnect(future, anotherPromise));
                    }
                    return;
                }
            } else if (this.computeLoadFactor() > 0.9) {
                long pendingRequestCountMin = Long.MAX_VALUE;
                for (Channel channel : this.availableChannels) {
                    RntbdRequestManager manager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
                    long pendingRequestCount = manager.pendingRequestCount();
                    if (pendingRequestCount >= pendingRequestCountMin) continue;
                    pendingRequestCountMin = pendingRequestCount;
                    candidate = channel;
                }
                assert (candidate != null);
                this.availableChannels.remove(candidate);
                this.doAcquireChannel(promise, candidate);
                return;
            }
            this.addTaskToPendingAcquisitionQueue(promise);
        }
        catch (Throwable cause) {
            promise.tryFailure(cause);
        }
    }

    private void addTaskToPendingAcquisitionQueue(Promise<Channel> promise) {
        this.ensureInEventLoop();
        if (logger.isDebugEnabled()) {
            logger.debug("{}, {}, {}, {}, {}, {}", new Object[]{Instant.now(), this.remoteAddress(), this.channels(), this.channelsAcquired(), this.channelsAvailable(), this.requestQueueLength()});
        }
        if (this.pendingAcquisitions.size() >= this.maxPendingAcquisitions) {
            promise.setFailure((Throwable)TOO_MANY_PENDING_ACQUISITIONS);
        } else {
            AcquireTask acquireTask = new AcquireTask(this, promise);
            if (this.pendingAcquisitions.offer(acquireTask)) {
                if (this.acquisitionTimeoutTask != null) {
                    acquireTask.timeoutFuture = (ScheduledFuture)this.executor.schedule(this.acquisitionTimeoutTask, this.acquisitionTimeoutInNanos, TimeUnit.NANOSECONDS);
                }
            } else {
                promise.setFailure((Throwable)TOO_MANY_PENDING_ACQUISITIONS);
            }
        }
    }

    private void closeChannel(Channel channel) {
        this.ensureInEventLoop();
        this.acquiredChannels.remove(channel);
        channel.attr(POOL_KEY).set(null);
        channel.close();
    }

    private void closeChannelAndFail(Channel channel, Throwable cause, Promise<?> promise) {
        this.ensureInEventLoop();
        this.closeChannel(channel);
        promise.tryFailure(cause);
    }

    private double computeLoadFactor() {
        long pendingRequestCount;
        RntbdRequestManager manager;
        long pendingRequestCountMin = Long.MAX_VALUE;
        long pendingRequestCountTotal = 0L;
        long channelCount = 0L;
        for (Channel channel : this.availableChannels) {
            manager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
            if (manager == null) {
                logger.debug("Channel({}) connection lost", (Object)channel);
                continue;
            }
            pendingRequestCount = manager.pendingRequestCount();
            if (pendingRequestCount < pendingRequestCountMin) {
                pendingRequestCountMin = pendingRequestCount;
            }
            pendingRequestCountTotal += pendingRequestCount;
            ++channelCount;
        }
        for (Channel channel : this.acquiredChannels.values()) {
            manager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
            if (manager != null) {
                pendingRequestCount = manager.pendingRequestCount();
                if (pendingRequestCount < pendingRequestCountMin) {
                    pendingRequestCountMin = pendingRequestCount;
                }
                pendingRequestCountTotal += pendingRequestCount;
            }
            ++channelCount;
        }
        return channelCount > 0L ? (double)pendingRequestCountTotal / (double)(channelCount * (long)this.maxRequestsPerChannel) : 1.0;
    }

    private void doAcquireChannel(Promise<Channel> promise, Channel candidate) {
        Promise<Channel> anotherPromise = this.newChannelPromise(promise);
        EventLoop loop = candidate.eventLoop();
        if (loop.inEventLoop()) {
            this.doChannelHealthCheck(candidate, anotherPromise);
        } else {
            loop.execute(() -> this.doChannelHealthCheck(candidate, anotherPromise));
        }
    }

    private void doChannelHealthCheck(Channel channel, Promise<Channel> promise) {
        Preconditions.checkState(channel.eventLoop().inEventLoop());
        Future isHealthy = this.healthChecker.isHealthy(channel);
        if (isHealthy.isDone()) {
            this.notifyChannelHealthCheck((Future<Boolean>)isHealthy, channel, promise);
        } else {
            isHealthy.addListener((GenericFutureListener)((FutureListener)future -> this.notifyChannelHealthCheck((Future<Boolean>)future, channel, promise)));
        }
    }

    private void doChannelHealthCheckOnRelease(Channel channel, Promise<Void> promise) {
        try {
            Preconditions.checkState(channel.eventLoop().inEventLoop());
            Future future = this.healthChecker.isHealthy(channel);
            if (future.isDone()) {
                this.releaseAndOfferChannelIfHealthy(channel, promise, (Future<Boolean>)future);
            } else {
                future.addListener(ignored -> this.releaseAndOfferChannelIfHealthy(channel, promise, (Future<Boolean>)future));
            }
        }
        catch (Throwable error) {
            if (this.executor.inEventLoop()) {
                this.closeChannelAndFail(channel, error, promise);
            }
            this.executor.submit(() -> this.closeChannelAndFail(channel, error, promise));
        }
    }

    private void doClose() {
        AcquireTask task;
        this.ensureInEventLoop();
        this.acquisitionAndIdleEndpointDetectionTimeout.getAndUpdate(timeout -> {
            timeout.cancel();
            return null;
        });
        if (logger.isDebugEnabled()) {
            logger.debug("{} closing with {} pending channel acquisitions", (Object)this, (Object)this.requestQueueLength());
        }
        while ((task = this.pendingAcquisitions.poll()) != null) {
            ScheduledFuture timeoutFuture = task.timeoutFuture;
            if (timeoutFuture != null) {
                timeoutFuture.cancel(false);
            }
            task.promise.setFailure((Throwable)new ClosedChannelException());
        }
        closer.submit(() -> {
            Channel channel;
            this.availableChannels.addAll(this.acquiredChannels.values());
            this.acquiredChannels.clear();
            while ((channel = this.pollChannel()) != null) {
                channel.close().awaitUninterruptibly();
            }
            assert (this.acquiredChannels.isEmpty() && this.availableChannels.isEmpty());
        }).addListener(closed -> {
            if (!closed.isSuccess()) {
                logger.error("[{}] close failed due to ", (Object)this, (Object)closed.cause());
            } else {
                logger.debug("[{}] closed", (Object)this);
            }
        });
    }

    private void ensureInEventLoop() {
        RntbdReporter.reportIssueUnless(logger, this.executor.inEventLoop(), this, "expected to be in event loop {}, not thread {}", this.executor, Thread.currentThread());
    }

    private boolean isChannelServiceable(Channel channel) {
        RntbdRequestManager manager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
        return manager != null && manager.isServiceable(this.maxRequestsPerChannel) && channel.isOpen();
    }

    private Promise<Channel> newChannelPromise(Promise<Channel> promise) {
        Preconditions.checkNotNull(promise, "expected non-null promise");
        AcquireListener listener = new AcquireListener(this, promise);
        Promise anotherPromise = this.executor.newPromise();
        listener.acquired(true);
        anotherPromise.addListener((GenericFutureListener)listener);
        return anotherPromise;
    }

    private void newTimeout(RntbdServiceEndpoint endpoint, long idleEndpointTimeoutInNanos, long requestTimerResolutionInNanos) {
        this.acquisitionAndIdleEndpointDetectionTimeout.set(acquisitionAndIdleEndpointDetectionTimer.newTimeout(timeout -> {
            long elapsedTimeInNanos = System.nanoTime() - endpoint.lastRequestNanoTime();
            if (idleEndpointTimeoutInNanos - elapsedTimeInNanos <= 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} closing endpoint due to inactivity (elapsedTime: {} > idleEndpointTimeout: {})", new Object[]{endpoint, Duration.ofNanos(elapsedTimeInNanos), Duration.ofNanos(idleEndpointTimeoutInNanos)});
                }
                endpoint.close();
                return;
            }
            if (this.requestQueueLength() <= 0) {
                this.newTimeout(endpoint, idleEndpointTimeoutInNanos, requestTimerResolutionInNanos);
                return;
            }
            this.executor.submit(this::runTasksInPendingAcquisitionQueue).addListener(future -> {
                RntbdReporter.reportIssueUnless(logger, future.isSuccess(), this, "failed due to ", future.cause());
                this.newTimeout(endpoint, idleEndpointTimeoutInNanos, requestTimerResolutionInNanos);
            });
        }, requestTimerResolutionInNanos, TimeUnit.NANOSECONDS));
    }

    private void notifyChannelConnect(ChannelFuture future, Promise<Channel> promise) {
        RntbdReporter.reportIssueUnless(logger, this.connecting.get(), this, "connecting: false", new Object[0]);
        if (future.isSuccess()) {
            Channel channel = future.channel();
            try {
                this.poolHandler.channelAcquired(channel);
            }
            catch (Throwable error) {
                this.closeChannelAndFail(channel, error, promise);
                return;
            }
            if (promise.trySuccess((Object)channel)) {
                this.acquiredChannels.compute(channel, (k, v) -> {
                    RntbdReporter.reportIssueUnless(logger, v == null, this, "expected null channel, not {}", v);
                    this.connecting.set(false);
                    return channel;
                });
            } else {
                this.closeChannel(channel);
                this.connecting.set(false);
            }
        } else {
            promise.tryFailure(future.cause());
        }
    }

    private void notifyChannelHealthCheck(Future<Boolean> future, Channel channel, Promise<Channel> promise) {
        boolean isHealthy;
        Preconditions.checkState(channel.eventLoop().inEventLoop());
        if (future.isSuccess() && (isHealthy = ((Boolean)future.getNow()).booleanValue())) {
            try {
                channel.attr(POOL_KEY).set((Object)this);
                this.poolHandler.channelAcquired(channel);
                this.acquiredChannels.put(channel, channel);
                promise.setSuccess((Object)channel);
            }
            catch (Throwable cause) {
                if (this.executor.inEventLoop()) {
                    this.closeChannelAndFail(channel, cause, promise);
                }
                this.executor.submit(() -> this.closeChannelAndFail(channel, cause, promise));
            }
            return;
        }
        if (this.executor.inEventLoop()) {
            this.closeChannel(channel);
            this.acquireChannel(promise);
        } else {
            this.executor.submit(() -> {
                this.closeChannel(channel);
                this.acquireChannel(promise);
            });
        }
    }

    private boolean offerChannel(Channel channel) {
        this.ensureInEventLoop();
        return this.availableChannels.offer(channel);
    }

    private Channel pollChannel() {
        Channel first = this.availableChannels.pollLast();
        if (first == null) {
            return null;
        }
        if (this.isClosed()) {
            return first;
        }
        if (this.isChannelServiceable(first)) {
            return first;
        }
        this.availableChannels.offer(first);
        Channel next = this.availableChannels.pollLast();
        while (next != first) {
            assert (next != null) : "impossible";
            if (next.isActive()) {
                if (this.isChannelServiceable(next)) {
                    return next;
                }
                this.availableChannels.offer(next);
            }
            next = this.availableChannels.pollLast();
        }
        this.availableChannels.offer(first);
        return null;
    }

    private void releaseAndOfferChannel(Channel channel, Promise<Void> promise) {
        this.ensureInEventLoop();
        try {
            if (this.offerChannel(channel)) {
                this.poolHandler.channelReleased(channel);
                promise.setSuccess(null);
            } else {
                StacklessIllegalStateException error = new StacklessIllegalStateException(Strings.lenientFormat("cannot offer channel back to pool because the pool is at capacity (%s)\n  %s\n  %s", this.maxChannels, this, channel));
                this.closeChannelAndFail(channel, error, promise);
            }
        }
        catch (Throwable error) {
            this.closeChannelAndFail(channel, error, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAndOfferChannelIfHealthy(Channel channel, Promise<Void> promise, Future<Boolean> future) {
        boolean isHealthy = (Boolean)future.getNow();
        if (isHealthy) {
            if (this.executor.inEventLoop()) {
                this.releaseAndOfferChannel(channel, promise);
            } else {
                this.executor.submit(() -> this.releaseAndOfferChannel(channel, promise));
            }
        } else {
            try {
                this.poolHandler.channelReleased(channel);
            }
            catch (Throwable error) {
                logger.debug("[{}] pool handler failed due to ", (Object)this, (Object)error);
            }
            finally {
                if (this.executor.inEventLoop()) {
                    this.closeChannel(channel);
                } else {
                    this.executor.submit(() -> this.closeChannel(channel));
                }
                promise.setSuccess(null);
            }
        }
    }

    private void releaseChannel(Channel channel, Promise<Void> promise) {
        block9: {
            boolean acquired;
            Preconditions.checkState(channel.eventLoop().inEventLoop());
            ChannelPool pool = (ChannelPool)channel.attr(POOL_KEY).getAndSet(null);
            boolean bl = acquired = this.acquiredChannels.get(channel) != null;
            if (acquired && pool == this) {
                try {
                    if (this.releaseHealthCheck) {
                        this.doChannelHealthCheckOnRelease(channel, promise);
                        break block9;
                    }
                    if (this.executor.inEventLoop()) {
                        this.releaseAndOfferChannel(channel, promise);
                        break block9;
                    }
                    this.executor.submit(() -> this.releaseAndOfferChannel(channel, promise));
                }
                catch (Throwable cause) {
                    if (this.executor.inEventLoop()) {
                        this.closeChannelAndFail(channel, cause, promise);
                        break block9;
                    }
                    this.executor.submit(() -> this.closeChannelAndFail(channel, cause, promise));
                }
            } else {
                IllegalStateException error = new IllegalStateException(Strings.lenientFormat("%s cannot be released because it was not acquired by this pool: %s", RntbdObjectMapper.toJson(channel), this));
                if (this.executor.inEventLoop()) {
                    this.closeChannelAndFail(channel, error, promise);
                } else {
                    this.executor.submit(() -> this.closeChannelAndFail(channel, error, promise));
                }
            }
        }
    }

    private void runTasksInPendingAcquisitionQueue() {
        AcquireTask task;
        this.ensureInEventLoop();
        int channelsAvailable = this.availableChannels.size();
        while (--channelsAvailable >= 0 && (task = this.pendingAcquisitions.poll()) != null) {
            ScheduledFuture timeoutFuture = task.timeoutFuture;
            if (timeoutFuture != null) {
                timeoutFuture.cancel(false);
            }
            task.acquired(true);
            this.acquire((Promise<Channel>)task.promise);
        }
    }

    private void throwIfClosed() {
        Preconditions.checkState(!this.isClosed(), "%s is closed", (Object)this);
    }

    private static class StacklessIllegalStateException
    extends IllegalStateException {
        private static final long serialVersionUID = -6011782222645074949L;

        public StacklessIllegalStateException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdClientChannelPool> {
        private static final long serialVersionUID = -8688539496437151693L;

        JsonSerializer() {
            super(RntbdClientChannelPool.class);
        }

        public void serialize(RntbdClientChannelPool value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            RntbdClientChannelHealthChecker healthChecker = (RntbdClientChannelHealthChecker)value.healthChecker;
            generator.writeStartObject();
            generator.writeStringField("remoteAddress", value.remoteAddress().toString());
            generator.writeBooleanField("isClosed", value.isClosed());
            generator.writeObjectFieldStart("configuration");
            generator.writeNumberField("maxChannels", value.maxChannels());
            generator.writeNumberField("maxRequestsPerChannel", value.maxRequestsPerChannel());
            generator.writeNumberField("idleConnectionTimeout", healthChecker.idleConnectionTimeoutInNanos());
            generator.writeNumberField("readDelayLimit", healthChecker.readDelayLimitInNanos());
            generator.writeNumberField("writeDelayLimit", healthChecker.writeDelayLimitInNanos());
            generator.writeEndObject();
            generator.writeObjectFieldStart("state");
            generator.writeNumberField("channelsAcquired", value.channelsAcquired());
            generator.writeNumberField("channelsAvailable", value.channelsAvailable());
            generator.writeNumberField("requestQueueLength", value.requestQueueLength());
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    private static abstract class AcquireTimeoutTask
    implements Runnable {
        private final RntbdClientChannelPool pool;

        public AcquireTimeoutTask(RntbdClientChannelPool pool) {
            this.pool = pool;
        }

        public abstract void onTimeout(AcquireTask var1);

        @Override
        public final void run() {
            AcquireTask task;
            this.pool.ensureInEventLoop();
            long nanoTime = System.nanoTime();
            Iterator iterator = this.pool.pendingAcquisitions.iterator();
            while (iterator.hasNext() && nanoTime - (task = (AcquireTask)iterator.next()).expireNanoTime >= 0L) {
                this.pool.pendingAcquisitions.remove();
                try {
                    this.onTimeout(task);
                }
                catch (Throwable error) {
                    logger.error("{} channel acquisition timeout task failed due to ", (Object)this.pool, (Object)error);
                }
            }
        }
    }

    private static final class AcquireTask
    extends AcquireListener {
        private final long expireNanoTime;
        private final Promise<Channel> promise;
        private ScheduledFuture<?> timeoutFuture;

        AcquireTask(RntbdClientChannelPool pool, Promise<Channel> promise) {
            super(pool, promise);
            this.promise = pool.executor.newPromise().addListener((GenericFutureListener)this);
            this.expireNanoTime = System.nanoTime() + pool.acquisitionTimeoutInNanos;
        }
    }

    private static class AcquireListener
    implements FutureListener<Channel> {
        private final Promise<Channel> originalPromise;
        private final RntbdClientChannelPool pool;
        private boolean acquired;

        AcquireListener(RntbdClientChannelPool pool, Promise<Channel> originalPromise) {
            this.originalPromise = originalPromise;
            this.pool = pool;
        }

        public final boolean acquired() {
            return this.acquired;
        }

        public final AcquireListener acquired(boolean value) {
            if (this.acquired) {
                return this;
            }
            this.acquired = true;
            return this;
        }

        public final void operationComplete(Future<Channel> future) {
            this.pool.ensureInEventLoop();
            if (this.pool.isClosed()) {
                if (future.isSuccess()) {
                    ((Channel)future.getNow()).close();
                }
                this.originalPromise.setFailure((Throwable)POOL_CLOSED_ON_ACQUIRE);
                return;
            }
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                channel.eventLoop().execute(() -> {
                    if (!channel.isActive()) {
                        this.fail(CHANNEL_CLOSED_ON_ACQUIRE);
                        return;
                    }
                    ChannelPipeline pipeline = channel.pipeline();
                    Preconditions.checkState(pipeline != null, "expected non-null channel pipeline");
                    RntbdRequestManager requestManager = (RntbdRequestManager)pipeline.get(RntbdRequestManager.class);
                    Preconditions.checkState(requestManager != null, "expected non-null request manager");
                    if (requestManager.hasRequestedRntbdContext()) {
                        this.originalPromise.setSuccess((Object)channel);
                    } else {
                        channel.writeAndFlush((Object)RntbdHealthCheckRequest.MESSAGE).addListener(completed -> {
                            if (completed.isSuccess()) {
                                RntbdReporter.reportIssueUnless(logger, this.acquired && requestManager.hasRntbdContext(), this, "acquired: {}, rntbdContext: {}", this.acquired, requestManager.rntbdContext());
                                this.originalPromise.setSuccess((Object)channel);
                            } else {
                                Throwable cause = completed.cause();
                                logger.warn("Channel({}) health check request failed due to:", (Object)channel, (Object)cause);
                                this.fail(cause);
                            }
                        });
                    }
                });
            } else {
                logger.warn("channel acquisition failed due to ", future.cause());
                this.fail(future.cause());
            }
        }

        private void fail(Throwable cause) {
            if (this.pool.executor.inEventLoop()) {
                this.pool.runTasksInPendingAcquisitionQueue();
            } else {
                this.pool.executor.submit(() -> this.pool.runTasksInPendingAcquisitionQueue());
            }
            this.originalPromise.setFailure(cause);
        }
    }
}

