/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.guava27.Strings;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class RntbdThreadFactory
implements ThreadFactory {
    private static final String NAME_TEMPLATE = "rntbd-%s[%s]";
    private final boolean daemon;
    private final String name;
    private final int priority;
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadCount;

    RntbdThreadFactory(String name, boolean daemon, int priority) {
        SecurityManager securityManager = System.getSecurityManager();
        this.threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.daemon = daemon;
        this.name = name;
        this.priority = priority;
        this.threadCount = new AtomicInteger();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = Strings.lenientFormat(NAME_TEMPLATE, this.name, this.threadCount.incrementAndGet());
        Thread thread = new Thread(this.threadGroup, runnable, name, 0L);
        if (thread.isDaemon() != this.daemon) {
            thread.setDaemon(this.daemon);
        }
        if (thread.getPriority() != this.priority) {
            thread.setPriority(this.priority);
        }
        return thread;
    }
}

