/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.LifeCycleUtils;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SharedGatewayHttpClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(SharedGatewayHttpClient.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static SharedGatewayHttpClient sharedGatewayHttpClient;
    private final HttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getOrCreateInstance(HttpClientConfig httpClientConfig) {
        Class<SharedGatewayHttpClient> clazz = SharedGatewayHttpClient.class;
        synchronized (SharedGatewayHttpClient.class) {
            if (sharedGatewayHttpClient == null) {
                assert (counter.get() == 0);
                logger.info("creating a new shared HttpClient");
                sharedGatewayHttpClient = new SharedGatewayHttpClient(httpClientConfig);
            } else {
                logger.info("Reusing an instance of HttpClient");
            }
            counter.incrementAndGet();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedGatewayHttpClient;
        }
    }

    private SharedGatewayHttpClient(HttpClientConfig httpClientConfig) {
        this.httpClient = HttpClient.createFixed(httpClientConfig);
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request) {
        return this.httpClient.send(request);
    }

    public int getReferenceCounter() {
        return counter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Class<SharedGatewayHttpClient> clazz = SharedGatewayHttpClient.class;
        synchronized (SharedGatewayHttpClient.class) {
            int numberOfActiveHttpClients = counter.decrementAndGet();
            logger.info("closing one reference to the shared HttpClient, the number of remaining references is {}", (Object)numberOfActiveHttpClients);
            if (numberOfActiveHttpClients == 0) {
                logger.info("All references to shared HttpClient are closed. Closing the underlying HttpClient");
                LifeCycleUtils.closeQuietly(SharedGatewayHttpClient.sharedGatewayHttpClient.httpClient);
                sharedGatewayHttpClient = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

