/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.routing.MurmurHash3_128;
import com.azure.cosmos.implementation.routing.UInt128;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public final class DistinctHash {
    private static final UInt128 ARRAY_HASH_SEED = new UInt128(-407792364492570226L, -6911810276445736683L);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    public static UInt128 getHash(Object resource) throws IOException {
        if (resource instanceof List) {
            return DistinctHash.getHashFromList((List)resource);
        }
        if (resource instanceof JsonSerializable) {
            return DistinctHash.getHashFromJsonSerializable((JsonSerializable)resource);
        }
        byte[] bytes = Utils.serializeObjectToByteArray(resource);
        UInt128 uInt128 = MurmurHash3_128.hash128(bytes, bytes.length);
        return uInt128;
    }

    private static UInt128 getHashFromJsonSerializable(JsonSerializable resource) {
        ByteBuffer byteBuffer = ModelBridgeInternal.serializeJsonToByteBuffer(resource, OBJECT_MAPPER);
        byte[] bytes = byteBuffer.array();
        return MurmurHash3_128.hash128(bytes, bytes.length);
    }

    private static UInt128 getHashFromList(List<Object> resource) {
        UInt128 hash = ARRAY_HASH_SEED;
        for (Object obj : resource) {
            if (!(obj instanceof JsonSerializable)) continue;
            byte[] bytes = hash.toByteBuffer().array();
            if (bytes.length == 0) {
                throw new IllegalStateException("Failed to hash!");
            }
            hash = MurmurHash3_128.hash128(bytes, bytes.length, DistinctHash.getHashFromJsonSerializable((JsonSerializable)obj));
        }
        return hash;
    }
}

