/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.query.GroupingTable;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.aggregation.AggregateOperator;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public final class GroupByDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    public static final String CONTINUATION_TOKEN_NOT_SUPPORTED_WITH_GROUP_BY = "Continuation token is not supported for queries with GROUP BY.Do not use continuation token or remove the GROUP BY from the query.";
    private final IDocumentQueryExecutionComponent<T> component;
    private final GroupingTable groupingTable;

    GroupByDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, GroupingTable groupingTable) {
        this.component = component;
        this.groupingTable = groupingTable;
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(Function<String, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, String continuationToken, Map<String, AggregateOperator> groupByAliasToAggregateType, List<String> orderedAliases, boolean hasSelectValue) {
        if (continuationToken != null) {
            BadRequestException dce = new BadRequestException(CONTINUATION_TOKEN_NOT_SUPPORTED_WITH_GROUP_BY);
            return Flux.error((Throwable)((Object)dce));
        }
        if (groupByAliasToAggregateType == null) {
            throw new IllegalArgumentException("groupByAliasToAggregateType should not be null");
        }
        if (orderedAliases == null) {
            throw new IllegalArgumentException("orderedAliases should not be null");
        }
        GroupingTable table = new GroupingTable(groupByAliasToAggregateType, orderedAliases, hasSelectValue);
        return createSourceComponentFunction.apply(null).map(component -> new GroupByDocumentQueryExecutionContext(component, table));
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).collectList().map(superList -> {
            double requestCharge = 0.0;
            HashMap<String, String> headers = new HashMap<String, String>();
            ArrayList<Document> documentList = new ArrayList<Document>();
            for (FeedResponse page : superList) {
                List results = page.getResults();
                documentList.addAll(results);
            }
            this.aggregateGroupings(documentList);
            List<Document> groupByResults = this.groupingTable.drain(maxPageSize);
            headers.put("x-ms-request-charge", Double.toString(requestCharge));
            FeedResponse<Document> frp = BridgeInternal.createFeedResponse(groupByResults, headers);
            return frp;
        }).flux();
    }

    private void aggregateGroupings(List<Document> superList) {
        for (Document d : superList) {
            RewrittenGroupByProjection rewrittenGroupByProjection = new RewrittenGroupByProjection(ModelBridgeInternal.getPropertyBagFromJsonSerializable(d));
            this.groupingTable.addPayLoad(rewrittenGroupByProjection);
        }
    }

    IDocumentQueryExecutionComponent<T> getComponent() {
        return this.component;
    }

    public class RewrittenGroupByProjection
    extends JsonSerializable {
        private static final String GROUP_BY_ITEMS_PROPERTY_NAME = "groupByItems";
        private static final String PAYLOAD_PROPERTY_NAME = "payload";
        private List<Document> groupByItems;

        public RewrittenGroupByProjection(ObjectNode objectNode) {
            super(objectNode);
            if (objectNode == null) {
                throw new IllegalArgumentException("objectNode can not be null");
            }
        }

        public List<Document> getGroupByItems() {
            this.groupByItems = this.getList(GROUP_BY_ITEMS_PROPERTY_NAME, Document.class, new boolean[0]);
            if (this.groupByItems == null) {
                throw new IllegalStateException("Underlying object does not have an 'groupByItems' field.");
            }
            return this.groupByItems;
        }

        public Document getPayload() {
            if (!this.has(PAYLOAD_PROPERTY_NAME)) {
                throw new IllegalStateException("Underlying object does not have an 'payload' field.");
            }
            return new Document((ObjectNode)this.get(PAYLOAD_PROPERTY_NAME));
        }
    }
}

