/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.AggregateDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.DistinctDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.GroupByDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.SkipDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.TakeContinuationToken;
import com.azure.cosmos.models.FeedResponse;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;

public class TopDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    private final IDocumentQueryExecutionComponent<T> component;
    private final int top;
    private final int limit;

    public TopDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int top, int limit) {
        this.component = component;
        this.top = top;
        this.limit = limit;
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(Function<String, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, int topCount, int limit, String topContinuationToken) {
        TakeContinuationToken takeContinuationToken;
        if (topContinuationToken == null) {
            takeContinuationToken = new TakeContinuationToken(topCount, null);
        } else {
            Utils.ValueHolder<TakeContinuationToken> outTakeContinuationToken = new Utils.ValueHolder<TakeContinuationToken>();
            if (!TakeContinuationToken.tryParse(topContinuationToken, outTakeContinuationToken)) {
                String message = String.format("INVALID JSON in continuation token %s for Top~Context", topContinuationToken);
                CosmosException dce = BridgeInternal.createCosmosException(400, message);
                return Flux.error((Throwable)((Object)dce));
            }
            takeContinuationToken = (TakeContinuationToken)outTakeContinuationToken.v;
        }
        if (takeContinuationToken.getTakeCount() > topCount) {
            String message = String.format("top count in continuation token: %d can not be greater than the top count in the query: %d.", takeContinuationToken.getTakeCount(), topCount);
            CosmosException dce = BridgeInternal.createCosmosException(400, message);
            return Flux.error((Throwable)((Object)dce));
        }
        return createSourceComponentFunction.apply(takeContinuationToken.getSourceToken()).map(component -> new TopDocumentQueryExecutionContext(component, takeContinuationToken.getTakeCount(), limit));
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        ParallelDocumentQueryExecutionContextBase<T> context = this.getContextFromComponent();
        context.setTop(this.limit);
        return this.component.drainAsync(maxPageSize).takeUntil(new Predicate<FeedResponse<T>>(){
            private volatile int fetchedItems = 0;

            @Override
            public boolean test(FeedResponse<T> frp) {
                this.fetchedItems += frp.getResults().size();
                return this.fetchedItems >= TopDocumentQueryExecutionContext.this.top;
            }
        }).map(new Function<FeedResponse<T>, FeedResponse<T>>(){
            private volatile int collectedItems = 0;
            private volatile boolean lastPage = false;

            @Override
            public FeedResponse<T> apply(FeedResponse<T> t) {
                if (this.collectedItems + t.getResults().size() <= TopDocumentQueryExecutionContext.this.top) {
                    this.collectedItems += t.getResults().size();
                    HashMap<String, String> headers = new HashMap<String, String>(t.getResponseHeaders());
                    if (TopDocumentQueryExecutionContext.this.top != this.collectedItems) {
                        String sourceContinuationToken = t.getContinuationToken();
                        TakeContinuationToken takeContinuationToken = new TakeContinuationToken(TopDocumentQueryExecutionContext.this.top - this.collectedItems, sourceContinuationToken);
                        headers.put("x-ms-continuation", takeContinuationToken.toJson());
                    } else {
                        headers.put("x-ms-continuation", null);
                    }
                    return BridgeInternal.createFeedResponseWithQueryMetrics(t.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(t));
                }
                assert (!this.lastPage);
                this.lastPage = true;
                int lastPageSize = TopDocumentQueryExecutionContext.this.top - this.collectedItems;
                this.collectedItems += lastPageSize;
                HashMap<String, String> headers = new HashMap<String, String>(t.getResponseHeaders());
                headers.put("x-ms-continuation", null);
                return BridgeInternal.createFeedResponseWithQueryMetrics(t.getResults().subList(0, lastPageSize), headers, BridgeInternal.queryMetricsFromFeedResponse(t));
            }
        });
    }

    private ParallelDocumentQueryExecutionContextBase<T> getContextFromComponent() {
        IDocumentQueryExecutionComponent component;
        ParallelDocumentQueryExecutionContextBase context = this.component instanceof GroupByDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((GroupByDocumentQueryExecutionContext)this.component).getComponent() : (this.component instanceof DistinctDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((DistinctDocumentQueryExecutionContext)this.component).getComponent() : (this.component instanceof AggregateDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((AggregateDocumentQueryExecutionContext)this.component).getComponent() : (this.component instanceof SkipDocumentQueryExecutionContext ? ((component = ((SkipDocumentQueryExecutionContext)this.component).getComponent()) instanceof DistinctDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((DistinctDocumentQueryExecutionContext)component).getComponent() : (component instanceof AggregateDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((AggregateDocumentQueryExecutionContext)component).getComponent() : (component instanceof GroupByDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((GroupByDocumentQueryExecutionContext)component).getComponent() : (ParallelDocumentQueryExecutionContextBase)component))) : (ParallelDocumentQueryExecutionContextBase)this.component)));
        return context;
    }
}

