/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import java.nio.ByteBuffer;
import java.util.Objects;

public class UInt128 {
    private static final int SIZE = 128;
    public static final int BYTES = 16;
    final long low;
    final long high;

    public UInt128(long x, long y) {
        this.low = x;
        this.high = y;
    }

    public UInt128(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        this.low = byteBuffer.getLong();
        this.high = byteBuffer.getLong();
    }

    public boolean equals(Object other) {
        if (other instanceof UInt128) {
            UInt128 uInt128Other = (UInt128)other;
            return this.low == uInt128Other.low && this.high == uInt128Other.high;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.low, this.high);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(this.low).putLong(this.high);
        return byteBuffer;
    }

    public String toString() {
        return this.toByteBuffer().toString();
    }

    public long getLow() {
        return this.low;
    }

    public long getHigh() {
        return this.high;
    }
}

