/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdTokenType;
import com.azure.cosmos.implementation.guava25.collect.ImmutableMap;
import com.azure.cosmos.implementation.guava25.collect.ImmutableSet;
import com.azure.cosmos.implementation.guava25.collect.Sets;
import com.azure.cosmos.implementation.guava27.Strings;
import io.netty.handler.codec.DecoderException;
import java.util.EnumSet;
import java.util.stream.Collector;

public final class RntbdConstants {
    static final int CURRENT_PROTOCOL_VERSION = 1;

    private RntbdConstants() {
    }

    static interface RntbdHeader {
        public boolean isRequired();

        public short id();

        public String name();

        public RntbdTokenType type();
    }

    public static enum RntbdResponseHeader implements RntbdHeader
    {
        PayloadPresent(0, RntbdTokenType.Byte, true),
        LastStateChangeDateTime(2, RntbdTokenType.SmallString, false),
        ContinuationToken(3, RntbdTokenType.String, false),
        ETag(4, RntbdTokenType.String, false),
        ReadsPerformed(7, RntbdTokenType.ULong, false),
        WritesPerformed(8, RntbdTokenType.ULong, false),
        QueriesPerformed(9, RntbdTokenType.ULong, false),
        IndexTermsGenerated(10, RntbdTokenType.ULong, false),
        ScriptsExecuted(11, RntbdTokenType.ULong, false),
        RetryAfterMilliseconds(12, RntbdTokenType.ULong, false),
        IndexingDirective(13, RntbdTokenType.Byte, false),
        StorageMaxResoureQuota(14, RntbdTokenType.String, false),
        StorageResourceQuotaUsage(15, RntbdTokenType.String, false),
        SchemaVersion(16, RntbdTokenType.SmallString, false),
        CollectionPartitionIndex(17, RntbdTokenType.ULong, false),
        CollectionServiceIndex(18, RntbdTokenType.ULong, false),
        LSN(19, RntbdTokenType.LongLong, false),
        ItemCount(20, RntbdTokenType.ULong, false),
        RequestCharge(21, RntbdTokenType.Double, false),
        OwnerFullName(23, RntbdTokenType.String, false),
        OwnerId(24, RntbdTokenType.String, false),
        DatabaseAccountId(25, RntbdTokenType.String, false),
        QuorumAckedLSN(26, RntbdTokenType.LongLong, false),
        RequestValidationFailure(27, RntbdTokenType.Byte, false),
        SubStatus(28, RntbdTokenType.ULong, false),
        CollectionUpdateProgress(29, RntbdTokenType.ULong, false),
        CurrentWriteQuorum(30, RntbdTokenType.ULong, false),
        CurrentReplicaSetSize(31, RntbdTokenType.ULong, false),
        CollectionLazyIndexProgress(32, RntbdTokenType.ULong, false),
        PartitionKeyRangeId(33, RntbdTokenType.String, false),
        LogResults(37, RntbdTokenType.String, false),
        XPRole(38, RntbdTokenType.ULong, false),
        IsRUPerMinuteUsed(39, RntbdTokenType.Byte, false),
        QueryMetrics(40, RntbdTokenType.String, false),
        GlobalCommittedLSN(41, RntbdTokenType.LongLong, false),
        NumberOfReadRegions(48, RntbdTokenType.ULong, false),
        OfferReplacePending(49, RntbdTokenType.Byte, false),
        ItemLSN(50, RntbdTokenType.LongLong, false),
        RestoreState(51, RntbdTokenType.String, false),
        CollectionSecurityIdentifier(52, RntbdTokenType.String, false),
        TransportRequestID(53, RntbdTokenType.ULong, false),
        ShareThroughput(54, RntbdTokenType.Byte, false),
        DisableRntbdChannel(56, RntbdTokenType.Byte, false),
        ServerDateTimeUtc(57, RntbdTokenType.SmallString, false),
        LocalLSN(58, RntbdTokenType.LongLong, false),
        QuorumAckedLocalLSN(59, RntbdTokenType.LongLong, false),
        ItemLocalLSN(60, RntbdTokenType.LongLong, false),
        HasTentativeWrites(61, RntbdTokenType.Byte, false),
        SessionToken(62, RntbdTokenType.String, false);

        public static final ImmutableMap<Short, RntbdResponseHeader> map;
        public static final ImmutableSet<RntbdResponseHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdResponseHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdResponseHeader.class));
            Collector<RntbdResponseHeader, ?, ImmutableMap<Short, RntbdResponseHeader>> collector = ImmutableMap.toImmutableMap(RntbdResponseHeader::id, header -> header);
            map = set.stream().collect(collector);
        }
    }

    public static enum RntbdResourceType {
        Connection(0, null),
        Database(1, ResourceType.Database),
        Collection(2, ResourceType.DocumentCollection),
        Document(3, ResourceType.Document),
        Attachment(4, ResourceType.Attachment),
        User(5, ResourceType.User),
        Permission(6, ResourceType.Permission),
        StoredProcedure(7, ResourceType.StoredProcedure),
        Conflict(8, ResourceType.Conflict),
        Trigger(9, ResourceType.Trigger),
        UserDefinedFunction(10, ResourceType.UserDefinedFunction),
        Module(11, ResourceType.Module),
        Replica(12, ResourceType.Replica),
        ModuleCommand(13, ResourceType.ModuleCommand),
        Record(14, ResourceType.Record),
        Offer(15, ResourceType.Offer),
        PartitionSetInformation(16, ResourceType.PartitionSetInformation),
        XPReplicatorAddress(17, ResourceType.XPReplicatorAddress),
        MasterPartition(18, ResourceType.MasterPartition),
        ServerPartition(19, ResourceType.ServerPartition),
        DatabaseAccount(20, ResourceType.DatabaseAccount),
        Topology(21, ResourceType.Topology),
        PartitionKeyRange(22, ResourceType.PartitionKeyRange),
        Schema(24, ResourceType.Schema),
        BatchApply(25, ResourceType.BatchApply),
        RestoreMetadata(26, ResourceType.RestoreMetadata),
        ComputeGatewayCharges(27, ResourceType.ComputeGatewayCharges),
        RidRange(28, ResourceType.RidRange),
        UserDefinedType(29, ResourceType.UserDefinedType);

        private final short id;
        private final ResourceType type;

        private RntbdResourceType(short id, ResourceType type) {
            this.id = id;
            this.type = type;
        }

        public static RntbdResourceType fromId(short id) throws IllegalArgumentException {
            switch (id) {
                case 0: {
                    return Connection;
                }
                case 1: {
                    return Database;
                }
                case 2: {
                    return Collection;
                }
                case 3: {
                    return Document;
                }
                case 4: {
                    return Attachment;
                }
                case 5: {
                    return User;
                }
                case 6: {
                    return Permission;
                }
                case 7: {
                    return StoredProcedure;
                }
                case 8: {
                    return Conflict;
                }
                case 9: {
                    return Trigger;
                }
                case 10: {
                    return UserDefinedFunction;
                }
                case 11: {
                    return Module;
                }
                case 12: {
                    return Replica;
                }
                case 13: {
                    return ModuleCommand;
                }
                case 14: {
                    return Record;
                }
                case 15: {
                    return Offer;
                }
                case 16: {
                    return PartitionSetInformation;
                }
                case 17: {
                    return XPReplicatorAddress;
                }
                case 18: {
                    return MasterPartition;
                }
                case 19: {
                    return ServerPartition;
                }
                case 20: {
                    return DatabaseAccount;
                }
                case 21: {
                    return Topology;
                }
                case 22: {
                    return PartitionKeyRange;
                }
                case 24: {
                    return Schema;
                }
                case 25: {
                    return BatchApply;
                }
                case 26: {
                    return RestoreMetadata;
                }
                case 27: {
                    return ComputeGatewayCharges;
                }
                case 28: {
                    return RidRange;
                }
                case 29: {
                    return UserDefinedType;
                }
            }
            throw new DecoderException(Strings.lenientFormat("expected byte value matching %s value, not %s", RntbdResourceType.class.getSimpleName(), id));
        }

        public static RntbdResourceType fromType(ResourceType type) {
            switch (type) {
                case Database: {
                    return Database;
                }
                case DocumentCollection: {
                    return Collection;
                }
                case Document: {
                    return Document;
                }
                case Attachment: {
                    return Attachment;
                }
                case User: {
                    return User;
                }
                case Permission: {
                    return Permission;
                }
                case StoredProcedure: {
                    return StoredProcedure;
                }
                case Conflict: {
                    return Conflict;
                }
                case Trigger: {
                    return Trigger;
                }
                case UserDefinedFunction: {
                    return UserDefinedFunction;
                }
                case Module: {
                    return Module;
                }
                case Replica: {
                    return Replica;
                }
                case ModuleCommand: {
                    return ModuleCommand;
                }
                case Record: {
                    return Record;
                }
                case Offer: {
                    return Offer;
                }
                case PartitionSetInformation: {
                    return PartitionSetInformation;
                }
                case XPReplicatorAddress: {
                    return XPReplicatorAddress;
                }
                case MasterPartition: {
                    return MasterPartition;
                }
                case ServerPartition: {
                    return ServerPartition;
                }
                case DatabaseAccount: {
                    return DatabaseAccount;
                }
                case Topology: {
                    return Topology;
                }
                case PartitionKeyRange: {
                    return PartitionKeyRange;
                }
                case Schema: {
                    return Schema;
                }
                case BatchApply: {
                    return BatchApply;
                }
                case RestoreMetadata: {
                    return RestoreMetadata;
                }
                case ComputeGatewayCharges: {
                    return ComputeGatewayCharges;
                }
                case RidRange: {
                    return RidRange;
                }
                case UserDefinedType: {
                    return UserDefinedType;
                }
            }
            throw new IllegalArgumentException(Strings.lenientFormat("unrecognized resource type: %s", new Object[]{type}));
        }

        public short id() {
            return this.id;
        }

        public ResourceType type() {
            return this.type;
        }
    }

    public static enum RntbdRequestHeader implements RntbdHeader
    {
        ResourceId(0, RntbdTokenType.Bytes, false),
        AuthorizationToken(1, RntbdTokenType.String, false),
        PayloadPresent(2, RntbdTokenType.Byte, true),
        Date(3, RntbdTokenType.SmallString, false),
        PageSize(4, RntbdTokenType.ULong, false),
        SessionToken(5, RntbdTokenType.String, false),
        ContinuationToken(6, RntbdTokenType.String, false),
        IndexingDirective(7, RntbdTokenType.Byte, false),
        Match(8, RntbdTokenType.String, false),
        PreTriggerInclude(9, RntbdTokenType.String, false),
        PostTriggerInclude(10, RntbdTokenType.String, false),
        IsFanout(11, RntbdTokenType.Byte, false),
        CollectionPartitionIndex(12, RntbdTokenType.ULong, false),
        CollectionServiceIndex(13, RntbdTokenType.ULong, false),
        PreTriggerExclude(14, RntbdTokenType.String, false),
        PostTriggerExclude(15, RntbdTokenType.String, false),
        ConsistencyLevel(16, RntbdTokenType.Byte, false),
        EntityId(17, RntbdTokenType.String, false),
        ResourceSchemaName(18, RntbdTokenType.SmallString, false),
        ReplicaPath(19, RntbdTokenType.String, true),
        ResourceTokenExpiry(20, RntbdTokenType.ULong, false),
        DatabaseName(21, RntbdTokenType.String, false),
        CollectionName(22, RntbdTokenType.String, false),
        DocumentName(23, RntbdTokenType.String, false),
        AttachmentName(24, RntbdTokenType.String, false),
        UserName(25, RntbdTokenType.String, false),
        PermissionName(26, RntbdTokenType.String, false),
        StoredProcedureName(27, RntbdTokenType.String, false),
        UserDefinedFunctionName(28, RntbdTokenType.String, false),
        TriggerName(29, RntbdTokenType.String, false),
        EnableScanInQuery(30, RntbdTokenType.Byte, false),
        EmitVerboseTracesInQuery(31, RntbdTokenType.Byte, false),
        ConflictName(32, RntbdTokenType.String, false),
        BindReplicaDirective(33, RntbdTokenType.String, false),
        PrimaryMasterKey(34, RntbdTokenType.String, false),
        SecondaryMasterKey(35, RntbdTokenType.String, false),
        PrimaryReadonlyKey(36, RntbdTokenType.String, false),
        SecondaryReadonlyKey(37, RntbdTokenType.String, false),
        ProfileRequest(38, RntbdTokenType.Byte, false),
        EnableLowPrecisionOrderBy(39, RntbdTokenType.Byte, false),
        ClientVersion(40, RntbdTokenType.SmallString, false),
        CanCharge(41, RntbdTokenType.Byte, false),
        CanThrottle(42, RntbdTokenType.Byte, false),
        PartitionKey(43, RntbdTokenType.String, false),
        PartitionKeyRangeId(44, RntbdTokenType.String, false),
        NotUsed2D(45, RntbdTokenType.Invalid, false),
        NotUsed2E(46, RntbdTokenType.Invalid, false),
        NotUsed2F(47, RntbdTokenType.Invalid, false),
        MigrateCollectionDirective(49, RntbdTokenType.Byte, false),
        NotUsed32(50, RntbdTokenType.Invalid, false),
        SupportSpatialLegacyCoordinates(51, RntbdTokenType.Byte, false),
        PartitionCount(52, RntbdTokenType.ULong, false),
        CollectionRid(53, RntbdTokenType.String, false),
        PartitionKeyRangeName(54, RntbdTokenType.String, false),
        SchemaName(58, RntbdTokenType.String, false),
        FilterBySchemaRid(59, RntbdTokenType.String, false),
        UsePolygonsSmallerThanAHemisphere(60, RntbdTokenType.Byte, false),
        GatewaySignature(61, RntbdTokenType.String, false),
        EnableLogging(62, RntbdTokenType.Byte, false),
        A_IM(63, RntbdTokenType.String, false),
        PopulateQuotaInfo(64, RntbdTokenType.Byte, false),
        DisableRUPerMinuteUsage(65, RntbdTokenType.Byte, false),
        PopulateQueryMetrics(66, RntbdTokenType.Byte, false),
        ResponseContinuationTokenLimitInKb(67, RntbdTokenType.ULong, false),
        PopulatePartitionStatistics(68, RntbdTokenType.Byte, false),
        RemoteStorageType(69, RntbdTokenType.Byte, false),
        CollectionRemoteStorageSecurityIdentifier(70, RntbdTokenType.String, false),
        IfModifiedSince(71, RntbdTokenType.String, false),
        PopulateCollectionThroughputInfo(72, RntbdTokenType.Byte, false),
        RemainingTimeInMsOnClientRequest(73, RntbdTokenType.ULong, false),
        ClientRetryAttemptCount(74, RntbdTokenType.ULong, false),
        TargetLsn(75, RntbdTokenType.LongLong, false),
        TargetGlobalCommittedLsn(76, RntbdTokenType.LongLong, false),
        TransportRequestID(77, RntbdTokenType.ULong, false),
        RestoreMetadaFilter(78, RntbdTokenType.String, false),
        RestoreParams(79, RntbdTokenType.String, false),
        ShareThroughput(80, RntbdTokenType.Byte, false),
        PartitionResourceFilter(81, RntbdTokenType.String, false),
        IsReadOnlyScript(82, RntbdTokenType.Byte, false),
        IsAutoScaleRequest(83, RntbdTokenType.Byte, false),
        ForceQueryScan(84, RntbdTokenType.Byte, false),
        CanOfferReplaceComplete(86, RntbdTokenType.Byte, false),
        ExcludeSystemProperties(87, RntbdTokenType.Byte, false),
        BinaryId(88, RntbdTokenType.Bytes, false),
        TimeToLiveInSeconds(89, RntbdTokenType.Long, false),
        EffectivePartitionKey(90, RntbdTokenType.Bytes, false),
        BinaryPassthroughRequest(91, RntbdTokenType.Byte, false),
        UserDefinedTypeName(92, RntbdTokenType.String, false),
        EnableDynamicRidRangeAllocation(93, RntbdTokenType.Byte, false),
        EnumerationDirection(94, RntbdTokenType.Byte, false),
        StartId(95, RntbdTokenType.Bytes, false),
        EndId(96, RntbdTokenType.Bytes, false),
        FanoutOperationState(97, RntbdTokenType.Byte, false),
        StartEpk(98, RntbdTokenType.Bytes, false),
        EndEpk(99, RntbdTokenType.Bytes, false),
        ReadFeedKeyType(100, RntbdTokenType.Byte, false),
        ContentSerializationFormat(101, RntbdTokenType.Byte, false),
        AllowTentativeWrites(102, RntbdTokenType.Byte, false),
        IsUserRequest(103, RntbdTokenType.Byte, false),
        SharedOfferThroughput(104, RntbdTokenType.ULong, false),
        IsBatchAtomic(115, RntbdTokenType.Byte, false),
        ShouldBatchContinueOnError(116, RntbdTokenType.Byte, false),
        IsBatchOrdered(117, RntbdTokenType.Byte, false),
        ReturnPreference(130, RntbdTokenType.Byte, false);

        public static final ImmutableMap<Short, RntbdRequestHeader> map;
        public static final ImmutableSet<RntbdRequestHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdRequestHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdRequestHeader.class));
            Collector<RntbdRequestHeader, ?, ImmutableMap<Short, RntbdRequestHeader>> collector = ImmutableMap.toImmutableMap(RntbdRequestHeader::id, h -> h);
            map = set.stream().collect(collector);
        }
    }

    public static enum RntbdRemoteStorageType {
        Invalid(0),
        NotSpecified(1),
        Standard(2),
        Premium(3);

        private final byte id;

        private RntbdRemoteStorageType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdReadFeedKeyType {
        Invalid(0),
        ResourceId(1),
        EffectivePartitionKey(2);

        private final byte id;

        private RntbdReadFeedKeyType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdOperationType {
        Connection(0, null),
        Create(1, OperationType.Create),
        Patch(2, OperationType.Patch),
        Read(3, OperationType.Read),
        ReadFeed(4, OperationType.ReadFeed),
        Delete(5, OperationType.Delete),
        Replace(6, OperationType.Replace),
        ExecuteJavaScript(8, OperationType.ExecuteJavaScript),
        SqlQuery(9, OperationType.SqlQuery),
        Pause(10, OperationType.Pause),
        Resume(11, OperationType.Resume),
        Stop(12, OperationType.Stop),
        Recycle(13, OperationType.Recycle),
        Crash(14, OperationType.Crash),
        Query(15, OperationType.Query),
        ForceConfigRefresh(16, OperationType.ForceConfigRefresh),
        Head(17, OperationType.Head),
        HeadFeed(18, OperationType.HeadFeed),
        Upsert(19, OperationType.Upsert),
        Recreate(20, OperationType.Recreate),
        Throttle(21, OperationType.Throttle),
        GetSplitPoint(22, OperationType.GetSplitPoint),
        PreCreateValidation(23, OperationType.PreCreateValidation),
        BatchApply(24, OperationType.BatchApply),
        AbortSplit(25, OperationType.AbortSplit),
        CompleteSplit(26, OperationType.CompleteSplit),
        OfferUpdateOperation(27, OperationType.OfferUpdateOperation),
        OfferPreGrowValidation(28, OperationType.OfferPreGrowValidation),
        BatchReportThroughputUtilization(29, OperationType.BatchReportThroughputUtilization),
        CompletePartitionMigration(30, OperationType.CompletePartitionMigration),
        AbortPartitionMigration(31, OperationType.AbortPartitionMigration),
        PreReplaceValidation(32, OperationType.PreReplaceValidation),
        AddComputeGatewayRequestCharges(33, OperationType.AddComputeGatewayRequestCharges),
        MigratePartition(34, OperationType.MigratePartition),
        Batch(37, OperationType.Batch);

        private final short id;
        private final OperationType type;

        private RntbdOperationType(short id, OperationType type) {
            this.id = id;
            this.type = type;
        }

        public static RntbdOperationType fromId(short id) {
            switch (id) {
                case 0: {
                    return Connection;
                }
                case 1: {
                    return Create;
                }
                case 2: {
                    return Patch;
                }
                case 3: {
                    return Read;
                }
                case 4: {
                    return ReadFeed;
                }
                case 5: {
                    return Delete;
                }
                case 6: {
                    return Replace;
                }
                case 8: {
                    return ExecuteJavaScript;
                }
                case 9: {
                    return SqlQuery;
                }
                case 10: {
                    return Pause;
                }
                case 11: {
                    return Resume;
                }
                case 12: {
                    return Stop;
                }
                case 13: {
                    return Recycle;
                }
                case 14: {
                    return Crash;
                }
                case 15: {
                    return Query;
                }
                case 16: {
                    return ForceConfigRefresh;
                }
                case 17: {
                    return Head;
                }
                case 18: {
                    return HeadFeed;
                }
                case 19: {
                    return Upsert;
                }
                case 20: {
                    return Recreate;
                }
                case 21: {
                    return Throttle;
                }
                case 22: {
                    return GetSplitPoint;
                }
                case 23: {
                    return PreCreateValidation;
                }
                case 24: {
                    return BatchApply;
                }
                case 25: {
                    return AbortSplit;
                }
                case 26: {
                    return CompleteSplit;
                }
                case 27: {
                    return OfferUpdateOperation;
                }
                case 28: {
                    return OfferPreGrowValidation;
                }
                case 29: {
                    return BatchReportThroughputUtilization;
                }
                case 30: {
                    return CompletePartitionMigration;
                }
                case 31: {
                    return AbortPartitionMigration;
                }
                case 32: {
                    return PreReplaceValidation;
                }
                case 33: {
                    return AddComputeGatewayRequestCharges;
                }
                case 34: {
                    return MigratePartition;
                }
                case 37: {
                    return Batch;
                }
            }
            throw new DecoderException(Strings.lenientFormat("expected byte value matching %s value, not %s", RntbdOperationType.class.getSimpleName(), id));
        }

        public static RntbdOperationType fromType(OperationType type) {
            switch (type) {
                case Crash: {
                    return Crash;
                }
                case Create: {
                    return Create;
                }
                case Delete: {
                    return Delete;
                }
                case ExecuteJavaScript: {
                    return ExecuteJavaScript;
                }
                case Query: {
                    return Query;
                }
                case Pause: {
                    return Pause;
                }
                case Read: {
                    return Read;
                }
                case ReadFeed: {
                    return ReadFeed;
                }
                case Recreate: {
                    return Recreate;
                }
                case Recycle: {
                    return Recycle;
                }
                case Replace: {
                    return Replace;
                }
                case Resume: {
                    return Resume;
                }
                case Stop: {
                    return Stop;
                }
                case SqlQuery: {
                    return SqlQuery;
                }
                case Patch: {
                    return Patch;
                }
                case ForceConfigRefresh: {
                    return ForceConfigRefresh;
                }
                case Head: {
                    return Head;
                }
                case HeadFeed: {
                    return HeadFeed;
                }
                case Upsert: {
                    return Upsert;
                }
                case Throttle: {
                    return Throttle;
                }
                case PreCreateValidation: {
                    return PreCreateValidation;
                }
                case GetSplitPoint: {
                    return GetSplitPoint;
                }
                case AbortSplit: {
                    return AbortSplit;
                }
                case CompleteSplit: {
                    return CompleteSplit;
                }
                case BatchApply: {
                    return BatchApply;
                }
                case OfferUpdateOperation: {
                    return OfferUpdateOperation;
                }
                case OfferPreGrowValidation: {
                    return OfferPreGrowValidation;
                }
                case BatchReportThroughputUtilization: {
                    return BatchReportThroughputUtilization;
                }
                case AbortPartitionMigration: {
                    return AbortPartitionMigration;
                }
                case CompletePartitionMigration: {
                    return CompletePartitionMigration;
                }
                case PreReplaceValidation: {
                    return PreReplaceValidation;
                }
                case MigratePartition: {
                    return MigratePartition;
                }
                case AddComputeGatewayRequestCharges: {
                    return AddComputeGatewayRequestCharges;
                }
                case Batch: {
                    return Batch;
                }
            }
            throw new IllegalArgumentException(Strings.lenientFormat("unrecognized operation type: %s", new Object[]{type}));
        }

        public short id() {
            return this.id;
        }

        public OperationType type() {
            return this.type;
        }
    }

    public static enum RntbdMigrateCollectionDirective {
        Thaw(0),
        Freeze(1),
        Invalid(-1);

        private final byte id;

        private RntbdMigrateCollectionDirective(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    static enum RntbdIndexingDirective {
        Default(0),
        Include(1),
        Exclude(2),
        Invalid(-1);

        private final byte id;

        private RntbdIndexingDirective(byte id) {
            this.id = id;
        }

        public static RntbdIndexingDirective fromId(byte id) {
            switch (id) {
                case 0: {
                    return Default;
                }
                case 1: {
                    return Include;
                }
                case 2: {
                    return Exclude;
                }
                case -1: {
                    return Invalid;
                }
            }
            throw new IllegalArgumentException("id");
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdFanoutOperationState {
        Started(1),
        Completed(2);

        private final byte id;

        private RntbdFanoutOperationState(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdEnumerationDirection {
        Invalid(0),
        Forward(1),
        Reverse(2);

        private final byte id;

        private RntbdEnumerationDirection(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    static enum RntbdContextRequestHeader implements RntbdHeader
    {
        ProtocolVersion(0, RntbdTokenType.ULong, true),
        ClientVersion(1, RntbdTokenType.SmallString, true),
        UserAgent(2, RntbdTokenType.SmallString, true);

        public static final ImmutableMap<Short, RntbdContextRequestHeader> map;
        public static final ImmutableSet<RntbdContextRequestHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdContextRequestHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdContextRequestHeader.class));
            Collector<RntbdContextRequestHeader, ?, ImmutableMap<Short, RntbdContextRequestHeader>> collector = ImmutableMap.toImmutableMap(h -> h.id(), h -> h);
            map = set.stream().collect(collector);
        }
    }

    static enum RntbdContextHeader implements RntbdHeader
    {
        ProtocolVersion(0, RntbdTokenType.ULong, false),
        ClientVersion(1, RntbdTokenType.SmallString, false),
        ServerAgent(2, RntbdTokenType.SmallString, true),
        ServerVersion(3, RntbdTokenType.SmallString, true),
        IdleTimeoutInSeconds(4, RntbdTokenType.ULong, false),
        UnauthenticatedTimeoutInSeconds(5, RntbdTokenType.ULong, false);

        public static final ImmutableMap<Short, RntbdContextHeader> map;
        public static final ImmutableSet<RntbdContextHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdContextHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdContextHeader.class));
            Collector<RntbdContextHeader, ?, ImmutableMap<Short, RntbdContextHeader>> collector = ImmutableMap.toImmutableMap(RntbdContextHeader::id, h -> h);
            map = set.stream().collect(collector);
        }
    }

    public static enum RntbdContentSerializationFormat {
        JsonText(0),
        CosmosBinary(1),
        Invalid(-1);

        private final byte id;

        private RntbdContentSerializationFormat(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdConsistencyLevel {
        Strong(0),
        BoundedStaleness(1),
        Session(2),
        Eventual(3),
        ConsistentPrefix(4),
        Invalid(-1);

        private final byte id;

        private RntbdConsistencyLevel(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }
}

