/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.feedranges.FeedRangeAsyncVisitor;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangeVisitor;
import com.azure.cosmos.implementation.feedranges.GenericFeedRangeVisitor;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

final class FeedRangeEpkImpl
extends FeedRangeInternal {
    private static final FeedRangeEpkImpl fullRangeEPK = new FeedRangeEpkImpl(PartitionKeyInternalHelper.FullRange);
    private final Range<String> range;
    private final UnmodifiableList<Range<String>> rangeList;

    public FeedRangeEpkImpl(Range<String> range) {
        Preconditions.checkNotNull(range, "Argument 'range' must not be null");
        this.range = range;
        ArrayList<Range<String>> temp = new ArrayList<Range<String>>();
        temp.add(range);
        this.rangeList = (UnmodifiableList)UnmodifiableList.unmodifiableList(temp);
    }

    public Range<String> getRange() {
        return this.range;
    }

    public static FeedRangeEpkImpl forFullRange() {
        return fullRangeEPK;
    }

    @Override
    public void accept(FeedRangeVisitor visitor) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        visitor.visit(this);
    }

    @Override
    public <TInput> void accept(GenericFeedRangeVisitor<TInput> visitor, TInput input) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        visitor.visit(this, input);
    }

    @Override
    public <T> Mono<T> accept(FeedRangeAsyncVisitor<T> visitor) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        return visitor.visit(this);
    }

    @Override
    public Mono<UnmodifiableList<Range<String>>> getEffectiveRanges(IRoutingMapProvider routingMapProvider, String containerRid, PartitionKeyDefinition partitionKeyDefinition) {
        return Mono.just(this.rangeList);
    }

    @Override
    public Mono<UnmodifiableList<String>> getPartitionKeyRanges(IRoutingMapProvider routingMapProvider, String containerRid, PartitionKeyDefinition partitionKeyDefinition) {
        return routingMapProvider.tryGetOverlappingRangesAsync(null, containerRid, this.range, false, null).flatMap(pkRangeHolder -> {
            ArrayList<String> rangeList = new ArrayList<String>();
            if (pkRangeHolder != null) {
                List pkRanges = (List)pkRangeHolder.v;
                for (PartitionKeyRange pkRange : pkRanges) {
                    rangeList.add(pkRange.getId());
                }
            }
            return Mono.just((Object)((UnmodifiableList)UnmodifiableList.unmodifiableList(rangeList)));
        });
    }

    @Override
    public String toString() {
        return this.range.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedRangeEpkImpl that = (FeedRangeEpkImpl)o;
        return Objects.equals(this.range, that.range);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.range);
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.range != null) {
            ModelBridgeInternal.populatePropertyBag(this.range);
            BridgeInternal.setProperty(this, "Range", this.range);
        }
    }
}

