/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ParallelDocumentQueryExecutionContextBase<T extends Resource>
extends DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionComponent<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<DocumentProducer<T>> documentProducers = new ArrayList<DocumentProducer<T>>();
    protected final List<PartitionKeyRange> partitionKeyRanges;
    protected final SqlQuerySpec querySpec;
    protected int pageSize;
    protected int top = -1;

    protected ParallelDocumentQueryExecutionContextBase(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, List<PartitionKeyRange> partitionKeyRanges, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, getLazyFeedResponse, correlatedActivityId);
        this.partitionKeyRanges = partitionKeyRanges;
        this.querySpec = !Strings.isNullOrEmpty(rewrittenQuery) ? new SqlQuerySpec(rewrittenQuery, this.query.getParameters()) : this.query;
    }

    protected void initialize(String collectionRid, Map<PartitionKeyRange, String> partitionKeyRangeToContinuationTokenMap, int initialPageSize, SqlQuerySpec querySpecForInit) {
        this.pageSize = initialPageSize;
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<PartitionKeyRange, String> entry : partitionKeyRangeToContinuationTokenMap.entrySet()) {
            TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                PartitionKeyInternal partitionKeyInternal = null;
                if (this.cosmosQueryRequestOptions.getPartitionKey() != null && this.cosmosQueryRequestOptions.getPartitionKey() != PartitionKey.NONE) {
                    partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(this.cosmosQueryRequestOptions.getPartitionKey());
                    headers.put("x-ms-documentdb-partitionkey", partitionKeyInternal.toJson());
                }
                return this.createDocumentServiceRequest((Map<String, String>)headers, querySpecForInit, partitionKeyInternal, (PartitionKeyRange)partitionKeyRange, collectionRid);
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request);
            PartitionKeyRange targetRange = entry.getKey();
            String continuationToken2 = entry.getValue();
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, targetRange, continuationToken2, initialPageSize, this.cosmosQueryRequestOptions, querySpecForInit, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy());
            this.documentProducers.add(dp);
        }
    }

    protected <TContinuationToken> int findTargetRangeAndExtractContinuationTokens(List<PartitionKeyRange> partitionKeyRanges, Range<String> range) {
        int minIndex;
        if (partitionKeyRanges == null) {
            throw new IllegalArgumentException("partitionKeyRanges can not be null.");
        }
        if (partitionKeyRanges.size() < 1) {
            throw new IllegalArgumentException("partitionKeyRanges must have atleast one element.");
        }
        for (PartitionKeyRange partitionKeyRange : partitionKeyRanges) {
            if (partitionKeyRange != null) continue;
            throw new IllegalArgumentException("partitionKeyRanges can not have null elements.");
        }
        PartitionKeyRange needle = new PartitionKeyRange(null, range.getMin(), range.getMax());
        for (minIndex = 0; minIndex < partitionKeyRanges.size() && !needle.getMinInclusive().equals(partitionKeyRanges.get(minIndex).getMinInclusive()); ++minIndex) {
        }
        if (minIndex == partitionKeyRanges.size()) {
            throw BridgeInternal.createCosmosException(400, String.format("Could not find partition key range for continuation token: {0}", needle));
        }
        return minIndex;
    }

    protected abstract DocumentProducer<T> createDocumentProducer(String var1, PartitionKeyRange var2, String var3, int var4, CosmosQueryRequestOptions var5, SqlQuerySpec var6, Map<String, String> var7, TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> var8, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> var9, Callable<DocumentClientRetryPolicy> var10);

    @Override
    public abstract Flux<FeedResponse<T>> drainAsync(int var1);

    public void setTop(int newTop) {
        this.top = newTop;
        for (DocumentProducer<T> producer : this.documentProducers) {
            producer.top = newTop;
        }
    }

    protected void initializeReadMany(IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuerySpec, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, UUID activityId, String collectionRid) {
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<PartitionKeyRange, SqlQuerySpec> entry : rangeQueryMap.entrySet()) {
            PartitionKeyRange targetRange = entry.getKey();
            SqlQuerySpec querySpec = entry.getValue();
            TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                return this.createDocumentServiceRequest((Map<String, String>)headers, querySpec, null, (PartitionKeyRange)partitionKeyRange, collectionRid);
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request);
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, targetRange, null, -1, cosmosQueryRequestOptions, querySpec, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy());
            this.documentProducers.add(dp);
        }
    }
}

