/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BulkItemRequestOptions;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.CosmosItemOperationType;
import com.azure.cosmos.CosmosPatchOperations;
import com.azure.cosmos.implementation.batch.ItemBulkOperation;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.Beta;

@Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class BulkOperations {
    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getCreateItemOperation(item, partitionKey, new BulkItemRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getCreateItemOperation(T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<T>(CosmosItemOperationType.CREATE, null, partitionKey, requestOptions.toRequestOptions(), item);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getDeleteItemOperation(id, partitionKey, new BulkItemRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getDeleteItemOperation(String id, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<Object>(CosmosItemOperationType.DELETE, id, partitionKey, requestOptions.toRequestOptions(), null);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReadItemOperation(id, partitionKey, new BulkItemRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getReadItemOperation(String id, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<Object>(CosmosItemOperationType.READ, id, partitionKey, requestOptions.toRequestOptions(), null);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getReplaceItemOperation(id, item, partitionKey, new BulkItemRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getReplaceItemOperation(String id, T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<T>(CosmosItemOperationType.REPLACE, id, partitionKey, requestOptions.toRequestOptions(), item);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        return BulkOperations.getUpsertItemOperation(item, partitionKey, new BulkItemRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static <T> CosmosItemOperation getUpsertItemOperation(T item, PartitionKey partitionKey, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<T>(CosmosItemOperationType.UPSERT, null, partitionKey, requestOptions.toRequestOptions(), item);
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return BulkOperations.getPatchItemOperation(id, partitionKey, cosmosPatchOperations, new BulkItemRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosItemOperation getPatchItemOperation(String id, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, BulkItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (requestOptions == null) {
            requestOptions = new BulkItemRequestOptions();
        }
        return new ItemBulkOperation<CosmosPatchOperations>(CosmosItemOperationType.PATCH, id, partitionKey, requestOptions.toRequestOptions(), cosmosPatchOperations);
    }
}

