/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.BulkProcessingOptions;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosBulkOperationResponse;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.CosmosPatchOperations;
import com.azure.cosmos.TransactionalBatch;
import com.azure.cosmos.TransactionalBatchRequestOptions;
import com.azure.cosmos.TransactionalBatchResponse;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.batch.BatchExecutor;
import com.azure.cosmos.implementation.batch.BulkExecutor;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosConflictProperties;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.Beta;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncContainer {
    private final CosmosAsyncDatabase database;
    private final String id;
    private final String link;
    private final String replaceContainerSpanName;
    private final String deleteContainerSpanName;
    private final String replaceThroughputSpanName;
    private final String readThroughputSpanName;
    private final String readContainerSpanName;
    private final String readItemSpanName;
    private final String upsertItemSpanName;
    private final String deleteItemSpanName;
    private final String replaceItemSpanName;
    private final String patchItemSpanName;
    private final String createItemSpanName;
    private final String readAllItemsSpanName;
    private final String queryItemsSpanName;
    private final String queryChangeFeedSpanName;
    private final String readAllConflictsSpanName;
    private final String queryConflictsSpanName;
    private final String batchSpanName;
    private CosmosAsyncScripts scripts;

    CosmosAsyncContainer(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
        this.replaceContainerSpanName = "replaceContainer." + this.id;
        this.deleteContainerSpanName = "deleteContainer." + this.id;
        this.replaceThroughputSpanName = "replaceThroughput." + this.id;
        this.readThroughputSpanName = "readThroughput." + this.id;
        this.readContainerSpanName = "readContainer." + this.id;
        this.readItemSpanName = "readItem." + this.id;
        this.upsertItemSpanName = "upsertItem." + this.id;
        this.deleteItemSpanName = "deleteItem." + this.id;
        this.replaceItemSpanName = "replaceItem." + this.id;
        this.patchItemSpanName = "patchItem." + this.id;
        this.createItemSpanName = "createItem." + this.id;
        this.readAllItemsSpanName = "readAllItems." + this.id;
        this.queryItemsSpanName = "queryItems." + this.id;
        this.queryChangeFeedSpanName = "queryChangeFeed." + this.id;
        this.readAllConflictsSpanName = "readAllConflicts." + this.id;
        this.queryConflictsSpanName = "queryConflicts." + this.id;
        this.batchSpanName = "transactionalBatch." + this.id;
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.read(requestOptions, (Context)context));
    }

    public Mono<CosmosContainerResponse> delete(CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.deleteInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties) {
        return this.replace(containerProperties, null);
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        CosmosContainerRequestOptions requestOptions = options == null ? new CosmosContainerRequestOptions() : options;
        return FluxUtil.withContext(context -> this.replaceInternal(containerProperties, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        return this.createItem(item, options);
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        CosmosItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.createItemInternal(item, requestOptions, (Context)context));
    }

    private <T> Mono<CosmosItemResponse<T>> createItemInternal(T item, CosmosItemRequestOptions options, Context context) {
        Mono<CosmosItemResponse<T>> responseMono = this.createItemInternal(item, options);
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.createItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Create, ResourceType.Document);
    }

    private <T> Mono<CosmosItemResponse<T>> createItemInternal(T item, CosmosItemRequestOptions options) {
        Class<?> itemType = item.getClass();
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.database.getDocClientWrapper().createDocument(this.getLink(), item, requestOptions, true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item) {
        return this.upsertItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, CosmosItemRequestOptions options) {
        CosmosItemRequestOptions requestOptions = options == null ? new CosmosItemRequestOptions() : options;
        return FluxUtil.withContext(context -> this.upsertItemInternal(item, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        CosmosItemRequestOptions requestOptions = options == null ? new CosmosItemRequestOptions() : options;
        ModelBridgeInternal.setPartitionKey(requestOptions, partitionKey);
        return FluxUtil.withContext(context -> this.upsertItemInternal(item, requestOptions, (Context)context));
    }

    <T> CosmosPagedFlux<T> readAllItems(Class<T> classType) {
        return this.readAllItems(new CosmosQueryRequestOptions(), classType);
    }

    <T> CosmosPagedFlux<T> readAllItems(CosmosQueryRequestOptions options, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerAndTelemetryInformation(this.readAllItemsSpanName, this.database.getId(), this.getId(), OperationType.ReadFeed, ResourceType.Document, this.getDatabase().getClient());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), options).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, false, classType));
        });
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, Class<T> classType) {
        return this.queryItemsInternal(new SqlQuerySpec(query), new CosmosQueryRequestOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, CosmosQueryRequestOptions options, Class<T> classType) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryItemsInternal(new SqlQuerySpec(query), options, classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, Class<T> classType) {
        return this.queryItemsInternal(querySpec, new CosmosQueryRequestOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, CosmosQueryRequestOptions options, Class<T> classType) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryItemsInternal(querySpec, options, classType);
    }

    <T> CosmosPagedFlux<T> queryItemsInternal(SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(this.queryItemsInternalFunc(sqlQuerySpec, cosmosQueryRequestOptions, classType));
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryItemsInternalFunc(SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions cosmosQueryRequestOptions, Class<T> classType) {
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            String spanName = this.queryItemsSpanName;
            pagedFluxOptions.setTracerAndTelemetryInformation(spanName, this.database.getId(), this.getId(), OperationType.Query, ResourceType.Document, this.getDatabase().getClient());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, cosmosQueryRequestOptions);
            return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), sqlQuerySpec, cosmosQueryRequestOptions).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, false, classType));
        };
        return pagedFluxOptionsFluxFunction;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> CosmosPagedFlux<T> queryChangeFeed(CosmosChangeFeedRequestOptions options, Class<T> classType) {
        Preconditions.checkNotNull(options, "Argument 'options' must not be null.");
        Preconditions.checkNotNull(classType, "Argument 'classType' must not be null.");
        return this.queryChangeFeedInternal(options, classType);
    }

    <T> CosmosPagedFlux<T> queryChangeFeedInternal(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(this.queryChangeFeedInternalFunc(cosmosChangeFeedRequestOptions, classType));
    }

    <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryChangeFeedInternalFunc(CosmosChangeFeedRequestOptions cosmosChangeFeedRequestOptions, Class<T> classType) {
        Preconditions.checkNotNull(cosmosChangeFeedRequestOptions, "Argument 'cosmosChangeFeedRequestOptions' must not be null.");
        Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> pagedFluxOptionsFluxFunction = pagedFluxOptions -> {
            Preconditions.checkNotNull(pagedFluxOptions, "Argument 'pagedFluxOptions' must not be null.");
            String spanName = this.queryChangeFeedSpanName;
            pagedFluxOptions.setTracerAndTelemetryInformation(spanName, this.database.getId(), this.getId(), OperationType.ReadFeed, ResourceType.Document, this.getDatabase().getClient());
            Utils.getEffectiveCosmosChangeFeedRequestOptions(pagedFluxOptions, cosmosChangeFeedRequestOptions);
            AsyncDocumentClient clientWrapper = this.database.getDocClientWrapper();
            return clientWrapper.getCollectionCache().resolveByNameAsync(null, this.link, null).flatMapMany(collection -> {
                if (collection == null) {
                    throw new IllegalStateException("Collection cannot be null");
                }
                return clientWrapper.queryDocumentChangeFeed((DocumentCollection)collection, cosmosChangeFeedRequestOptions).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, true, classType));
            });
        };
        return pagedFluxOptionsFluxFunction;
    }

    private <T> FeedResponse<T> prepareFeedResponse(FeedResponse<Document> response, boolean isChangeFeed, Class<T> classType) {
        boolean isNoChangesResponse;
        QueryInfo queryInfo = ModelBridgeInternal.getQueryInfoFromFeedResponse(response);
        boolean useEtagAsContinuation = isChangeFeed;
        boolean bl = isNoChangesResponse = isChangeFeed ? ModelBridgeInternal.getNoCHangesFromFeedResponse(response) : false;
        if (queryInfo != null && queryInfo.hasSelectValue()) {
            List transformedResults = response.getResults().stream().map(d -> d.has("_value") ? this.transform(d.get("_value"), classType) : ModelBridgeInternal.toObjectFromJsonSerializable(d, classType)).collect(Collectors.toList());
            return BridgeInternal.createFeedResponseWithQueryMetrics(transformedResults, response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response), ModelBridgeInternal.getQueryPlanDiagnosticsContext(response), useEtagAsContinuation, isNoChangesResponse);
        }
        return BridgeInternal.createFeedResponseWithQueryMetrics(response.getResults().stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, classType)).collect(Collectors.toList()), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response), ModelBridgeInternal.getQueryPlanDiagnosticsContext(response), useEtagAsContinuation, isNoChangesResponse);
    }

    private <T> T transform(Object object, Class<T> classType) {
        return (T)Utils.getSimpleObjectMapper().convertValue(object, classType);
    }

    @Beta(value=Beta.SinceVersion.V4_7_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<TransactionalBatchResponse> executeTransactionalBatch(TransactionalBatch transactionalBatch) {
        return this.executeTransactionalBatch(transactionalBatch, new TransactionalBatchRequestOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_7_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<TransactionalBatchResponse> executeTransactionalBatch(TransactionalBatch transactionalBatch, TransactionalBatchRequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new TransactionalBatchRequestOptions();
        }
        TransactionalBatchRequestOptions transactionalBatchRequestOptions = requestOptions;
        return FluxUtil.withContext(context -> {
            BatchExecutor executor = new BatchExecutor(this, transactionalBatch, transactionalBatchRequestOptions);
            Mono<TransactionalBatchResponse> responseMono = executor.executeAsync();
            return this.database.getClient().getTracerProvider().traceEnabledBatchResponsePublisher(responseMono, (Context)context, this.batchSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
        });
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> processBulkOperations(Flux<CosmosItemOperation> operations) {
        return this.processBulkOperations(operations, new BulkProcessingOptions());
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> processBulkOperations(Flux<CosmosItemOperation> operations, BulkProcessingOptions<TContext> bulkOptions) {
        if (bulkOptions == null) {
            bulkOptions = new BulkProcessingOptions();
        }
        BulkProcessingOptions bulkProcessingOptions = bulkOptions;
        return Flux.deferWithContext(context -> {
            BulkExecutor executor = new BulkExecutor(this, operations, bulkProcessingOptions);
            return executor.execute();
        });
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.readItem(itemId, partitionKey, ModelBridgeInternal.createCosmosItemRequestOptions(partitionKey), itemType);
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.readItemInternal(itemId, requestOptions, itemType, (Context)context));
    }

    @Beta(value=Beta.SinceVersion.V4_4_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, Class<T> classType) {
        return this.readMany(itemIdentityList, null, classType);
    }

    @Beta(value=Beta.SinceVersion.V4_4_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, String sessionToken, Class<T> classType) {
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        if (!StringUtils.isNotEmpty(sessionToken)) {
            options = options.setSessionToken(sessionToken);
        }
        options.setMaxDegreeOfParallelism(-1);
        return CosmosBridgeInternal.getAsyncDocumentClient(this.getDatabase()).readMany(itemIdentityList, BridgeInternal.getLink(this), options, classType);
    }

    public <T> CosmosPagedFlux<T> readAllItems(PartitionKey partitionKey, Class<T> classType) {
        return this.readAllItems(partitionKey, new CosmosQueryRequestOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> readAllItems(PartitionKey partitionKey, CosmosQueryRequestOptions options, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerAndTelemetryInformation(this.readAllItemsSpanName, this.database.getId(), this.getId(), OperationType.ReadFeed, ResourceType.Document, this.getDatabase().getClient());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().readAllDocuments(this.getLink(), partitionKey, options).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, false, classType));
        });
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey) {
        return this.replaceItem(item, itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        Document doc = InternalObjectNode.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        Class<?> itemType = item.getClass();
        CosmosItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.replaceItemInternal(itemType, itemId, doc, requestOptions, (Context)context));
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, Class<T> itemType) {
        return this.patchItem(itemId, partitionKey, cosmosPatchOperations, new CosmosItemRequestOptions(), itemType);
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosItemRequestOptions options, Class<T> itemType) {
        Preconditions.checkNotNull(itemId, "expected non-null itemId");
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey for patchItem");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        CosmosItemRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.patchItemInternal(itemId, cosmosPatchOperations, requestOptions, (Context)context, itemType));
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey) {
        return this.deleteItem(itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.deleteItemInternal(itemId, null, requestOptions, (Context)context));
    }

    public <T> Mono<CosmosItemResponse<Object>> deleteItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        InternalObjectNode internalObjectNode = InternalObjectNode.fromObjectToInternalObjectNode(item);
        return FluxUtil.withContext(context -> this.deleteItemInternal(internalObjectNode.getId(), internalObjectNode, requestOptions, (Context)context));
    }

    private String getItemLink(String itemId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLink());
        builder.append("/");
        builder.append("docs");
        builder.append("/");
        builder.append(itemId);
        return builder.toString();
    }

    public CosmosAsyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosAsyncScripts(this);
        }
        return this.scripts;
    }

    public CosmosPagedFlux<CosmosConflictProperties> readAllConflicts(CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerInformation(this.getDatabase().getClient().getTracerProvider(), this.readAllConflictsSpanName, this.getDatabase().getClient().getServiceEndpoint(), this.database.getId());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, requestOptions);
            return this.database.getDocClientWrapper().readConflicts(this.getLink(), requestOptions).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query) {
        return this.queryConflicts(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query, CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            pagedFluxOptions.setTracerInformation(this.getDatabase().getClient().getTracerProvider(), this.queryConflictsSpanName, this.getDatabase().getClient().getServiceEndpoint(), this.database.getId());
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, requestOptions);
            return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, requestOptions).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncConflict getConflict(String id) {
        return new CosmosAsyncConflict(id, this);
    }

    public Mono<ThroughputResponse> replaceThroughput(ThroughputProperties throughputProperties) {
        return FluxUtil.withContext(context -> this.replaceThroughputInternal(throughputProperties, (Context)context));
    }

    public Mono<ThroughputResponse> readThroughput() {
        return FluxUtil.withContext(context -> this.readThroughputInternal((Context)context));
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    String getURIPathSegment() {
        return "colls";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.link;
    }

    private Mono<CosmosItemResponse<Object>> deleteItemInternal(String itemId, InternalObjectNode internalObjectNode, RequestOptions requestOptions, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().deleteDocument(this.getItemLink(itemId), internalObjectNode, requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponseWithObjectType(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.deleteItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), requestOptions.getConsistencyLevel(), OperationType.Delete, ResourceType.Document);
    }

    private <T> Mono<CosmosItemResponse<T>> replaceItemInternal(Class<T> itemType, String itemId, Document doc, CosmosItemRequestOptions options, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().replaceDocument(this.getItemLink(itemId), doc, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.replaceItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Replace, ResourceType.Document);
    }

    private <T> Mono<CosmosItemResponse<T>> patchItemInternal(String itemId, CosmosPatchOperations cosmosPatchOperations, CosmosItemRequestOptions options, Context context, Class<T> itemType) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().patchDocument(this.getItemLink(itemId), cosmosPatchOperations, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer()));
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.patchItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Patch, ResourceType.Document);
    }

    private <T> Mono<CosmosItemResponse<T>> upsertItemInternal(T item, CosmosItemRequestOptions options, Context context) {
        Class<?> itemType = item.getClass();
        Mono responseMono = this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), item, ModelBridgeInternal.toRequestOptions(options), true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.upsertItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), ModelBridgeInternal.getConsistencyLevel(options), OperationType.Upsert, ResourceType.Document);
    }

    private <T> Mono<CosmosItemResponse<T>> readItemInternal(String itemId, RequestOptions requestOptions, Class<T> itemType, Context context) {
        Mono responseMono = this.getDatabase().getDocClientWrapper().readDocument(this.getItemLink(itemId), requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType, this.getItemDeserializer())).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosItemResponsePublisher(responseMono, context, this.readItemSpanName, this.getId(), this.database.getId(), this.database.getClient(), requestOptions.getConsistencyLevel(), OperationType.Read, ResourceType.Document);
    }

    Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options, Context context) {
        Mono responseMono = this.database.getDocClientWrapper().readCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.readContainerSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosContainerResponse> deleteInternal(CosmosContainerRequestOptions options, Context context) {
        Mono responseMono = this.database.getDocClientWrapper().deleteCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.deleteContainerSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<CosmosContainerResponse> replaceInternal(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options, Context context) {
        Mono responseMono = this.database.getDocClientWrapper().replaceCollection(ModelBridgeInternal.getV2Collection(containerProperties), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
        return this.database.getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.replaceContainerSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<ThroughputResponse> readThroughputInternal(Context context) {
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        Mono<ThroughputResponse> responseMono = this.readThroughputInternal(this.read(new CosmosContainerRequestOptions(), nestedContext));
        return this.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.readThroughputSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<ThroughputResponse> readThroughputInternal(Mono<CosmosContainerResponse> responseMono) {
        return responseMono.flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new CosmosQueryRequestOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(ThroughputProperties throughputProperties, Context context) {
        Context nestedContext = context.addData((Object)"cosmosCallDepth", (Object)"nested");
        Mono<ThroughputResponse> responseMono = this.replaceThroughputInternal(this.read(new CosmosContainerRequestOptions(), nestedContext), throughputProperties);
        return this.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, this.replaceThroughputSpanName, this.database.getId(), this.database.getClient().getServiceEndpoint());
    }

    private Mono<ThroughputResponse> replaceThroughputInternal(Mono<CosmosContainerResponse> responseMono, ThroughputProperties throughputProperties) {
        return responseMono.flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new CosmosQueryRequestOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            Offer existingOffer = (Offer)offerFeedResponse.getResults().get(0);
            Offer updatedOffer = ModelBridgeInternal.updateOfferFromProperties(existingOffer, throughputProperties);
            return this.database.getDocClientWrapper().replaceOffer(updatedOffer).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    ItemDeserializer getItemDeserializer() {
        return this.getDatabase().getDocClientWrapper().getItemDeserializer();
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Mono<List<FeedRange>> getFeedRanges() {
        return this.getDatabase().getDocClientWrapper().getFeedRanges(this.getLink());
    }
}

