/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ClearingSessionContainerClientRetryPolicy
extends DocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(ClearingSessionContainerClientRetryPolicy.class);
    private final DocumentClientRetryPolicy retryPolicy;
    private final ISessionContainer sessionContainer;
    private RxDocumentServiceRequest request;
    private boolean hasTriggered = false;

    public ClearingSessionContainerClientRetryPolicy(ISessionContainer sessionContainer, DocumentClientRetryPolicy retryPolicy) {
        this.sessionContainer = sessionContainer;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.retryPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        return this.retryPolicy.shouldRetry(e).flatMap(shouldRetryResult -> {
            if (!shouldRetryResult.shouldRetry && !this.hasTriggered) {
                CosmosException clientException = Utils.as(e, CosmosException.class);
                if (this.request == null) {
                    logger.error("onBeforeSendRequest is not invoked, encountered failure due to request being null", (Throwable)e);
                    return Mono.just((Object)ShouldRetryResult.error(e));
                }
                if (clientException != null && this.request.getIsNameBased() && Exceptions.isStatusCode(clientException, 404) && Exceptions.isSubStatusCode(clientException, 1002)) {
                    logger.warn("Clear the token for named base request {}", (Object)this.request.getResourceAddress());
                    this.sessionContainer.clearTokenByCollectionFullName(this.request.getResourceAddress());
                    this.hasTriggered = true;
                }
            }
            return Mono.just((Object)shouldRetryResult);
        });
    }
}

