/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.IRetryPolicy;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public abstract class RetryPolicyWithDiagnostics
implements IRetryPolicy {
    private volatile int retriesCountForDiagnostics;
    private volatile Instant retryStartTime;
    private volatile Instant retryEndTime;
    private volatile List<int[]> statusAndSubStatusCodes;

    @Override
    public Instant getStartTime() {
        return this.retryStartTime;
    }

    @Override
    public Instant getEndTime() {
        return this.retryEndTime;
    }

    @Override
    public void addStatusAndSubStatusCode(Integer index, int statusCode, int subStatusCode) {
        if (this.statusAndSubStatusCodes == null) {
            this.statusAndSubStatusCodes = new ArrayList<int[]>();
        }
        int[] statusAndSubStatusCode = new int[]{statusCode, subStatusCode};
        if (index == null) {
            this.statusAndSubStatusCodes.add(statusAndSubStatusCode);
        } else {
            this.statusAndSubStatusCodes.add(index, statusAndSubStatusCode);
        }
    }

    @Override
    public List<int[]> getStatusAndSubStatusCodes() {
        return this.statusAndSubStatusCodes;
    }

    @Override
    public int getRetryCount() {
        return this.retriesCountForDiagnostics;
    }

    @Override
    public void incrementRetry() {
        ++this.retriesCountForDiagnostics;
    }

    @Override
    public Duration getRetryLatency() {
        if (this.retryStartTime != null && this.retryEndTime != null) {
            return Duration.between(this.retryStartTime, this.retryEndTime);
        }
        return null;
    }

    @Override
    public void updateEndTime() {
        this.retryEndTime = Instant.now();
    }

    @Override
    public void captureStartTimeIfNotSet() {
        if (this.retryStartTime == null) {
            this.retryStartTime = Instant.now();
        }
    }
}

