/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverFactory;
import com.azure.cosmos.implementation.changefeed.CheckpointFrequency;
import com.azure.cosmos.implementation.changefeed.HealthMonitor;
import com.azure.cosmos.implementation.changefeed.LeaseStoreManager;
import com.azure.cosmos.implementation.changefeed.PartitionLoadBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.PartitionManager;
import com.azure.cosmos.implementation.changefeed.implementation.BootstrapperImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedContextClientImpl;
import com.azure.cosmos.implementation.changefeed.implementation.CheckpointerObserverFactory;
import com.azure.cosmos.implementation.changefeed.implementation.DefaultObserverFactory;
import com.azure.cosmos.implementation.changefeed.implementation.EqualPartitionsBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.implementation.HealthMonitoringPartitionControllerDecorator;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionControllerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionLoadBalancerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionManagerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionProcessorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionSupervisorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionSynchronizerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionedByIdCollectionRequestOptionsFactory;
import com.azure.cosmos.implementation.changefeed.implementation.TraceHealthMonitor;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyRangeImpl;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.ChangeFeedProcessorState;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ChangeFeedProcessorBuilderImpl
implements ChangeFeedProcessor,
AutoCloseable {
    private static final String PK_RANGE_ID_SEPARATOR = ":";
    private static final String SEGMENT_SEPARATOR = "#";
    private static final String PROPERTY_NAME_LSN = "_lsn";
    private final Logger logger = LoggerFactory.getLogger(ChangeFeedProcessorBuilderImpl.class);
    private final Duration sleepTime = Duration.ofSeconds(15L);
    private final Duration lockTime = Duration.ofSeconds(30L);
    private static final int DEFAULT_QUERY_PARTITIONS_MAX_BATCH_SIZE = 100;
    private static final int DEFAULT_DEGREE_OF_PARALLELISM = 25;
    private String hostName;
    private ChangeFeedContextClient feedContextClient;
    private ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private ChangeFeedObserverFactory observerFactory;
    private volatile String databaseResourceId;
    private volatile String collectionResourceId;
    private ChangeFeedContextClient leaseContextClient;
    private PartitionLoadBalancingStrategy loadBalancingStrategy;
    private LeaseStoreManager leaseStoreManager;
    private HealthMonitor healthMonitor;
    private volatile PartitionManager partitionManager;
    private Scheduler scheduler;

    @Override
    public Mono<Void> start() {
        if (this.partitionManager == null) {
            return this.initializeCollectionPropertiesForBuild().flatMap(value -> this.getLeaseStoreManager().flatMap(this::buildPartitionManager)).flatMap(partitionManager1 -> {
                this.partitionManager = partitionManager1;
                return this.partitionManager.start();
            });
        }
        return this.partitionManager.start();
    }

    @Override
    public Mono<Void> stop() {
        if (this.partitionManager == null || !this.partitionManager.isRunning()) {
            throw new IllegalStateException("The ChangeFeedProcessor instance has not fully started");
        }
        return this.partitionManager.stop();
    }

    @Override
    public boolean isStarted() {
        return this.partitionManager != null && this.partitionManager.isRunning();
    }

    @Override
    public Mono<Map<String, Integer>> getEstimatedLag() {
        ConcurrentHashMap earlyResult = new ConcurrentHashMap();
        if (this.leaseStoreManager == null || this.feedContextClient == null) {
            return Mono.just(earlyResult);
        }
        return this.leaseStoreManager.getAllLeases().flatMap(lease -> {
            FeedRangePartitionKeyRangeImpl feedRange = new FeedRangePartitionKeyRangeImpl(lease.getLeaseToken());
            CosmosChangeFeedRequestOptions options = ModelBridgeInternal.createChangeFeedRequestOptionsForChangeFeedState(lease.getContinuationState(this.collectionResourceId, feedRange));
            options.setMaxItemCount(1);
            return this.feedContextClient.createDocumentChangeFeedQuery(this.feedContextClient.getContainerClient(), options).take(1L).map(feedResponse -> {
                int estimatedLag;
                String ownerValue = lease.getOwner();
                String sessionTokenLsn = feedResponse.getSessionToken();
                String parsedSessionToken = sessionTokenLsn.substring(sessionTokenLsn.indexOf(PK_RANGE_ID_SEPARATOR));
                String[] segments = StringUtils.split(parsedSessionToken, SEGMENT_SEPARATOR);
                String latestLsn = segments[0];
                if (segments.length >= 2) {
                    latestLsn = segments[1];
                }
                if (ownerValue == null) {
                    ownerValue = "";
                }
                if (feedResponse.getResults() == null || feedResponse.getResults().size() == 0) {
                    return Pair.of(ownerValue + "_" + lease.getLeaseToken(), 0);
                }
                int currentLsn = 0;
                try {
                    currentLsn = Integer.parseInt(((JsonNode)feedResponse.getResults().get(0)).get(PROPERTY_NAME_LSN).asText("0"));
                    estimatedLag = Integer.parseInt(latestLsn);
                    estimatedLag = estimatedLag - currentLsn + 1;
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Unexpected Cosmos LSN found", (Throwable)ex);
                    estimatedLag = -1;
                }
                return Pair.of(ownerValue + "_" + lease.getLeaseToken() + "_" + currentLsn + "_" + latestLsn, estimatedLag);
            });
        }).collectList().map(valueList -> {
            ConcurrentHashMap<String, Integer> result = new ConcurrentHashMap<String, Integer>();
            for (Pair pair : valueList) {
                result.put((String)pair.getKey(), (Integer)pair.getValue());
            }
            return result;
        });
    }

    @Override
    public Mono<List<ChangeFeedProcessorState>> getCurrentState() {
        if (this.leaseStoreManager == null || this.feedContextClient == null) {
            return Mono.just(Collections.unmodifiableList(new ArrayList()));
        }
        return this.leaseStoreManager.getAllLeases().flatMap(lease -> {
            FeedRangePartitionKeyRangeImpl feedRange = new FeedRangePartitionKeyRangeImpl(lease.getLeaseToken());
            CosmosChangeFeedRequestOptions options = ModelBridgeInternal.createChangeFeedRequestOptionsForChangeFeedState(lease.getContinuationState(this.collectionResourceId, feedRange));
            options.setMaxItemCount(1);
            return this.feedContextClient.createDocumentChangeFeedQuery(this.feedContextClient.getContainerClient(), options).take(1L).map(feedResponse -> {
                String sessionTokenLsn = feedResponse.getSessionToken();
                String parsedSessionToken = sessionTokenLsn.substring(sessionTokenLsn.indexOf(PK_RANGE_ID_SEPARATOR));
                String[] segments = StringUtils.split(parsedSessionToken, SEGMENT_SEPARATOR);
                String latestLsn = segments[0];
                if (segments.length >= 2) {
                    latestLsn = segments[1];
                }
                ChangeFeedProcessorState changeFeedProcessorState = new ChangeFeedProcessorState().setHostName(lease.getOwner()).setLeaseToken(lease.getLeaseToken());
                if (feedResponse.getResults() == null || feedResponse.getResults().size() == 0) {
                    changeFeedProcessorState.setEstimatedLag(0).setContinuationToken(latestLsn);
                    return changeFeedProcessorState;
                }
                changeFeedProcessorState.setContinuationToken(((JsonNode)feedResponse.getResults().get(0)).get(PROPERTY_NAME_LSN).asText(null));
                try {
                    int currentLsn = Integer.parseInt(((JsonNode)feedResponse.getResults().get(0)).get(PROPERTY_NAME_LSN).asText("0"));
                    int estimatedLag = Integer.parseInt(latestLsn);
                    estimatedLag = estimatedLag - currentLsn + 1;
                    changeFeedProcessorState.setEstimatedLag(estimatedLag);
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Unexpected Cosmos LSN found", (Throwable)ex);
                    changeFeedProcessorState.setEstimatedLag(-1);
                }
                return changeFeedProcessorState;
            });
        }).collectList().map(Collections::unmodifiableList);
    }

    public ChangeFeedProcessorBuilderImpl hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl feedContainer(CosmosAsyncContainer feedDocumentClient) {
        if (feedDocumentClient == null) {
            throw new IllegalArgumentException("feedContextClient");
        }
        this.feedContextClient = new ChangeFeedContextClientImpl(feedDocumentClient);
        return this;
    }

    public ChangeFeedProcessorBuilderImpl options(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        if (changeFeedProcessorOptions == null) {
            throw new IllegalArgumentException("changeFeedProcessorOptions");
        }
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl observerFactory(ChangeFeedObserverFactory observerFactory) {
        if (observerFactory == null) {
            throw new IllegalArgumentException("observerFactory");
        }
        this.observerFactory = observerFactory;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl handleChanges(Consumer<List<JsonNode>> consumer) {
        return this.observerFactory(new DefaultObserverFactory(consumer));
    }

    public ChangeFeedProcessorBuilderImpl leaseContainer(CosmosAsyncContainer leaseClient) {
        if (leaseClient == null) {
            throw new IllegalArgumentException("leaseClient");
        }
        if (!CosmosBridgeInternal.getContextClient(leaseClient).isContentResponseOnWriteEnabled()) {
            throw new IllegalArgumentException("leaseClient: content response on write setting must be enabled");
        }
        ConsistencyLevel consistencyLevel = CosmosBridgeInternal.getContextClient(leaseClient).getConsistencyLevel();
        if (consistencyLevel == ConsistencyLevel.CONSISTENT_PREFIX || consistencyLevel == ConsistencyLevel.EVENTUAL) {
            this.logger.warn("leaseClient consistency level setting are less then expected which is SESSION");
        }
        this.leaseContextClient = new ChangeFeedContextClientImpl(leaseClient);
        return this;
    }

    public ChangeFeedProcessor build() {
        if (this.hostName == null) {
            throw new IllegalArgumentException("Host name was not specified");
        }
        if (this.observerFactory == null) {
            throw new IllegalArgumentException("Observer was not specified");
        }
        if (this.changeFeedProcessorOptions != null && this.changeFeedProcessorOptions.getLeaseAcquireInterval().compareTo(ChangeFeedProcessorOptions.DEFAULT_ACQUIRE_INTERVAL) < 0) {
            this.logger.warn("Found lower than expected setting for leaseAcquireInterval");
        }
        if (this.scheduler == null) {
            this.scheduler = Schedulers.elastic();
        }
        return this;
    }

    private Mono<ChangeFeedProcessor> initializeCollectionPropertiesForBuild() {
        if (this.changeFeedProcessorOptions == null) {
            this.changeFeedProcessorOptions = new ChangeFeedProcessorOptions();
        }
        return this.feedContextClient.readDatabase(this.feedContextClient.getDatabaseClient(), null).map(databaseResourceResponse -> {
            this.databaseResourceId = databaseResourceResponse.getProperties().getId();
            return this.databaseResourceId;
        }).flatMap(id -> this.feedContextClient.readContainer(this.feedContextClient.getContainerClient(), null).map(documentCollectionResourceResponse -> {
            this.collectionResourceId = documentCollectionResourceResponse.getProperties().getId();
            return this;
        }));
    }

    private Mono<LeaseStoreManager> getLeaseStoreManager() {
        if (this.leaseStoreManager == null) {
            return this.leaseContextClient.readContainerSettings(this.leaseContextClient.getContainerClient(), null).flatMap(collectionSettings -> {
                boolean isPartitioned;
                boolean bl = isPartitioned = collectionSettings.getPartitionKeyDefinition() != null && collectionSettings.getPartitionKeyDefinition().getPaths() != null && collectionSettings.getPartitionKeyDefinition().getPaths().size() > 0;
                if (!isPartitioned || collectionSettings.getPartitionKeyDefinition().getPaths().size() != 1 || !collectionSettings.getPartitionKeyDefinition().getPaths().get(0).equals("/id")) {
                    return Mono.error((Throwable)new IllegalArgumentException("The lease collection must have partition key equal to id."));
                }
                PartitionedByIdCollectionRequestOptionsFactory requestOptionsFactory = new PartitionedByIdCollectionRequestOptionsFactory();
                String leasePrefix = this.getLeasePrefix();
                return LeaseStoreManager.builder().leasePrefix(leasePrefix).leaseCollectionLink(this.leaseContextClient.getContainerClient()).leaseContextClient(this.leaseContextClient).requestOptionsFactory(requestOptionsFactory).hostName(this.hostName).build().map(manager -> {
                    this.leaseStoreManager = manager;
                    return this.leaseStoreManager;
                });
            });
        }
        return Mono.just((Object)this.leaseStoreManager);
    }

    private String getLeasePrefix() {
        String optionsPrefix = this.changeFeedProcessorOptions.getLeasePrefix();
        if (optionsPrefix == null) {
            optionsPrefix = "";
        }
        URI uri = this.feedContextClient.getServiceEndpoint();
        return String.format("%s%s_%s_%s", optionsPrefix, uri.getHost(), this.databaseResourceId, this.collectionResourceId);
    }

    private Mono<PartitionManager> buildPartitionManager(LeaseStoreManager leaseStoreManager) {
        CheckpointerObserverFactory factory = new CheckpointerObserverFactory(this.observerFactory, new CheckpointFrequency());
        PartitionSynchronizerImpl synchronizer = new PartitionSynchronizerImpl(this.feedContextClient, this.feedContextClient.getContainerClient(), leaseStoreManager, leaseStoreManager, 25, 100, this.collectionResourceId);
        BootstrapperImpl bootstrapper = new BootstrapperImpl(synchronizer, leaseStoreManager, this.lockTime, this.sleepTime);
        PartitionSupervisorFactoryImpl partitionSupervisorFactory = new PartitionSupervisorFactoryImpl(factory, leaseStoreManager, new PartitionProcessorFactoryImpl(this.feedContextClient, this.changeFeedProcessorOptions, leaseStoreManager, this.feedContextClient.getContainerClient(), this.collectionResourceId), this.changeFeedProcessorOptions, this.scheduler);
        if (this.loadBalancingStrategy == null) {
            this.loadBalancingStrategy = new EqualPartitionsBalancingStrategy(this.hostName, this.changeFeedProcessorOptions.getMinScaleCount(), this.changeFeedProcessorOptions.getMaxScaleCount(), this.changeFeedProcessorOptions.getLeaseExpirationInterval());
        }
        PartitionControllerImpl partitionController = new PartitionControllerImpl(leaseStoreManager, leaseStoreManager, partitionSupervisorFactory, synchronizer, this.scheduler);
        if (this.healthMonitor == null) {
            this.healthMonitor = new TraceHealthMonitor();
        }
        HealthMonitoringPartitionControllerDecorator partitionController2 = new HealthMonitoringPartitionControllerDecorator(partitionController, this.healthMonitor);
        PartitionLoadBalancerImpl partitionLoadBalancer = new PartitionLoadBalancerImpl(partitionController2, leaseStoreManager, this.loadBalancingStrategy, this.changeFeedProcessorOptions.getLeaseAcquireInterval(), this.scheduler);
        PartitionManagerImpl partitionManager = new PartitionManagerImpl(bootstrapper, partitionController, partitionLoadBalancer);
        return Mono.just((Object)partitionManager);
    }

    @Override
    public void close() {
        this.stop().subscribeOn(Schedulers.elastic()).subscribe();
    }
}

