/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStateDeserializer;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@JsonDeserialize(using=ChangeFeedStateDeserializer.class)
public abstract class ChangeFeedState
extends JsonSerializable {
    ChangeFeedState() {
    }

    public abstract FeedRangeContinuation getContinuation();

    public abstract ChangeFeedState setContinuation(FeedRangeContinuation var1);

    public abstract FeedRangeInternal getFeedRange();

    public abstract ChangeFeedMode getMode();

    public abstract ChangeFeedStartFromInternal getStartFromSettings();

    public abstract String applyServerResponseContinuation(String var1, RxDocumentServiceRequest var2);

    public abstract String getContainerRid();

    public static ChangeFeedState fromString(String base64EncodedJson) {
        Preconditions.checkNotNull(base64EncodedJson, "Argument 'base64EncodedJson' must not be null");
        String json = new String(Base64.getUrlDecoder().decode(base64EncodedJson), StandardCharsets.UTF_8);
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        try {
            return (ChangeFeedState)mapper.readValue(json, ChangeFeedState.class);
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException(String.format("The change feed state continuation contains invalid or unsupported json: %s", json), ioException);
        }
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
    }

    @Override
    public String toString() {
        String json = this.toJson();
        if (json == null) {
            return "";
        }
        return Base64.getUrlEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
    }

    public abstract void populateRequest(RxDocumentServiceRequest var1, int var2);
}

