/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ReadFeedKeyType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class FeedRangeEpkImpl
extends FeedRangeInternal {
    private static final FeedRangeEpkImpl fullRangeEPK = new FeedRangeEpkImpl(PartitionKeyInternalHelper.FullRange);
    private final Range<String> range;

    public FeedRangeEpkImpl(Range<String> range) {
        Preconditions.checkNotNull(range, "Argument 'range' must not be null");
        this.range = range;
    }

    public Range<String> getRange() {
        return this.range;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedRangeEpkImpl that = (FeedRangeEpkImpl)o;
        return Objects.equals(this.range, that.range);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.range);
    }

    public static FeedRangeEpkImpl forFullRange() {
        return fullRangeEPK;
    }

    @Override
    public Mono<Range<String>> getEffectiveRange(IRoutingMapProvider routingMapProvider, MetadataDiagnosticsContext metadataDiagnosticsCtx, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        return Mono.just(this.range);
    }

    @Override
    public Mono<List<String>> getPartitionKeyRanges(IRoutingMapProvider routingMapProvider, RxDocumentServiceRequest request, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        Preconditions.checkNotNull(routingMapProvider, "Argument 'routingMapProvider' must not be null");
        Preconditions.checkNotNull(request, "Argument 'request' must not be null");
        Preconditions.checkNotNull(collectionResolutionMono, "Argument 'collectionResolutionMono' must not be null");
        MetadataDiagnosticsContext metadataDiagnosticsCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        return collectionResolutionMono.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            String containerRid = collection.getResourceId();
            return routingMapProvider.tryGetOverlappingRangesAsync(metadataDiagnosticsCtx, containerRid, this.range, false, null).flatMap(pkRangeHolder -> {
                ArrayList<String> rangeList = new ArrayList<String>();
                if (pkRangeHolder.v != null) {
                    List pkRanges = (List)pkRangeHolder.v;
                    for (PartitionKeyRange pkRange : pkRanges) {
                        rangeList.add(pkRange.getId());
                    }
                }
                return Mono.just(UnmodifiableList.unmodifiableList(rangeList));
            });
        });
    }

    @Override
    public Mono<RxDocumentServiceRequest> populateFeedRangeFilteringHeaders(IRoutingMapProvider routingMapProvider, RxDocumentServiceRequest request, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        Preconditions.checkNotNull(routingMapProvider, "Argument 'routingMapProvider' must not be null");
        Preconditions.checkNotNull(request, "Argument 'request' must not be null");
        Preconditions.checkNotNull(collectionResolutionMono, "Argument 'collectionResolutionMono' must not be null");
        MetadataDiagnosticsContext metadataDiagnosticsCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        return collectionResolutionMono.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            String containerRid = collection.getResourceId();
            request.setEffectiveRange(this.range);
            return routingMapProvider.tryGetOverlappingRangesAsync(metadataDiagnosticsCtx, containerRid, this.range, false, null).flatMap(pkRangeHolder -> {
                if (pkRangeHolder == null) {
                    return Mono.error((Throwable)((Object)new NotFoundException(String.format("Stale cache for collection rid '%s'.", containerRid))));
                }
                List pkRanges = (List)pkRangeHolder.v;
                if (pkRanges == null || pkRanges.size() == 0) {
                    return Mono.error((Throwable)((Object)new NotFoundException(String.format("Stale cache for collection rid '%s'.", containerRid))));
                }
                if (pkRanges.size() > 1) {
                    GoneException goneException = new GoneException(String.format("Epk Range '%s' is gone.", this.range));
                    BridgeInternal.setSubStatusCode(goneException, 1002);
                    return Mono.error((Throwable)((Object)goneException));
                }
                Range<String> singleRange = ((PartitionKeyRange)pkRanges.get(0)).toRange();
                if (singleRange.getMin().equals(this.range.getMin()) && singleRange.getMax().equals(this.range.getMax())) {
                    request.routeTo(new PartitionKeyRangeIdentity(((PartitionKeyRange)pkRanges.get(0)).getId()));
                } else {
                    request.routeTo(new PartitionKeyRangeIdentity(((PartitionKeyRange)pkRanges.get(0)).getId()));
                    Map<String, String> headers = request.getHeaders();
                    headers.put("x-ms-read-key-type", ReadFeedKeyType.EffectivePartitionKeyRange.name());
                    headers.put("x-ms-start-epk", this.range.getMin());
                    headers.put("x-ms-end-epk", this.range.getMax());
                }
                return Mono.just((Object)request);
            });
        });
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        this.setProperties(this, false);
    }

    @Override
    public void setProperties(JsonSerializable serializable, boolean populateProperties) {
        Preconditions.checkNotNull(serializable, "Argument 'serializable' must not be null.");
        if (populateProperties) {
            super.populatePropertyBag();
        }
        if (this.range != null) {
            ModelBridgeInternal.populatePropertyBag(this.range);
            BridgeInternal.setProperty(serializable, "Range", this.range);
        }
    }

    @Override
    public void removeProperties(JsonSerializable serializable) {
        Preconditions.checkNotNull(serializable, "Argument 'serializable' must not be null.");
        serializable.remove("Range");
    }
}

