/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternalDeserializer;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedRange;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@JsonDeserialize(using=FeedRangeInternalDeserializer.class)
public abstract class FeedRangeInternal
extends JsonSerializable
implements FeedRange {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedRangeInternal.class);

    public static FeedRangeInternal convert(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null");
        if (feedRange instanceof FeedRangeInternal) {
            return (FeedRangeInternal)feedRange;
        }
        String json = feedRange.toString();
        return FeedRangeInternal.fromBase64EncodedJsonString(json);
    }

    public static FeedRangeInternal fromBase64EncodedJsonString(String base64EncodedJson) {
        Preconditions.checkNotNull(base64EncodedJson, "Argument 'base64EncodedJson' must not be null");
        String json = new String(Base64.getUrlDecoder().decode(base64EncodedJson), StandardCharsets.UTF_8);
        FeedRangeInternal parsedRange = FeedRangeInternal.tryParse(json);
        if (parsedRange == null) {
            throw new IllegalArgumentException(String.format("The provided string '%s' does not represent any known format.", json));
        }
        return parsedRange;
    }

    public abstract Mono<Range<String>> getEffectiveRange(IRoutingMapProvider var1, MetadataDiagnosticsContext var2, Mono<Utils.ValueHolder<DocumentCollection>> var3);

    public abstract Mono<List<String>> getPartitionKeyRanges(IRoutingMapProvider var1, RxDocumentServiceRequest var2, Mono<Utils.ValueHolder<DocumentCollection>> var3);

    public abstract Mono<RxDocumentServiceRequest> populateFeedRangeFilteringHeaders(IRoutingMapProvider var1, RxDocumentServiceRequest var2, Mono<Utils.ValueHolder<DocumentCollection>> var3);

    @Override
    public void populatePropertyBag() {
        this.setProperties(this, false);
    }

    public abstract void removeProperties(JsonSerializable var1);

    public void setProperties(JsonSerializable serializable, boolean populateProperties) {
        if (populateProperties) {
            super.populatePropertyBag();
        }
    }

    @Override
    public String toString() {
        String json = this.toJson();
        if (json == null) {
            return "";
        }
        return Base64.getUrlEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
    }

    public static FeedRangeInternal tryParse(String jsonString) {
        Preconditions.checkNotNull(jsonString, "Argument 'jsonString' must not be null");
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        try {
            return (FeedRangeInternal)mapper.readValue(jsonString, FeedRangeInternal.class);
        }
        catch (IOException ioError) {
            LOGGER.debug("Failed to parse feed range JSON {}", (Object)jsonString, (Object)ioError);
            return null;
        }
    }
}

