/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.cpu;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.cpu.CpuLoad;
import com.azure.cosmos.implementation.cpu.CpuLoadHistory;
import com.azure.cosmos.implementation.cpu.CpuMemoryListener;
import com.azure.cosmos.implementation.cpu.CpuMemoryReader;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuMemoryMonitor {
    private static final int DEFAULT_REFRESH_INTERVAL_IN_SECONDS = 5;
    private static final int HISTORY_LENGTH = 6;
    private static Duration refreshInterval = Duration.ofSeconds(5L);
    private static final Logger logger = LoggerFactory.getLogger(CpuMemoryMonitor.class);
    private static final CpuMemoryReader CPU_MEMORY_READER = new CpuMemoryReader();
    private static final ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());
    private static final ReentrantReadWriteLock rwLock;
    private static final List<WeakReference<CpuMemoryListener>> cpuListeners;
    private static final Object lifeCycleLock;
    private static final CpuLoadHistory DEFAULT_READING;
    private static CpuLoadHistory currentReading;
    private static final CpuLoad[] buffer;
    private static final int clientTelemetryLength;
    private static double[] clientTelemetryCpuLatestList;
    private static double[] clientTelemetryMemoryLatestList;
    private static ScheduledFuture<?> future;
    private static int clockHand;
    private static int clientTelemetryIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(CpuMemoryListener listener) {
        Object object = lifeCycleLock;
        synchronized (object) {
            if (cpuListeners.size() == 0) {
                CpuMemoryMonitor.start();
            }
            cpuListeners.add(new WeakReference<CpuMemoryListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(CpuMemoryListener listener) {
        Object object = lifeCycleLock;
        synchronized (object) {
            Iterator<WeakReference<CpuMemoryListener>> it = cpuListeners.iterator();
            while (it.hasNext()) {
                WeakReference<CpuMemoryListener> reference = it.next();
                CpuMemoryListener val = (CpuMemoryListener)reference.get();
                if (val != null && val != listener) continue;
                it.remove();
            }
            if (cpuListeners.isEmpty()) {
                CpuMemoryMonitor.closeInternal();
            }
        }
    }

    public static CpuLoadHistory getCpuLoad() {
        rwLock.readLock().lock();
        try {
            CpuLoadHistory cpuLoadHistory = currentReading;
            return cpuLoadHistory;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }

    public static double[] getClientTelemetryCpuLatestList() {
        rwLock.readLock().lock();
        try {
            double[] dArray = clientTelemetryCpuLatestList;
            return dArray;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }

    public static double[] getClientTelemetryMemoryLatestList() {
        rwLock.readLock().lock();
        try {
            double[] dArray = clientTelemetryMemoryLatestList;
            return dArray;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeInternal() {
        Object object = lifeCycleLock;
        synchronized (object) {
            if (future != null) {
                future.cancel(false);
                future = null;
            }
            rwLock.writeLock().lock();
            try {
                currentReading = DEFAULT_READING;
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refresh() {
        block9: {
            try {
                Instant now = Instant.now();
                float currentCpuUtilization = CPU_MEMORY_READER.getSystemWideCpuUsage() * 100.0f;
                float currentMemoryUtilization = CPU_MEMORY_READER.getSystemWideMemoryUsage();
                if (Float.isNaN(currentCpuUtilization) || !(currentCpuUtilization >= 0.0f)) break block9;
                ArrayList<CpuLoad> cpuLoadHistory = new ArrayList<CpuLoad>(buffer.length);
                CpuLoadHistory newReading = new CpuLoadHistory(cpuLoadHistory, refreshInterval);
                CpuMemoryMonitor.buffer[CpuMemoryMonitor.clockHand] = new CpuLoad(now, currentCpuUtilization);
                clockHand = (clockHand + 1) % buffer.length;
                CpuMemoryMonitor.clientTelemetryCpuLatestList[CpuMemoryMonitor.clientTelemetryIndex] = currentCpuUtilization;
                CpuMemoryMonitor.clientTelemetryMemoryLatestList[CpuMemoryMonitor.clientTelemetryIndex] = currentMemoryUtilization;
                clientTelemetryIndex = (clientTelemetryIndex + 1) % clientTelemetryLength;
                for (int i = 0; i < buffer.length; ++i) {
                    int index = (clockHand + i) % buffer.length;
                    if (buffer[index] == null || CpuMemoryMonitor.buffer[index].timestamp == null || CpuMemoryMonitor.buffer[index].timestamp.equals(Instant.MIN)) continue;
                    cpuLoadHistory.add(buffer[index]);
                }
                Object object = lifeCycleLock;
                synchronized (object) {
                    CpuMemoryMonitor.unregister(null);
                }
                rwLock.writeLock().lock();
                try {
                    currentReading = newReading;
                }
                finally {
                    rwLock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                logger.error("Failed to refresh the cpu history", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        Object object = lifeCycleLock;
        synchronized (object) {
            rwLock.writeLock().lock();
            try {
                currentReading = DEFAULT_READING;
                future = scheduledExecutorService.scheduleAtFixedRate(() -> CpuMemoryMonitor.refresh(), 0L, refreshInterval.toMillis() / TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS);
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    static {
        scheduledExecutorService.setRemoveOnCancelPolicy(true);
        rwLock = new ReentrantReadWriteLock();
        cpuListeners = new ArrayList<WeakReference<CpuMemoryListener>>();
        lifeCycleLock = new Object();
        currentReading = DEFAULT_READING = new CpuLoadHistory(Collections.emptyList(), refreshInterval);
        buffer = new CpuLoad[6];
        clientTelemetryLength = Configs.getClientTelemetrySchedulingInSec() / 5;
        clientTelemetryCpuLatestList = new double[clientTelemetryLength];
        clientTelemetryMemoryLatestList = new double[clientTelemetryLength];
        clockHand = 0;
        clientTelemetryIndex = 0;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

