/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

final class FeedRangeCompositeContinuationImpl
extends FeedRangeContinuation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedRangeCompositeContinuationImpl.class);
    private final Queue<CompositeContinuationToken> compositeContinuationTokens = new LinkedList<CompositeContinuationToken>();
    private CompositeContinuationToken currentToken;
    private String initialNoResultsRange;

    public FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange, List<Range<String>> ranges) {
        this(containerRid, feedRange, ranges, null);
    }

    public FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange, List<Range<String>> ranges, String continuation) {
        this(containerRid, feedRange);
        Preconditions.checkNotNull(ranges, "'ranges' must not be null");
        if (ranges.size() == 0) {
            throw new IllegalArgumentException("'ranges' must not be empty");
        }
        for (Range<String> range : ranges) {
            this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(range.getMin(), range.getMax(), continuation));
        }
        this.currentToken = this.getCompositeContinuationTokens().peek();
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        BridgeInternal.setProperty(this, "V", 1);
        BridgeInternal.setProperty(this, "Rid", this.getContainerRid());
        if (this.compositeContinuationTokens.size() > 0) {
            for (CompositeContinuationToken token : this.compositeContinuationTokens) {
                ModelBridgeInternal.populatePropertyBag(token);
            }
            BridgeInternal.setProperty(this, "Continuation", this.compositeContinuationTokens);
        }
        if (this.feedRange != null) {
            this.feedRange.setProperties(this, true);
        }
    }

    private FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange) {
        super(containerRid, feedRange);
    }

    public Queue<CompositeContinuationToken> getCompositeContinuationTokens() {
        return this.compositeContinuationTokens;
    }

    public CompositeContinuationToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public FeedRangeInternal getFeedRange() {
        if (!(this.feedRange instanceof FeedRangeEpkImpl)) {
            return this.feedRange;
        }
        if (this.currentToken != null) {
            return new FeedRangeEpkImpl(this.currentToken.getRange());
        }
        return null;
    }

    @Override
    public CompositeContinuationToken getCurrentContinuationToken() {
        CompositeContinuationToken tokenSnapshot = this.currentToken;
        if (tokenSnapshot == null) {
            return null;
        }
        return tokenSnapshot;
    }

    @Override
    public int getContinuationTokenCount() {
        return this.compositeContinuationTokens.size();
    }

    @Override
    public void replaceContinuation(String continuationToken) {
        CompositeContinuationToken continuationTokenSnapshot = this.currentToken;
        if (continuationTokenSnapshot == null) {
            return;
        }
        continuationTokenSnapshot.setToken(continuationToken);
        this.moveToNextToken();
    }

    @Override
    public boolean isDone() {
        return this.compositeContinuationTokens.size() == 0;
    }

    @Override
    public void validateContainer(String containerRid) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty(containerRid) || !containerRid.equals(this.getContainerRid())) {
            String message = String.format("The continuation was generated for container %s but current container is %s.", this.getContainerRid(), containerRid);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public <T extends Resource> ShouldRetryResult handleChangeFeedNotModified(FeedResponse<T> response) {
        Preconditions.checkNotNull(response, "Argument 'response' must not be null");
        if (!ModelBridgeInternal.noChanges(response)) {
            this.initialNoResultsRange = null;
        } else if (this.compositeContinuationTokens.size() > 1) {
            String eTag = this.currentToken.getToken();
            if (this.initialNoResultsRange == null) {
                this.initialNoResultsRange = this.currentToken.getRange().getMin();
                this.replaceContinuation(eTag);
                this.moveToNextToken();
                return ShouldRetryResult.RETRY_NOW;
            }
            if (!this.initialNoResultsRange.equalsIgnoreCase(this.currentToken.getRange().getMin())) {
                this.replaceContinuation(eTag);
                this.moveToNextToken();
                return ShouldRetryResult.RETRY_NOW;
            }
        }
        return ShouldRetryResult.NO_RETRY;
    }

    @Override
    public Mono<ShouldRetryResult> handleSplit(RxDocumentClientImpl client, GoneException goneException) {
        boolean partitionSplit;
        Preconditions.checkNotNull(client, "Argument 'client' must not be null");
        Preconditions.checkNotNull(goneException, "Argument 'goeException' must not be null");
        Integer nSubStatus = goneException.getSubStatusCode();
        boolean bl = partitionSplit = goneException.getStatusCode() == 410 && nSubStatus != null && (nSubStatus == 1002 || nSubStatus == 1007);
        if (!partitionSplit) {
            return Mono.just((Object)ShouldRetryResult.NO_RETRY);
        }
        RxPartitionKeyRangeCache partitionKeyRangeCache = client.getPartitionKeyRangeCache();
        Mono<Utils.ValueHolder<List<PartitionKeyRange>>> resolvedRangesTask = this.tryGetOverlappingRanges(partitionKeyRangeCache, this.currentToken.getRange().getMin(), this.currentToken.getRange().getMax(), true);
        return resolvedRangesTask.flatMap(resolvedRanges -> {
            if (resolvedRanges.v != null && ((List)resolvedRanges.v).size() > 0) {
                this.createChildRanges((List)resolvedRanges.v);
            }
            return Mono.just((Object)ShouldRetryResult.RETRY_NOW);
        });
    }

    public static FeedRangeCompositeContinuationImpl createFromDeserializedTokens(String containerRid, FeedRangeInternal feedRange, List<CompositeContinuationToken> deserializedTokens) {
        FeedRangeCompositeContinuationImpl thisPtr = new FeedRangeCompositeContinuationImpl(containerRid, feedRange);
        Preconditions.checkNotNull(deserializedTokens, "'deserializedTokens' must not be null");
        if (deserializedTokens.size() == 0) {
            throw new IllegalArgumentException("'deserializedTokens' must not be empty");
        }
        thisPtr.compositeContinuationTokens.addAll(deserializedTokens);
        thisPtr.currentToken = thisPtr.getCompositeContinuationTokens().peek();
        return thisPtr;
    }

    public static FeedRangeContinuation parse(String jsonString) throws IOException {
        Preconditions.checkNotNull(jsonString, "Argument 'jsonString' must not be null");
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        return (FeedRangeContinuation)mapper.readValue(jsonString, FeedRangeContinuation.class);
    }

    @Override
    public String toString() {
        try {
            return Utils.getSimpleObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable serialize the composite FeedRange continuation token into a JSON string", e);
        }
    }

    private void createChildRanges(List<PartitionKeyRange> keyRanges) {
        PartitionKeyRange firstRange = keyRanges.get(0);
        this.currentToken.setRange(new Range<String>(firstRange.getMinInclusive(), firstRange.getMaxExclusive(), true, false));
        CompositeContinuationToken continuationAsComposite = FeedRangeCompositeContinuationImpl.tryParseAsCompositeContinuationToken(this.currentToken.getToken());
        if (continuationAsComposite != null) {
            continuationAsComposite.setRange(this.currentToken.getRange());
            this.currentToken.setToken(continuationAsComposite.toJson());
            int size = keyRanges.size();
            for (int i = 1; i < size; ++i) {
                PartitionKeyRange keyRange = keyRanges.get(i);
                continuationAsComposite.setRange(keyRange.toRange());
                this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(keyRange.getMinInclusive(), keyRange.getMaxExclusive(), continuationAsComposite.toJson()));
            }
        } else {
            int size = keyRanges.size();
            for (int i = 1; i < size; ++i) {
                PartitionKeyRange keyRange = keyRanges.get(i);
                this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(keyRange.getMinInclusive(), keyRange.getMaxExclusive(), this.currentToken.getToken()));
            }
        }
    }

    private static CompositeContinuationToken createCompositeContinuationTokenForRange(String minInclusive, String maxExclusive, String token) {
        return new CompositeContinuationToken(token, new Range<String>(minInclusive, maxExclusive, true, false));
    }

    private void moveToNextToken() {
        CompositeContinuationToken recentToken = this.compositeContinuationTokens.poll();
        this.compositeContinuationTokens.add(recentToken);
        this.currentToken = this.compositeContinuationTokens.size() > 0 ? this.compositeContinuationTokens.peek() : null;
    }

    private Mono<Utils.ValueHolder<List<PartitionKeyRange>>> tryGetOverlappingRanges(RxPartitionKeyRangeCache partitionKeyRangeCache, String min, String max, Boolean forceRefresh) {
        return partitionKeyRangeCache.tryGetOverlappingRangesAsync(null, this.getContainerRid(), new Range<String>(min, max, false, true), forceRefresh, null);
    }

    private static CompositeContinuationToken tryParseAsCompositeContinuationToken(String providedContinuation) {
        try {
            ObjectMapper mapper = Utils.getSimpleObjectMapper();
            if (providedContinuation == null) {
                return null;
            }
            if (providedContinuation.trim().startsWith("[")) {
                List<CompositeContinuationToken> compositeContinuationTokens = Arrays.asList((CompositeContinuationToken[])mapper.readValue(providedContinuation, CompositeContinuationToken[].class));
                if (compositeContinuationTokens.size() > 0) {
                    return compositeContinuationTokens.get(0);
                }
                return null;
            }
            if (providedContinuation.trim().startsWith("{")) {
                return (CompositeContinuationToken)mapper.readValue(providedContinuation, CompositeContinuationToken.class);
            }
            return null;
        }
        catch (IOException ioError) {
            LOGGER.debug("Failed to parse as composite continuation token JSON {}", (Object)providedContinuation, (Object)ioError);
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FeedRangeCompositeContinuationImpl)) {
            return false;
        }
        FeedRangeCompositeContinuationImpl other = (FeedRangeCompositeContinuationImpl)o;
        return Objects.equals(this.feedRange, other.feedRange) && Objects.equals(this.getContainerRid(), other.getContainerRid()) && Objects.equals(this.initialNoResultsRange, other.initialNoResultsRange) && Objects.equals(this.currentToken, other.currentToken) && Objects.equals(this.compositeContinuationTokens, other.compositeContinuationTokens);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.feedRange, this.getContainerRid(), this.initialNoResultsRange, this.currentToken, this.compositeContinuationTokens);
    }
}

