/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.implementation.batch.ServerBatchRequest;
import com.azure.cosmos.implementation.batch.ServerOperationBatchRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.List;

public final class PartitionKeyRangeServerBatchRequest
extends ServerBatchRequest {
    private final String partitionKeyRangeId;

    private PartitionKeyRangeServerBatchRequest(String partitionKeyRangeId, int maxBodyLength, int maxOperationCount) {
        super(maxBodyLength, maxOperationCount);
        Preconditions.checkNotNull(partitionKeyRangeId, "expected non-null partitionKeyRangeId");
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    static ServerOperationBatchRequest createBatchRequest(String partitionKeyRangeId, List<CosmosItemOperation> operations, int maxBodyLength, int maxOperationCount) {
        PartitionKeyRangeServerBatchRequest request = new PartitionKeyRangeServerBatchRequest(partitionKeyRangeId, maxBodyLength, maxOperationCount);
        request.setAtomicBatch(false);
        request.setShouldContinueOnError(true);
        List<CosmosItemOperation> pendingOperations = request.createBodyOfBatchRequest(operations);
        return new ServerOperationBatchRequest(request, pendingOperations);
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }
}

