/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class FeedRangePartitionKeyRangeImpl
extends FeedRangeInternal {
    private final String partitionKeyRangeId;
    private final PartitionKeyRangeIdentity partitionKeyRangeIdentity;

    public FeedRangePartitionKeyRangeImpl(String partitionKeyRangeId) {
        Preconditions.checkNotNull(partitionKeyRangeId, "Argument 'partitionKeyRangeId' must not be null");
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.partitionKeyRangeIdentity = new PartitionKeyRangeIdentity(partitionKeyRangeId);
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    public PartitionKeyRangeIdentity getPartitionKeyRangeIdentity() {
        return this.partitionKeyRangeIdentity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedRangePartitionKeyRangeImpl that = (FeedRangePartitionKeyRangeImpl)o;
        return Objects.equals(this.partitionKeyRangeId, that.partitionKeyRangeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionKeyRangeId);
    }

    @Override
    protected Mono<Range<String>> getEffectiveRange(IRoutingMapProvider routingMapProvider, MetadataDiagnosticsContext metadataDiagnosticsCtx, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        Preconditions.checkNotNull(routingMapProvider, "Argument 'routingMapProvider' must not be null");
        Preconditions.checkNotNull(collectionResolutionMono, "Argument 'collectionResolutionMono' must not be null");
        return collectionResolutionMono.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            return routingMapProvider.tryGetPartitionKeyRangeByIdAsync(metadataDiagnosticsCtx, collection.getResourceId(), this.partitionKeyRangeId, false, null).flatMap(pkRangeHolder -> {
                if (pkRangeHolder.v == null) {
                    return routingMapProvider.tryGetPartitionKeyRangeByIdAsync(null, collection.getResourceId(), this.partitionKeyRangeId, true, null);
                }
                return Mono.just((Object)pkRangeHolder);
            }).flatMap(pkRangeHolder -> {
                if (pkRangeHolder.v == null) {
                    return Mono.error((Throwable)((Object)new PartitionKeyRangeGoneException(String.format("The PartitionKeyRangeId: \"%s\" is not valid for the current container %s .", this.partitionKeyRangeId, collection.getResourceId()))));
                }
                return Mono.just(((PartitionKeyRange)pkRangeHolder.v).toRange());
            });
        });
    }

    @Override
    public Mono<List<String>> getPartitionKeyRanges(IRoutingMapProvider routingMapProvider, RxDocumentServiceRequest request, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(this.partitionKeyRangeId);
        return Mono.just(UnmodifiableList.unmodifiableList(temp));
    }

    @Override
    public Mono<RxDocumentServiceRequest> populateFeedRangeFilteringHeaders(IRoutingMapProvider routingMapProvider, RxDocumentServiceRequest request, Mono<Utils.ValueHolder<DocumentCollection>> collectionResolutionMono) {
        Preconditions.checkNotNull(request, "Argument 'request' must not be null");
        request.routeTo(this.partitionKeyRangeIdentity);
        MetadataDiagnosticsContext metadataDiagnosticsCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        return this.getNormalizedEffectiveRange(routingMapProvider, metadataDiagnosticsCtx, collectionResolutionMono).map(effectiveRange -> {
            request.setEffectiveRange((Range<String>)effectiveRange);
            return request;
        });
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        this.setProperties(this, false);
    }

    @Override
    public void removeProperties(JsonSerializable serializable) {
        Preconditions.checkNotNull(serializable, "Argument 'serializable' must not be null.");
        serializable.remove("PKRangeId");
    }

    @Override
    public void setProperties(JsonSerializable serializable, boolean populateProperties) {
        Preconditions.checkNotNull(serializable, "Argument 'serializable' must not be null.");
        if (populateProperties) {
            super.populatePropertyBag();
        }
        if (this.partitionKeyRangeId != null) {
            BridgeInternal.setProperty(serializable, "PKRangeId", this.partitionKeyRangeId);
        }
    }
}

