/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.implementation.ByteBufferOutputStream;
import com.azure.cosmos.implementation.Bytes;
import com.azure.cosmos.implementation.routing.HexConvert;
import com.azure.cosmos.implementation.routing.IPartitionKeyComponent;
import com.azure.cosmos.implementation.routing.Int128;
import com.azure.cosmos.implementation.routing.MurmurHash3_128;
import com.azure.cosmos.implementation.routing.MurmurHash3_32;
import com.azure.cosmos.implementation.routing.NumberPartitionKeyComponent;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.routing.UInt128;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.PartitionKind;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class PartitionKeyInternalHelper {
    public static final String MinimumInclusiveEffectivePartitionKey = PartitionKeyInternalHelper.toHexEncodedBinaryString(PartitionKeyInternal.EmptyPartitionKey.components);
    public static final String MaximumExclusiveEffectivePartitionKey = PartitionKeyInternalHelper.toHexEncodedBinaryString(PartitionKeyInternal.InfinityPartitionKey.components);
    public static final Range<String> FullRange = new Range<String>(MinimumInclusiveEffectivePartitionKey, MaximumExclusiveEffectivePartitionKey, true, false);
    static final int MaxPartitionKeyBinarySize = 336;
    public static final Int128 MaxHashV2Value = new Int128(new byte[]{63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});

    static byte[] uIntToBytes(UInt128 unit) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(unit.low);
        buffer.putLong(unit.high);
        return buffer.array();
    }

    static long asUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static String toHexEncodedBinaryString(IPartitionKeyComponent ... components) {
        ByteBufferOutputStream stream = new ByteBufferOutputStream(336);
        for (IPartitionKeyComponent component : components) {
            component.writeForBinaryEncoding(stream);
        }
        return HexConvert.bytesToHex(stream.asByteBuffer());
    }

    static String toHexEncodedBinaryString(List<IPartitionKeyComponent> components) {
        ByteBufferOutputStream stream = new ByteBufferOutputStream(336);
        for (IPartitionKeyComponent component : components) {
            component.writeForBinaryEncoding(stream);
        }
        return HexConvert.bytesToHex(stream.asByteBuffer());
    }

    public static String getEffectivePartitionKeyForHashPartitioningV2(PartitionKeyInternal partitionKeyInternal) {
        String string;
        ByteBufferOutputStream byteArrayBuffer = new ByteBufferOutputStream();
        try {
            for (int i = 0; i < partitionKeyInternal.components.size(); ++i) {
                partitionKeyInternal.components.get(i).writeForHashingV2(byteArrayBuffer);
            }
            ByteBuffer byteBuffer = byteArrayBuffer.asByteBuffer();
            UInt128 hashAsUnit128 = MurmurHash3_128.hash128(byteBuffer.array(), byteBuffer.limit());
            byte[] hash = PartitionKeyInternalHelper.uIntToBytes(hashAsUnit128);
            Bytes.reverse(hash);
            hash[0] = (byte)(hash[0] & 0x3F);
            string = HexConvert.bytesToHex(hash);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayBuffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        byteArrayBuffer.close();
        return string;
    }

    static String getEffectivePartitionKeyForHashPartitioning(PartitionKeyInternal partitionKeyInternal) {
        double hash;
        IPartitionKeyComponent[] truncatedComponents = new IPartitionKeyComponent[partitionKeyInternal.components.size()];
        for (int i = 0; i < truncatedComponents.length; ++i) {
            truncatedComponents[i] = partitionKeyInternal.components.get(i).truncate();
        }
        try (ByteBufferOutputStream byteArrayBuffer = new ByteBufferOutputStream();){
            for (int i = 0; i < truncatedComponents.length; ++i) {
                truncatedComponents[i].writeForHashing(byteArrayBuffer);
            }
            ByteBuffer byteBuffer = byteArrayBuffer.asByteBuffer();
            int hashAsInt = MurmurHash3_32.hash(byteBuffer.array(), byteBuffer.limit(), 0);
            hash = PartitionKeyInternalHelper.asUnsignedLong(hashAsInt);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        IPartitionKeyComponent[] partitionKeyComponents = new IPartitionKeyComponent[partitionKeyInternal.components.size() + 1];
        partitionKeyComponents[0] = new NumberPartitionKeyComponent(hash);
        for (int i = 0; i < truncatedComponents.length; ++i) {
            partitionKeyComponents[i + 1] = truncatedComponents[i];
        }
        return PartitionKeyInternalHelper.toHexEncodedBinaryString(partitionKeyComponents);
    }

    public static String getEffectivePartitionKeyString(PartitionKeyInternal partitionKeyInternal, PartitionKeyDefinition partitionKeyDefinition) {
        return PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, partitionKeyDefinition, true);
    }

    public static String getEffectivePartitionKeyString(PartitionKeyInternal partitionKeyInternal, PartitionKeyDefinition partitionKeyDefinition, boolean strict) {
        if (partitionKeyInternal.components == null) {
            throw new IllegalArgumentException("PartitionKey has fewer components than defined the collection resource.");
        }
        if (partitionKeyInternal.equals(PartitionKeyInternal.EmptyPartitionKey)) {
            return MinimumInclusiveEffectivePartitionKey;
        }
        if (partitionKeyInternal.equals(PartitionKeyInternal.InfinityPartitionKey)) {
            return MaximumExclusiveEffectivePartitionKey;
        }
        if (partitionKeyInternal.components.size() < partitionKeyDefinition.getPaths().size()) {
            throw new IllegalArgumentException("PartitionKey has fewer components than defined the collection resource.");
        }
        if (partitionKeyInternal.components.size() > partitionKeyDefinition.getPaths().size() && strict) {
            throw new IllegalArgumentException("PartitionKey has more components than defined the collection resource.");
        }
        PartitionKind kind = partitionKeyDefinition.getKind();
        if (kind == null) {
            kind = PartitionKind.HASH;
        }
        switch (kind) {
            case HASH: {
                if (ModelBridgeInternal.isV2(partitionKeyDefinition)) {
                    return PartitionKeyInternalHelper.getEffectivePartitionKeyForHashPartitioningV2(partitionKeyInternal);
                }
                return PartitionKeyInternalHelper.getEffectivePartitionKeyForHashPartitioning(partitionKeyInternal);
            }
        }
        return PartitionKeyInternalHelper.toHexEncodedBinaryString(partitionKeyInternal.components);
    }
}

