/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedState;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.util.Beta;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class CosmosChangeFeedRequestOptions {
    private static final int DEFAULT_MAX_ITEM_COUNT = 100;
    private static final int DEFAULT_MAX_PREFETCH_PAGE_COUNT = 1;
    private final ChangeFeedState continuationState;
    private final FeedRangeInternal feedRangeInternal;
    private final Map<String, Object> properties;
    private int maxItemCount;
    private int maxPrefetchPageCount;
    private ChangeFeedMode mode;
    private ChangeFeedStartFromInternal startFromInternal;
    private boolean isSplitHandlingDisabled;
    private boolean quotaInfoEnabled;
    private String throughputControlGroupName;

    private CosmosChangeFeedRequestOptions(FeedRangeInternal feedRange, ChangeFeedStartFromInternal startFromInternal, ChangeFeedMode mode, ChangeFeedState continuationState) {
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        if (startFromInternal == null) {
            throw new NullPointerException("startFromInternal");
        }
        this.maxItemCount = 100;
        this.maxPrefetchPageCount = 1;
        this.feedRangeInternal = feedRange;
        this.startFromInternal = startFromInternal;
        this.continuationState = continuationState;
        if (mode != ChangeFeedMode.INCREMENTAL && mode != ChangeFeedMode.FULL_FIDELITY) {
            throw new IllegalArgumentException(String.format("Argument 'mode' has unsupported change feed mode %s", mode.toString()));
        }
        this.mode = mode;
        this.properties = new HashMap<String, Object>();
        this.isSplitHandlingDisabled = false;
    }

    ChangeFeedState getContinuation() {
        return this.continuationState;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public FeedRange getFeedRange() {
        return this.feedRangeInternal;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getMaxItemCount() {
        return this.maxItemCount;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions setMaxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getMaxPrefetchPageCount() {
        return this.maxPrefetchPageCount;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions setMaxPrefetchPageCount(int maxPrefetchPageCount) {
        Preconditions.checkArgument(maxPrefetchPageCount > 0, "Argument 'maxPrefetchCount' must be larger than 0.");
        this.maxPrefetchPageCount = maxPrefetchPageCount;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public boolean isQuotaInfoEnabled() {
        return this.quotaInfoEnabled;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public void setQuotaInfoEnabled(boolean quotaInfoEnabled) {
        this.quotaInfoEnabled = quotaInfoEnabled;
    }

    boolean isSplitHandlingDisabled() {
        return this.isSplitHandlingDisabled;
    }

    CosmosChangeFeedRequestOptions disableSplitHandling() {
        this.isSplitHandlingDisabled = true;
        return this;
    }

    ChangeFeedMode getMode() {
        return this.mode;
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    ChangeFeedStartFromInternal getStartFromSettings() {
        return this.startFromInternal;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosChangeFeedRequestOptions createForProcessingFromBeginning(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null.");
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromBeginning(), ChangeFeedMode.INCREMENTAL, null);
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosChangeFeedRequestOptions createForProcessingFromContinuation(String continuation) {
        ChangeFeedState changeFeedState = ChangeFeedState.fromString(continuation);
        return CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(changeFeedState);
    }

    static CosmosChangeFeedRequestOptions createForProcessingFromContinuation(ChangeFeedState changeFeedState) {
        FeedRangeInternal feedRange = changeFeedState.getFeedRange();
        FeedRangeContinuation continuation = changeFeedState.getContinuation();
        ChangeFeedMode mode = changeFeedState.getMode();
        if (continuation != null) {
            CompositeContinuationToken continuationToken = continuation.getCurrentContinuationToken();
            if (continuationToken != null) {
                String etag = continuationToken.getToken();
                return new CosmosChangeFeedRequestOptions(feedRange, ChangeFeedStartFromInternal.createFromETagAndFeedRange(etag, feedRange), mode, changeFeedState);
            }
            return new CosmosChangeFeedRequestOptions(feedRange, ChangeFeedStartFromInternal.createFromBeginning(), mode, changeFeedState);
        }
        return new CosmosChangeFeedRequestOptions(feedRange, changeFeedState.getStartFromSettings(), mode, changeFeedState);
    }

    static CosmosChangeFeedRequestOptions createForProcessingFromEtagAndFeedRange(String etag, FeedRange feedRange) {
        if (etag != null) {
            return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromETagAndFeedRange(etag, FeedRangeInternal.convert(feedRange)), ChangeFeedMode.INCREMENTAL, null);
        }
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromBeginning(), ChangeFeedMode.INCREMENTAL, null);
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosChangeFeedRequestOptions createForProcessingFromNow(FeedRange feedRange) {
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromNow(), ChangeFeedMode.INCREMENTAL, null);
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public static CosmosChangeFeedRequestOptions createForProcessingFromPointInTime(Instant pointInTime, FeedRange feedRange) {
        if (pointInTime == null) {
            throw new NullPointerException("pointInTime");
        }
        if (feedRange == null) {
            throw new NullPointerException("feedRange");
        }
        return new CosmosChangeFeedRequestOptions(FeedRangeInternal.convert(feedRange), ChangeFeedStartFromInternal.createFromPointInTime(pointInTime), ChangeFeedMode.INCREMENTAL, null);
    }

    void setRequestContinuation(String etag) {
        this.startFromInternal = ChangeFeedStartFromInternal.createFromETagAndFeedRange(etag, this.feedRangeInternal);
    }

    CosmosChangeFeedRequestOptions withCosmosPagedFluxOptions(CosmosPagedFluxOptions pagedFluxOptions) {
        if (pagedFluxOptions == null) {
            return this;
        }
        CosmosChangeFeedRequestOptions effectiveRequestOptions = this;
        if (pagedFluxOptions.getRequestContinuation() != null) {
            effectiveRequestOptions = CosmosChangeFeedRequestOptions.createForProcessingFromContinuation(pagedFluxOptions.getRequestContinuation());
            effectiveRequestOptions.setMaxPrefetchPageCount(this.getMaxPrefetchPageCount());
            effectiveRequestOptions.setThroughputControlGroupName(this.getThroughputControlGroupName());
        }
        if (pagedFluxOptions.getMaxItemCount() != null) {
            effectiveRequestOptions.setMaxItemCount(pagedFluxOptions.getMaxItemCount());
        }
        return effectiveRequestOptions;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions fullFidelity() {
        if (!this.startFromInternal.supportsFullFidelityRetention()) {
            throw new IllegalStateException("Full fidelity retention is not supported for the chosen change feed start from option. Use CosmosChangeFeedRequestOptions.createForProcessingFromNow or CosmosChangeFeedRequestOptions.createFromContinuation instead.");
        }
        this.mode = ChangeFeedMode.FULL_FIDELITY;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosChangeFeedRequestOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
        return this;
    }
}

