/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BulkProcessingOptions;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBulkOperationResponse;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosItemOperation;
import com.azure.cosmos.CosmosPatchOperations;
import com.azure.cosmos.CosmosScripts;
import com.azure.cosmos.GlobalThroughputControlConfig;
import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.TransactionalBatch;
import com.azure.cosmos.TransactionalBatchRequestOptions;
import com.azure.cosmos.TransactionalBatchResponse;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.Beta;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosContainer {
    final CosmosAsyncContainer asyncContainer;
    private final CosmosDatabase database;
    private final String id;
    private CosmosScripts scripts;

    CosmosContainer(String id, CosmosDatabase database, CosmosAsyncContainer container) {
        this.id = id;
        this.database = database;
        this.asyncContainer = container;
    }

    public String getId() {
        return this.id;
    }

    public CosmosContainerResponse read() {
        return this.database.blockContainerResponse(this.asyncContainer.read());
    }

    public CosmosContainerResponse read(CosmosContainerRequestOptions options) {
        return this.database.blockContainerResponse(this.asyncContainer.read(options));
    }

    public CosmosContainerResponse delete(CosmosContainerRequestOptions options) {
        return this.database.blockContainerResponse(this.asyncContainer.delete(options));
    }

    public CosmosContainerResponse delete() {
        return this.database.blockContainerResponse(this.asyncContainer.delete());
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties) {
        return this.database.blockContainerResponse(this.asyncContainer.replace(containerProperties));
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        return this.database.blockContainerResponse(this.asyncContainer.replace(containerProperties, options));
    }

    public ThroughputResponse replaceThroughput(ThroughputProperties throughputProperties) {
        return this.database.throughputResponseToBlock(this.asyncContainer.replaceThroughput(throughputProperties));
    }

    public ThroughputResponse readThroughput() {
        return this.database.throughputResponseToBlock(this.asyncContainer.readThroughput());
    }

    public <T> CosmosItemResponse<T> createItem(T item) {
        return this.blockItemResponse(this.asyncContainer.createItem(item));
    }

    public <T> CosmosItemResponse<T> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.createItem(item, partitionKey, options));
    }

    public <T> CosmosItemResponse<T> createItem(T item, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.createItem(item, options));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item) {
        return this.blockItemResponse(this.asyncContainer.upsertItem(item));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.upsertItem(item, options));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.upsertItem(item, partitionKey, options));
    }

    <T> CosmosItemResponse<T> blockItemResponse(Mono<CosmosItemResponse<T>> itemMono) {
        try {
            return (CosmosItemResponse)itemMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    <T> FeedResponse<T> blockFeedResponse(Mono<FeedResponse<T>> itemMono) {
        try {
            return (FeedResponse)itemMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    private CosmosItemResponse<Object> blockDeleteItemResponse(Mono<CosmosItemResponse<Object>> deleteItemMono) {
        try {
            return (CosmosItemResponse)deleteItemMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    private TransactionalBatchResponse blockBatchResponse(Mono<TransactionalBatchResponse> batchResponseMono) {
        try {
            return (TransactionalBatchResponse)batchResponseMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    private <TContext> List<CosmosBulkOperationResponse<TContext>> blockBulkResponse(Flux<CosmosBulkOperationResponse<TContext>> bulkResponse) {
        try {
            return (List)bulkResponse.collectList().block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    <T> CosmosPagedIterable<T> readAllItems(CosmosQueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.asyncContainer.readAllItems(options, classType));
    }

    public <T> CosmosPagedIterable<T> queryItems(String query, CosmosQueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.asyncContainer.queryItems(query, options, classType));
    }

    public <T> CosmosPagedIterable<T> queryItems(SqlQuerySpec querySpec, CosmosQueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.asyncContainer.queryItems(querySpec, options, classType));
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> CosmosPagedIterable<T> queryChangeFeed(CosmosChangeFeedRequestOptions options, Class<T> classType) {
        Preconditions.checkNotNull(options, "Argument 'options' must not be null.");
        Preconditions.checkNotNull(classType, "Argument 'classType' must not be null.");
        options.setMaxPrefetchPageCount(1);
        return this.getCosmosPagedIterable(this.asyncContainer.queryChangeFeed(options, classType));
    }

    public <T> FeedResponse<T> readMany(List<CosmosItemIdentity> itemIdentityList, Class<T> classType) {
        return this.readMany(itemIdentityList, null, classType);
    }

    public <T> FeedResponse<T> readMany(List<CosmosItemIdentity> itemIdentityList, String sessionToken, Class<T> classType) {
        return this.blockFeedResponse(this.asyncContainer.readMany(itemIdentityList, sessionToken, classType));
    }

    public <T> CosmosPagedIterable<T> readAllItems(PartitionKey partitionKey, Class<T> classType) {
        return this.readAllItems(partitionKey, new CosmosQueryRequestOptions(), classType);
    }

    public <T> CosmosPagedIterable<T> readAllItems(PartitionKey partitionKey, CosmosQueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.asyncContainer.readAllItems(partitionKey, options, classType));
    }

    public <T> CosmosItemResponse<T> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.blockItemResponse(this.asyncContainer.readItem(itemId, partitionKey, new CosmosItemRequestOptions(), itemType));
    }

    public <T> CosmosItemResponse<T> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        return this.blockItemResponse(this.asyncContainer.readItem(itemId, partitionKey, options, itemType));
    }

    public <T> CosmosItemResponse<T> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.replaceItem(item, itemId, partitionKey, options));
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> CosmosItemResponse<T> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, Class<T> itemType) {
        return this.blockItemResponse(this.asyncContainer.patchItem(itemId, partitionKey, cosmosPatchOperations, itemType));
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <T> CosmosItemResponse<T> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Class<T> itemType) {
        return this.blockItemResponse(this.asyncContainer.patchItem(itemId, partitionKey, cosmosPatchOperations, options, itemType));
    }

    public CosmosItemResponse<Object> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockDeleteItemResponse(this.asyncContainer.deleteItem(itemId, partitionKey, options));
    }

    public <T> CosmosItemResponse<Object> deleteItem(T item, CosmosItemRequestOptions options) {
        return this.blockDeleteItemResponse(this.asyncContainer.deleteItem(item, options));
    }

    @Beta(value=Beta.SinceVersion.V4_7_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public TransactionalBatchResponse executeTransactionalBatch(TransactionalBatch transactionalBatch) {
        return this.blockBatchResponse(this.asyncContainer.executeTransactionalBatch(transactionalBatch));
    }

    @Beta(value=Beta.SinceVersion.V4_7_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public TransactionalBatchResponse executeTransactionalBatch(TransactionalBatch transactionalBatch, TransactionalBatchRequestOptions requestOptions) {
        return this.blockBatchResponse(this.asyncContainer.executeTransactionalBatch(transactionalBatch, requestOptions));
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> List<CosmosBulkOperationResponse<TContext>> processBulkOperations(Iterable<CosmosItemOperation> operations) {
        return this.blockBulkResponse(this.asyncContainer.processBulkOperations((Flux<CosmosItemOperation>)Flux.fromIterable(operations)));
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public <TContext> List<CosmosBulkOperationResponse<TContext>> processBulkOperations(Iterable<CosmosItemOperation> operations, BulkProcessingOptions<TContext> bulkOptions) {
        return this.blockBulkResponse(this.asyncContainer.processBulkOperations((Flux<CosmosItemOperation>)Flux.fromIterable(operations), bulkOptions));
    }

    public CosmosScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosScripts(this, this.asyncContainer.getScripts());
        }
        return this.scripts;
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return UtilBridgeInternal.createCosmosPagedIterable(cosmosPagedFlux);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public List<FeedRange> getFeedRanges() {
        try {
            return (List)this.asyncContainer.getFeedRanges().block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public void enableLocalThroughputControlGroup(ThroughputControlGroupConfig groupConfig) {
        this.asyncContainer.enableLocalThroughputControlGroup(groupConfig);
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public void enableGlobalThroughputControlGroup(ThroughputControlGroupConfig groupConfig, GlobalThroughputControlConfig globalControlConfig) {
        this.asyncContainer.enableGlobalThroughputControlGroup(groupConfig, globalControlConfig);
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public void openConnectionsAndInitCaches() {
        this.blockVoidResponse(this.asyncContainer.openConnectionsAndInitCaches());
    }

    private void blockVoidResponse(Mono<Void> voidMono) {
        try {
            voidMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }
}

