/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.models.SqlQuerySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQuerySpecLogger {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final SqlQuerySpecLogger INSTANCE = new SqlQuerySpecLogger(LoggerFactory.getLogger(SqlQuerySpecLogger.class));
    private final Logger logger;

    public static SqlQuerySpecLogger getInstance() {
        return INSTANCE;
    }

    SqlQuerySpecLogger(Logger logger) {
        this.logger = logger;
    }

    public void logQuery(SqlQuerySpec querySpec) {
        if (this.logger.isTraceEnabled() && !querySpec.getParameters().isEmpty()) {
            StringBuilder queryLogBuilder = new StringBuilder(1000);
            queryLogBuilder.append(querySpec.getQueryText());
            querySpec.getParameters().forEach(p -> queryLogBuilder.append(LINE_SEPARATOR).append(" > param: ").append(p.getName()).append(" = ").append(p.getValue(Object.class)));
            this.logger.debug(queryLogBuilder.toString());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(querySpec.getQueryText());
        }
    }
}

