/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromTypes;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;

class ChangeFeedStartFromETagAndFeedRangeImpl
extends ChangeFeedStartFromInternal {
    private final String eTag;
    private final FeedRangeInternal feedRange;

    public ChangeFeedStartFromETagAndFeedRangeImpl(String eTag, FeedRangeInternal feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null");
        this.eTag = eTag;
        this.feedRange = feedRange;
    }

    public String getETag() {
        return this.eTag;
    }

    public FeedRangeInternal getFeedRange() {
        return this.feedRange;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ChangeFeedStartFromETagAndFeedRangeImpl)) {
            return false;
        }
        ChangeFeedStartFromETagAndFeedRangeImpl otherStartFrom = (ChangeFeedStartFromETagAndFeedRangeImpl)obj;
        if (this.eTag == null) {
            return otherStartFrom.eTag == null && this.feedRange.equals(otherStartFrom.feedRange);
        }
        return this.eTag.compareTo(otherStartFrom.eTag) == 0 && this.feedRange.equals(otherStartFrom.feedRange);
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 397 ^ this.feedRange.hashCode();
        if (this.eTag != null) {
            hash = hash * 397 ^ this.eTag.hashCode();
        }
        return hash;
    }

    @Override
    public void populateRequest(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "Argument 'request' must not be null.");
        if (this.eTag != null) {
            request.getHeaders().put("If-None-Match", this.eTag);
        }
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        BridgeInternal.setProperty(this, "Type", ChangeFeedStartFromTypes.LEASE);
        BridgeInternal.setProperty(this, "Etag", this.eTag);
        this.feedRange.setProperties(this, true);
    }

    @Override
    public boolean supportsFullFidelityRetention() {
        return true;
    }
}

