/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clientTelemetry;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosSchedulers;
import com.azure.cosmos.implementation.clientTelemetry.AzureVMMetadata;
import com.azure.cosmos.implementation.clientTelemetry.ClientTelemetryInfo;
import com.azure.cosmos.implementation.clientTelemetry.ReportPayload;
import com.azure.cosmos.implementation.cpu.CpuMemoryMonitor;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.HdrHistogram.ConcurrentDoubleHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ClientTelemetry {
    public static final int ONE_KB_TO_BYTES = 1024;
    public static final int REQUEST_LATENCY_MAX_MICRO_SEC = 300000000;
    public static final int REQUEST_LATENCY_SUCCESS_PRECISION = 4;
    public static final int REQUEST_LATENCY_FAILURE_PRECISION = 2;
    public static final String REQUEST_LATENCY_NAME = "RequestLatency";
    public static final String REQUEST_LATENCY_UNIT = "MicroSec";
    public static final int REQUEST_CHARGE_MAX = 10000;
    public static final int REQUEST_CHARGE_PRECISION = 2;
    public static final String REQUEST_CHARGE_NAME = "RequestCharge";
    public static final String REQUEST_CHARGE_UNIT = "RU";
    public static final int CPU_MAX = 100;
    public static final int CPU_PRECISION = 2;
    private static final String CPU_NAME = "CPU";
    private static final String CPU_UNIT = "Percentage";
    public static final int MEMORY_MAX_IN_MB = 102400;
    public static final int MEMORY_PRECISION = 2;
    private static final String MEMORY_NAME = "MemoryRemaining";
    private static final String MEMORY_UNIT = "MB";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ClientTelemetryInfo clientTelemetryInfo;
    private HttpClient httpClient;
    private final ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());
    private final Scheduler scheduler = Schedulers.fromExecutor((Executor)this.scheduledExecutorService);
    private static final Logger logger = LoggerFactory.getLogger(ClientTelemetry.class);
    private volatile boolean isClosed;
    private volatile boolean isClientTelemetryEnabled;
    private static String AZURE_VM_METADATA = "http://169.254.169.254:80/metadata/instance?api-version=2020-06-01";
    private static final double PERCENTILE_50 = 50.0;
    private static final double PERCENTILE_90 = 90.0;
    private static final double PERCENTILE_95 = 95.0;
    private static final double PERCENTILE_99 = 99.0;
    private static final double PERCENTILE_999 = 99.9;
    private final int clientTelemetrySchedulingSec;

    public ClientTelemetry(Boolean acceleratedNetworking, String clientId, String processId, String userAgent, ConnectionMode connectionMode, String globalDatabaseAccountName, String applicationRegion, String hostEnvInfo, HttpClient httpClient, boolean isClientTelemetryEnabled) {
        this.clientTelemetryInfo = new ClientTelemetryInfo(clientId, processId, userAgent, connectionMode, globalDatabaseAccountName, applicationRegion, hostEnvInfo, acceleratedNetworking);
        this.isClosed = false;
        this.httpClient = httpClient;
        this.isClientTelemetryEnabled = isClientTelemetryEnabled;
        this.clientTelemetrySchedulingSec = Configs.getClientTelemetrySchedulingInSec();
    }

    public ClientTelemetryInfo getClientTelemetryInfo() {
        return this.clientTelemetryInfo;
    }

    public static void recordValue(ConcurrentDoubleHistogram doubleHistogram, long value) {
        try {
            doubleHistogram.recordValue((double)value);
        }
        catch (Exception ex) {
            logger.warn("Error while recording value for client telemetry. ", (Throwable)ex);
        }
    }

    public static void recordValue(ConcurrentDoubleHistogram doubleHistogram, double value) {
        try {
            doubleHistogram.recordValue(value);
        }
        catch (Exception ex) {
            logger.warn("Error while recording value for client telemetry. ", (Throwable)ex);
        }
    }

    public void init() {
        this.loadAzureVmMetaData();
        this.sendClientTelemetry().subscribe();
    }

    public void close() {
        this.isClosed = true;
        this.scheduledExecutorService.shutdown();
        logger.debug("GlobalEndpointManager closed.");
    }

    private Mono<Void> sendClientTelemetry() {
        return Mono.delay((Duration)Duration.ofSeconds(this.clientTelemetrySchedulingSec), (Scheduler)CosmosSchedulers.COSMOS_PARALLEL).flatMap(t -> {
            if (this.isClosed) {
                logger.warn("client already closed");
                return Mono.empty();
            }
            if (!Configs.isClientTelemetryEnabled(this.isClientTelemetryEnabled)) {
                logger.trace("client telemetry not enabled");
                return Mono.empty();
            }
            this.readHistogram();
            try {
                logger.info("ClientTelemetry {}", (Object)OBJECT_MAPPER.writeValueAsString((Object)this.clientTelemetryInfo));
            }
            catch (JsonProcessingException e) {
                logger.error("Error which parsing client telemetry into json. ", (Throwable)e);
            }
            this.clearDataForNextRun();
            return this.sendClientTelemetry();
        }).onErrorResume(ex -> {
            logger.error("sendClientTelemetry() - Unable to send client telemetry. Exception: ", ex);
            this.clearDataForNextRun();
            return this.sendClientTelemetry();
        }).subscribeOn(this.scheduler);
    }

    private void loadAzureVmMetaData() {
        URI targetEndpoint = null;
        try {
            targetEndpoint = new URI(AZURE_VM_METADATA);
        }
        catch (URISyntaxException ex) {
            logger.info("Unable to parse azure vm metadata url");
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Metadata", "true");
        HttpHeaders httpHeaders = new HttpHeaders(headers);
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, targetEndpoint, targetEndpoint.getPort(), httpHeaders);
        Mono<HttpResponse> httpResponseMono = this.httpClient.send(httpRequest);
        httpResponseMono.flatMap(response -> response.bodyAsString()).map(metadataJson -> ClientTelemetry.parse(metadataJson, AzureVMMetadata.class)).doOnSuccess(azureVMMetadata -> {
            this.clientTelemetryInfo.setApplicationRegion(azureVMMetadata.getLocation());
            this.clientTelemetryInfo.setHostEnvInfo(azureVMMetadata.getOsType() + "|" + azureVMMetadata.getSku() + "|" + azureVMMetadata.getVmSize() + "|" + azureVMMetadata.getAzEnvironment());
        }).onErrorResume(throwable -> {
            logger.info("Unable to get azure vm metadata");
            logger.debug("Unable to get azure vm metadata", throwable);
            return Mono.empty();
        }).subscribe();
    }

    private static <T> T parse(String itemResponseBodyAsString, Class<T> itemClassType) {
        try {
            return (T)OBJECT_MAPPER.readValue(itemResponseBodyAsString, itemClassType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse string [" + itemResponseBodyAsString + "] to POJO.", e);
        }
    }

    private void clearDataForNextRun() {
        this.clientTelemetryInfo.getOperationInfoMap().clear();
        this.clientTelemetryInfo.getCacheRefreshInfoMap().clear();
        for (ConcurrentDoubleHistogram histogram : this.clientTelemetryInfo.getSystemInfoMap().values()) {
            histogram.reset();
        }
    }

    private void readHistogram() {
        ConcurrentDoubleHistogram cpuHistogram = new ConcurrentDoubleHistogram(100L, 2);
        cpuHistogram.setAutoResize(true);
        for (double val : CpuMemoryMonitor.getClientTelemetryCpuLatestList()) {
            ClientTelemetry.recordValue(cpuHistogram, val);
        }
        ReportPayload cpuReportPayload = new ReportPayload(CPU_NAME, CPU_UNIT);
        this.clientTelemetryInfo.getSystemInfoMap().put(cpuReportPayload, cpuHistogram);
        ConcurrentDoubleHistogram memoryHistogram = new ConcurrentDoubleHistogram(102400L, 2);
        memoryHistogram.setAutoResize(true);
        for (double val : CpuMemoryMonitor.getClientTelemetryMemoryLatestList()) {
            ClientTelemetry.recordValue(memoryHistogram, val);
        }
        ReportPayload memoryReportPayload = new ReportPayload(MEMORY_NAME, MEMORY_UNIT);
        this.clientTelemetryInfo.getSystemInfoMap().put(memoryReportPayload, memoryHistogram);
        this.clientTelemetryInfo.setTimeStamp(Instant.now().toString());
        for (Map.Entry<ReportPayload, ConcurrentDoubleHistogram> entry : this.clientTelemetryInfo.getSystemInfoMap().entrySet()) {
            this.fillMetricsInfo(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ReportPayload, ConcurrentDoubleHistogram> entry : this.clientTelemetryInfo.getCacheRefreshInfoMap().entrySet()) {
            this.fillMetricsInfo(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ReportPayload, ConcurrentDoubleHistogram> entry : this.clientTelemetryInfo.getOperationInfoMap().entrySet()) {
            this.fillMetricsInfo(entry.getKey(), entry.getValue());
        }
    }

    private void fillMetricsInfo(ReportPayload payload, ConcurrentDoubleHistogram histogram) {
        DoubleHistogram copyHistogram = histogram.copy();
        payload.getMetricInfo().setCount(copyHistogram.getTotalCount());
        payload.getMetricInfo().setMax(copyHistogram.getMaxValue());
        payload.getMetricInfo().setMin(copyHistogram.getMinValue());
        payload.getMetricInfo().setMean(copyHistogram.getMean());
        HashMap<Double, Double> percentile = new HashMap<Double, Double>();
        percentile.put(50.0, copyHistogram.getValueAtPercentile(50.0));
        percentile.put(90.0, copyHistogram.getValueAtPercentile(90.0));
        percentile.put(95.0, copyHistogram.getValueAtPercentile(95.0));
        percentile.put(99.0, copyHistogram.getValueAtPercentile(99.0));
        percentile.put(99.9, copyHistogram.getValueAtPercentile(99.9));
        payload.getMetricInfo().setPercentiles(percentile);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

