/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.ClientEncryptionIncludedPath;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;

@Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class ClientEncryptionPolicy {
    private JsonSerializable jsonSerializable;
    @JsonProperty(value="includedPaths")
    private List<ClientEncryptionIncludedPath> includedPaths;
    @JsonProperty(value="policyFormatVersion")
    private int policyFormatVersion;

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ClientEncryptionPolicy(List<ClientEncryptionIncludedPath> paths) {
        this.validateIncludedPaths(paths);
        this.includedPaths = paths;
        this.policyFormatVersion = 1;
    }

    public ClientEncryptionPolicy() {
        this.jsonSerializable = new JsonSerializable();
    }

    ClientEncryptionPolicy(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    ClientEncryptionPolicy(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    @Beta(value=Beta.SinceVersion.V4_11_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public List<ClientEncryptionIncludedPath> getIncludedPaths() {
        return this.includedPaths;
    }

    private void validateIncludedPaths(List<ClientEncryptionIncludedPath> clientEncryptionIncludedPath) {
        ArrayList<String> includedPathsList = new ArrayList<String>();
        for (ClientEncryptionIncludedPath path : clientEncryptionIncludedPath) {
            this.validateClientEncryptionIncludedPath(path);
            if (includedPathsList.contains(path.getPath())) {
                throw new IllegalArgumentException("Duplicate Path found in clientEncryptionIncludedPath.");
            }
            includedPathsList.add(path.getPath());
        }
    }

    private void validateClientEncryptionIncludedPath(ClientEncryptionIncludedPath clientEncryptionIncludedPath) {
        if (clientEncryptionIncludedPath == null) {
            throw new IllegalArgumentException("clientEncryptionIncludedPath is null");
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getPath())) {
            throw new IllegalArgumentException("path in clientEncryptionIncludedPath is empty");
        }
        if (clientEncryptionIncludedPath.getPath().charAt(0) != '/' || clientEncryptionIncludedPath.getPath().lastIndexOf(47) != 0 || clientEncryptionIncludedPath.getPath().substring(1).equals("id")) {
            throw new IllegalArgumentException("Invalid path " + clientEncryptionIncludedPath.getPath());
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getClientEncryptionKeyId())) {
            throw new IllegalArgumentException("clientEncryptionKeyId in clientEncryptionIncludedPath is empty");
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getEncryptionType())) {
            throw new IllegalArgumentException("encryptionType in clientEncryptionIncludedPath is empty");
        }
        if (!clientEncryptionIncludedPath.getEncryptionType().equals("Deterministic") && !clientEncryptionIncludedPath.getEncryptionType().equals("Randomized")) {
            throw new IllegalArgumentException("EncryptionType should be either 'Deterministic' or 'Randomized'.");
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getEncryptionAlgorithm())) {
            throw new IllegalArgumentException("encryptionAlgorithm in clientEncryptionIncludedPath is empty");
        }
        if (!clientEncryptionIncludedPath.getEncryptionAlgorithm().equals("AEAD_AES_256_CBC_HMAC_SHA256")) {
            throw new IllegalArgumentException("EncryptionAlgorithm should be 'AEAD_AES_256_CBC_HMAC_SHA256'.");
        }
    }
}

