/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import java.time.Duration;

public final class DirectConnectionConfig {
    private static final Boolean DEFAULT_CONNECTION_ENDPOINT_REDISCOVERY_ENABLED = false;
    private static final Duration DEFAULT_IDLE_ENDPOINT_TIMEOUT = Duration.ofHours(1L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ENDPOINT = 130;
    private static final int DEFAULT_MAX_REQUESTS_PER_CONNECTION = 30;
    private boolean connectionEndpointRediscoveryEnabled = DEFAULT_CONNECTION_ENDPOINT_REDISCOVERY_ENABLED;
    private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private Duration idleConnectionTimeout = Duration.ZERO;
    private Duration idleEndpointTimeout = DEFAULT_IDLE_ENDPOINT_TIMEOUT;
    private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private int maxConnectionsPerEndpoint = 130;
    private int maxRequestsPerConnection = 30;

    public boolean isConnectionEndpointRediscoveryEnabled() {
        return this.connectionEndpointRediscoveryEnabled;
    }

    public DirectConnectionConfig setConnectionEndpointRediscoveryEnabled(boolean connectionEndpointRediscoveryEnabled) {
        this.connectionEndpointRediscoveryEnabled = connectionEndpointRediscoveryEnabled;
        return this;
    }

    public static DirectConnectionConfig getDefaultConfig() {
        return new DirectConnectionConfig();
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public DirectConnectionConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public DirectConnectionConfig setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public Duration getIdleEndpointTimeout() {
        return this.idleEndpointTimeout;
    }

    public DirectConnectionConfig setIdleEndpointTimeout(Duration idleEndpointTimeout) {
        this.idleEndpointTimeout = idleEndpointTimeout;
        return this;
    }

    public int getMaxConnectionsPerEndpoint() {
        return this.maxConnectionsPerEndpoint;
    }

    public DirectConnectionConfig setMaxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
        this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        return this;
    }

    public int getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public DirectConnectionConfig setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        return this;
    }

    Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    DirectConnectionConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public String toString() {
        return "DirectConnectionConfig{connectTimeout=" + this.connectTimeout + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", idleEndpointTimeout=" + this.idleEndpointTimeout + ", maxConnectionsPerEndpoint=" + this.maxConnectionsPerEndpoint + ", maxRequestsPerConnection=" + this.maxRequestsPerConnection + '}';
    }
}

