/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.models.SqlQuerySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQuerySpecLogger {
    private static final SqlQuerySpecLogger INSTANCE = new SqlQuerySpecLogger(LoggerFactory.getLogger(SqlQuerySpecLogger.class));
    private final Logger logger;

    public static SqlQuerySpecLogger getInstance() {
        return INSTANCE;
    }

    SqlQuerySpecLogger(Logger logger) {
        this.logger = logger;
    }

    public void logQuery(SqlQuerySpec querySpec) {
        if (this.logger.isTraceEnabled() && !querySpec.getParameters().isEmpty()) {
            this.logger.debug(querySpec.toPrettyString());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(querySpec.getQueryText());
        }
    }
}

