/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.RequestTimeline;
import java.time.Instant;

public final class ReactorNettyRequestRecord {
    private volatile Instant timeCreated;
    private volatile Instant timeConnected;
    private volatile Instant timeConfigured;
    private volatile Instant timeSent;
    private volatile Instant timeReceived;
    private volatile Instant timeCompleted;

    public Instant timeCreated() {
        return this.timeCreated;
    }

    public Instant timeConnected() {
        return this.timeConnected;
    }

    public Instant timeConfigured() {
        return this.timeConfigured;
    }

    public Instant timeSent() {
        return this.timeSent;
    }

    public Instant timeReceived() {
        return this.timeReceived;
    }

    public Instant timeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCreated(Instant timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeConnected(Instant timeConnected) {
        this.timeConnected = timeConnected;
    }

    public void setTimeConfigured(Instant timeConfigured) {
        this.timeConfigured = timeConfigured;
    }

    public void setTimeSent(Instant timeSent) {
        this.timeSent = timeSent;
    }

    public void setTimeReceived(Instant timeReceived) {
        this.timeReceived = timeReceived;
    }

    public void setTimeCompleted(Instant timeCompleted) {
        this.timeCompleted = timeCompleted;
    }

    public RequestTimeline takeTimelineSnapshot() {
        Instant now = Instant.now();
        Instant timeCreated = this.timeCreated();
        Instant timeConnected = this.timeConnected();
        Instant timeConfigured = this.timeConfigured();
        Instant timeSent = this.timeSent();
        Instant timeReceived = this.timeReceived();
        Instant timeCompleted = this.timeCompleted();
        Instant timeCompletedOrNow = timeCompleted == null ? now : timeCompleted;
        return RequestTimeline.of(new RequestTimeline.Event("connectionCreated", timeCreated, this.timeConnected() == null ? timeCompletedOrNow : timeConnected), new RequestTimeline.Event("connectionConfigured", timeConnected, timeConfigured == null ? timeCompletedOrNow : timeConfigured), new RequestTimeline.Event("requestSent", timeConfigured, timeSent == null ? timeCompletedOrNow : timeSent), new RequestTimeline.Event("transitTime", timeSent, timeReceived == null ? timeCompletedOrNow : timeReceived), new RequestTimeline.Event("received", timeReceived, timeCompletedOrNow));
    }
}

