/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.models.SqlParameter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SqlQuerySpec {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private List<SqlParameter> parameters;
    private JsonSerializable jsonSerializable;

    public SqlQuerySpec() {
        this.jsonSerializable = new JsonSerializable();
    }

    SqlQuerySpec(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public SqlQuerySpec(String queryText) {
        this.jsonSerializable = new JsonSerializable();
        this.setQueryText(queryText);
    }

    public SqlQuerySpec(String queryText, List<SqlParameter> parameters) {
        this.jsonSerializable = new JsonSerializable();
        this.setQueryText(queryText);
        this.parameters = parameters;
    }

    public SqlQuerySpec(String queryText, SqlParameter ... parameters) {
        this.jsonSerializable = new JsonSerializable();
        this.setQueryText(queryText);
        this.parameters = Collections.synchronizedList(Arrays.asList(parameters));
    }

    public String getQueryText() {
        return this.jsonSerializable.getString("query");
    }

    public SqlQuerySpec setQueryText(String queryText) {
        this.jsonSerializable.set("query", queryText);
        return this;
    }

    public List<SqlParameter> getParameters() {
        if (this.parameters == null) {
            Collection<SqlParameter> sqlParameters = this.jsonSerializable.getCollection("parameters", SqlParameter.class, new boolean[0]);
            if (sqlParameters == null) {
                sqlParameters = new ArrayList<SqlParameter>();
            }
            this.parameters = Collections.synchronizedList(new ArrayList<SqlParameter>(sqlParameters));
        }
        return this.parameters;
    }

    public SqlQuerySpec setParameters(List<SqlParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(this.getQueryText());
        this.getParameters().forEach(p -> sb.append(LINE_SEPARATOR).append(" > param: ").append(p.getName()).append(" = ").append(p.getValue(Object.class)));
        return sb.toString();
    }

    void populatePropertyBag() {
        boolean defaultParameters;
        this.jsonSerializable.populatePropertyBag();
        boolean bl = defaultParameters = this.parameters != null && this.parameters.size() != 0;
        if (defaultParameters) {
            this.jsonSerializable.set("parameters", this.parameters);
        } else {
            this.jsonSerializable.remove("parameters");
        }
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

