/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.TransactionalBatchOperationResult;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ResourceThrottleRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.BulkExecutorUtil;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import reactor.core.publisher.Mono;

final class BulkOperationRetryPolicy
implements IRetryPolicy {
    private static final int MAX_RETRIES = 1;
    private final RxCollectionCache collectionCache;
    private final String collectionLink;
    private final ResourceThrottleRetryPolicy resourceThrottleRetryPolicy;
    private int attemptedRetries;

    BulkOperationRetryPolicy(RxCollectionCache collectionCache, String resourceFullName, ResourceThrottleRetryPolicy resourceThrottleRetryPolicy) {
        this.collectionCache = collectionCache;
        this.collectionLink = Utils.getCollectionName(resourceFullName);
        this.resourceThrottleRetryPolicy = resourceThrottleRetryPolicy;
    }

    final Mono<ShouldRetryResult> shouldRetry(TransactionalBatchOperationResult result) {
        Preconditions.checkNotNull(result, "expected non-null result");
        CosmosException exception = BridgeInternal.createCosmosException(null, result.getStatusCode(), null, BulkExecutorUtil.getResponseHeadersFromBatchOperationResult(result));
        if (this.resourceThrottleRetryPolicy == null) {
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        return this.resourceThrottleRetryPolicy.shouldRetry((Exception)((Object)exception));
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
        if (this.resourceThrottleRetryPolicy == null) {
            return Mono.just((Object)ShouldRetryResult.noRetry());
        }
        return this.resourceThrottleRetryPolicy.shouldRetry(exception);
    }

    @Override
    public RetryContext getRetryContext() {
        return this.resourceThrottleRetryPolicy.getRetryContext();
    }

    boolean shouldRetryForGone(int statusCode, int subStatusCode) {
        if (statusCode == 410 && (subStatusCode == 1002 || subStatusCode == 1000 || subStatusCode == 1007 || subStatusCode == 1008) && this.attemptedRetries < 1) {
            ++this.attemptedRetries;
            if (subStatusCode == 1000) {
                this.refreshCollectionCache();
            }
            return true;
        }
        return false;
    }

    private void refreshCollectionCache() {
        this.collectionCache.refresh(null, this.collectionLink, null);
    }
}

