/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.patch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosPatchOperations;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.patch.PatchOperationCore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;

public final class PatchUtil {
    public static JsonSerializable serializableBatchPatchOperation(CosmosPatchOperations patchOperations, RequestOptions requestOptions) {
        return PatchUtil.cosmosPatchToJsonSerializable(patchOperations, requestOptions);
    }

    public static byte[] serializeCosmosPatchToByteArray(CosmosPatchOperations patchOperations, RequestOptions requestOptions) {
        byte[] serializedBody;
        JsonSerializable jsonSerializable = PatchUtil.cosmosPatchToJsonSerializable(patchOperations, requestOptions);
        try {
            serializedBody = Utils.getSimpleObjectMapper().writeValueAsBytes((Object)jsonSerializable.getPropertyBag());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't serialize the object into the byte array", e);
        }
        return serializedBody;
    }

    private static JsonSerializable cosmosPatchToJsonSerializable(CosmosPatchOperations patchOperations, RequestOptions requestOptions) {
        String filterPredicate;
        JsonSerializable jsonSerializable = new JsonSerializable();
        ArrayNode operations = Utils.getSimpleObjectMapper().createArrayNode();
        List<PatchOperation> patchOperationList = BridgeInternal.getPatchOperationsFromCosmosPatch(patchOperations);
        for (PatchOperation patchOperation : patchOperationList) {
            JsonSerializable operationJsonSerializable = new JsonSerializable();
            operationJsonSerializable.set("op", patchOperation.getOperationType().getOperationValue());
            if (!(patchOperation instanceof PatchOperationCore)) {
                throw new IllegalArgumentException("Invalid patch operation type");
            }
            operationJsonSerializable.set("path", ((PatchOperationCore)patchOperation).getPath());
            operationJsonSerializable.set("value", ((PatchOperationCore)patchOperation).getResource());
            operations.add((JsonNode)operationJsonSerializable.getPropertyBag());
        }
        jsonSerializable.set("operations", operations);
        if (requestOptions != null && (filterPredicate = requestOptions.getFilterPredicate()) != null && !filterPredicate.isEmpty()) {
            jsonSerializable.set("condition", filterPredicate);
        }
        return jsonSerializable;
    }
}

