/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.config;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;

public abstract class ThroughputControlGroupInternal {
    private final String groupName;
    private final String id;
    private final boolean isDefault;
    private final CosmosAsyncContainer targetContainer;
    private final Integer targetThroughput;
    private final Double targetThroughputThreshold;

    public ThroughputControlGroupInternal(String groupName, CosmosAsyncContainer targetContainer, Integer targetThroughput, Double targetThroughputThreshold, boolean isDefault) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(groupName), "Group name can not be null or empty");
        Preconditions.checkNotNull(targetContainer, "Target container can not be null");
        Preconditions.checkArgument(targetThroughput == null || targetThroughput > 0, "Target throughput should be greater than 0");
        Preconditions.checkArgument(targetThroughputThreshold == null || targetThroughputThreshold > 0.0 && targetThroughputThreshold <= 1.0, "Target throughput threshold should between (0, 1]");
        this.groupName = groupName;
        this.targetContainer = targetContainer;
        this.targetThroughput = targetThroughput;
        this.targetThroughputThreshold = targetThroughputThreshold;
        this.isDefault = isDefault;
        this.id = String.format("%s/%s/%s", this.targetContainer.getDatabase().getId(), this.targetContainer.getId(), this.groupName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CosmosAsyncContainer getTargetContainer() {
        return this.targetContainer;
    }

    public Integer getTargetThroughput() {
        return this.targetThroughput;
    }

    public Double getTargetThroughputThreshold() {
        return this.targetThroughputThreshold;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ThroughputControlGroupInternal that = (ThroughputControlGroupInternal)other;
        return StringUtils.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

