/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.implementation.CosmosClientMetadataCachesSnapshot;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationBridgeHelpers {
    private static Logger logger = LoggerFactory.getLogger(ImplementationBridgeHelpers.class);

    private static <T> void ensureClassLoaded(Class<T> classType) {
        try {
            Class.forName(classType.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("cannot load class {}", (Object)classType.getName());
            throw new RuntimeException(e);
        }
    }

    public static final class CosmosClientHelper {
        private static CosmosClientAccessor accessor;

        private CosmosClientHelper() {
        }

        public static void setCosmosClientAccessor(CosmosClientAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosClientAccessor accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosClientAccessor geCosmosClientAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosClientAccessor accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosClient.class);
        }

        public static interface CosmosClientAccessor {
            public CosmosAsyncClient getCosmosAsyncClient(CosmosClient var1);
        }
    }

    public static final class CosmosItemResponseHelper {
        private static CosmosItemResponseBuilderAccessor accessor;

        private CosmosItemResponseHelper() {
        }

        public static void setCosmosItemResponseBuilderAccessor(CosmosItemResponseBuilderAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosItemResponseBuilder accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosItemResponseBuilderAccessor getCosmosItemResponseBuilderAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosItemResponseBuilder accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosItemResponse.class);
        }

        public static interface CosmosItemResponseBuilderAccessor {
            public <T> CosmosItemResponse<T> createCosmosItemResponse(ResourceResponse<Document> var1, byte[] var2, Class<T> var3, ItemDeserializer var4);

            public byte[] getByteArrayContent(CosmosItemResponse<byte[]> var1);

            public void setByteArrayContent(CosmosItemResponse<byte[]> var1, byte[] var2);

            public ResourceResponse<Document> getResourceResponse(CosmosItemResponse<byte[]> var1);
        }
    }

    public static final class CosmosQueryRequestOptionsHelper {
        private static CosmosQueryRequestOptionsAccessor accessor;

        private CosmosQueryRequestOptionsHelper() {
        }

        public static void setCosmosQueryRequestOptionsAccessor(CosmosQueryRequestOptionsAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosQueryRequestOptionsHelper accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosQueryRequestOptionsAccessor getCosmosQueryRequestOptionsAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosQueryRequestOptionsHelper accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosQueryRequestOptionsHelper.class);
        }

        public static interface CosmosQueryRequestOptionsAccessor {
            public void setOperationContext(CosmosQueryRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosQueryRequestOptions var1);
        }
    }

    public static final class PartitionKeyHelper {
        private static PartitionKeyAccessor accessor;

        private PartitionKeyHelper() {
        }

        public static void setPartitionKeyAccessor(PartitionKeyAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("PartitionKeyHelper accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static PartitionKeyAccessor getPartitionKeyAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("PartitionKeyHelper accessor is not initialized!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(PartitionKey.class);
        }

        public static interface PartitionKeyAccessor {
            public PartitionKey toPartitionKey(PartitionKeyInternal var1);
        }
    }

    public static final class CosmosClientBuilderHelper {
        private static CosmosClientBuilderAccessor accessor;

        private CosmosClientBuilderHelper() {
        }

        public static void setCosmosClientBuilderAccessor(CosmosClientBuilderAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosClientBuilderHelper accessor already initialized!");
            }
            accessor = newAccessor;
        }

        static CosmosClientBuilderAccessor getCosmosClientBuilderAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosClientBuilderHelper accessor is not initialized yet!");
            }
            return accessor;
        }

        static {
            ImplementationBridgeHelpers.ensureClassLoaded(CosmosClientBuilder.class);
        }

        public static interface CosmosClientBuilderAccessor {
            public void setCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1, CosmosClientMetadataCachesSnapshot var2);

            public CosmosClientMetadataCachesSnapshot getCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1);
        }
    }
}

