/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.PathInfo;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.apachecommons.text.StringEscapeUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathsHelper {
    private static final Logger logger = LoggerFactory.getLogger(PathsHelper.class);

    public static String generatePath(ResourceType resourceType, RxDocumentServiceRequest request, boolean isFeed) {
        if (request.getIsNameBased()) {
            return PathsHelper.generatePathForNameBased(resourceType, request.getResourceAddress(), isFeed);
        }
        return PathsHelper.generatePath(resourceType, request.getResourceId(), isFeed);
    }

    public static String generatePathForNameBased(Resource resourceType, String resourceOwnerFullName, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        if (resourceType instanceof Database) {
            return "dbs/" + resourceName;
        }
        if (resourceOwnerFullName == null) {
            return null;
        }
        if (resourceType instanceof DocumentCollection) {
            return resourceOwnerFullName + "/" + "colls" + "/" + resourceName;
        }
        if (resourceType instanceof StoredProcedure) {
            return resourceOwnerFullName + "/" + "sprocs" + "/" + resourceName;
        }
        if (resourceType instanceof UserDefinedFunction) {
            return resourceOwnerFullName + "/" + "udfs" + "/" + resourceName;
        }
        if (resourceType instanceof Trigger) {
            return resourceOwnerFullName + "/" + "triggers" + "/" + resourceName;
        }
        if (resourceType instanceof Conflict) {
            return resourceOwnerFullName + "/" + "conflicts" + "/" + resourceName;
        }
        if (resourceType instanceof User) {
            return resourceOwnerFullName + "/" + "users" + "/" + resourceName;
        }
        if (resourceType instanceof Permission) {
            return resourceOwnerFullName + "/" + "permissions" + "/" + resourceName;
        }
        if (resourceType instanceof Document) {
            return resourceOwnerFullName + "/" + "docs" + "/" + resourceName;
        }
        if (resourceType instanceof Offer) {
            return "offers/" + resourceName;
        }
        if (resourceType instanceof Resource) {
            return null;
        }
        String errorMessage = String.format("Resource type %s is unknown", resourceType.toString());
        assert (false) : errorMessage;
        throw new IllegalArgumentException(errorMessage);
    }

    private static String generatePathForNameBased(ResourceType resourceType, String resourceFullName, boolean isFeed) {
        if (isFeed && Strings.isNullOrEmpty(resourceFullName) && resourceType != ResourceType.Database) {
            String errorMessage = String.format("ResourceType %s is unexpected.", new Object[]{resourceType});
            throw new IllegalArgumentException(errorMessage);
        }
        String resourcePath = null;
        if (!isFeed) {
            resourcePath = resourceFullName;
        } else {
            if (resourceType == ResourceType.Database) {
                return "dbs";
            }
            if (resourceType == ResourceType.DocumentCollection) {
                resourcePath = resourceFullName + "/" + "colls";
            } else if (resourceType == ResourceType.StoredProcedure) {
                resourcePath = resourceFullName + "/" + "sprocs";
            } else if (resourceType == ResourceType.UserDefinedFunction) {
                resourcePath = resourceFullName + "/" + "udfs";
            } else if (resourceType == ResourceType.Trigger) {
                resourcePath = resourceFullName + "/" + "triggers";
            } else if (resourceType == ResourceType.Conflict) {
                resourcePath = resourceFullName + "/" + "conflicts";
            } else if (resourceType == ResourceType.Attachment) {
                resourcePath = resourceFullName + "/" + "attachments";
            } else if (resourceType == ResourceType.User) {
                resourcePath = resourceFullName + "/" + "users";
            } else if (resourceType == ResourceType.Permission) {
                resourcePath = resourceFullName + "/" + "permissions";
            } else if (resourceType == ResourceType.Document) {
                resourcePath = resourceFullName + "/" + "docs";
            } else {
                if (resourceType == ResourceType.Offer) {
                    return resourceFullName + "/" + "offers";
                }
                if (resourceType == ResourceType.PartitionKeyRange) {
                    return resourceFullName + "/" + "pkranges";
                }
                if (resourceType == ResourceType.Schema) {
                    resourcePath = resourceFullName + "/" + "schemas";
                } else if (resourceType == ResourceType.ClientEncryptionKey) {
                    resourcePath = resourceFullName + "/" + "clientencryptionkeys";
                } else {
                    String errorMessage = String.format("Resource type %s is unknown", resourceType.toString());
                    assert (false) : errorMessage;
                    throw new IllegalArgumentException(errorMessage);
                }
            }
        }
        return resourcePath;
    }

    public static String generatePath(ResourceType resourceType, String ownerOrResourceId, boolean isFeed) {
        if (isFeed && (ownerOrResourceId == null || ownerOrResourceId.isEmpty()) && resourceType != ResourceType.Database && resourceType != ResourceType.Offer && resourceType != ResourceType.MasterPartition && resourceType != ResourceType.ServerPartition && resourceType != ResourceType.DatabaseAccount && resourceType != ResourceType.Topology) {
            throw new IllegalStateException("INVALID resource type");
        }
        if (ownerOrResourceId == null) {
            ownerOrResourceId = "";
        }
        if (isFeed && resourceType == ResourceType.Database) {
            return "dbs";
        }
        if (resourceType == ResourceType.Database) {
            return "dbs/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.DocumentCollection) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls";
        }
        if (resourceType == ResourceType.DocumentCollection) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString();
        }
        if (isFeed && resourceType == ResourceType.Offer) {
            return "offers";
        }
        if (resourceType == ResourceType.Offer) {
            return "offers/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.StoredProcedure) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "sprocs";
        }
        if (resourceType == ResourceType.StoredProcedure) {
            ResourceId storedProcedureId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + storedProcedureId.getDatabaseId().toString() + "/" + "colls" + "/" + storedProcedureId.getDocumentCollectionId().toString() + "/" + "sprocs" + "/" + storedProcedureId.getStoredProcedureId().toString();
        }
        if (isFeed && resourceType == ResourceType.UserDefinedFunction) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "udfs";
        }
        if (resourceType == ResourceType.UserDefinedFunction) {
            ResourceId functionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + functionId.getDatabaseId().toString() + "/" + "colls" + "/" + functionId.getDocumentCollectionId().toString() + "/" + "udfs" + "/" + functionId.getUserDefinedFunctionId().toString();
        }
        if (isFeed && resourceType == ResourceType.Trigger) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "triggers";
        }
        if (resourceType == ResourceType.Trigger) {
            ResourceId triggerId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + triggerId.getDatabaseId().toString() + "/" + "colls" + "/" + triggerId.getDocumentCollectionId().toString() + "/" + "triggers" + "/" + triggerId.getTriggerId().toString();
        }
        if (isFeed && resourceType == ResourceType.Conflict) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "conflicts";
        }
        if (resourceType == ResourceType.Conflict) {
            ResourceId conflictId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + conflictId.getDatabaseId().toString() + "/" + "colls" + "/" + conflictId.getDocumentCollectionId().toString() + "/" + "conflicts" + "/" + conflictId.getConflictId().toString();
        }
        if (isFeed && resourceType == ResourceType.PartitionKeyRange) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "pkranges";
        }
        if (resourceType == ResourceType.PartitionKeyRange) {
            ResourceId partitionKeyRangeId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + partitionKeyRangeId.getDatabaseId().toString() + "/" + "colls" + "/" + partitionKeyRangeId.getDocumentCollectionId().toString() + "/" + "pkranges" + "/" + partitionKeyRangeId.getPartitionKeyRangeId().toString();
        }
        if (isFeed && resourceType == ResourceType.Attachment) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "docs" + "/" + documentCollectionId.getDocumentId().toString() + "/" + "attachments";
        }
        if (resourceType == ResourceType.Attachment) {
            ResourceId attachmentId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + attachmentId.getDatabaseId().toString() + "/" + "colls" + "/" + attachmentId.getDocumentCollectionId().toString() + "/" + "docs" + "/" + attachmentId.getDocumentId().toString() + "/" + "attachments" + "/" + attachmentId.getAttachmentId().toString();
        }
        if (isFeed && resourceType == ResourceType.User) {
            return "dbs/" + ownerOrResourceId + "/" + "users";
        }
        if (resourceType == ResourceType.User) {
            ResourceId userId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + userId.getDatabaseId().toString() + "/" + "users" + "/" + userId.getUserId().toString();
        }
        if (isFeed && resourceType == ResourceType.Permission) {
            ResourceId userId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + userId.getDatabaseId().toString() + "/" + "users" + "/" + userId.getUserId().toString() + "/" + "permissions";
        }
        if (resourceType == ResourceType.Permission) {
            ResourceId permissionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + permissionId.getDatabaseId().toString() + "/" + "users" + "/" + permissionId.getUserId().toString() + "/" + "permissions" + "/" + permissionId.getPermissionId().toString();
        }
        if (isFeed && resourceType == ResourceType.Document) {
            ResourceId documentCollectionId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentCollectionId.getDatabaseId().toString() + "/" + "colls" + "/" + documentCollectionId.getDocumentCollectionId().toString() + "/" + "docs";
        }
        if (resourceType == ResourceType.Document) {
            ResourceId documentId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + documentId.getDatabaseId().toString() + "/" + "colls" + "/" + documentId.getDocumentCollectionId().toString() + "/" + "docs" + "/" + documentId.getDocumentId().toString();
        }
        if (isFeed && resourceType == ResourceType.MasterPartition) {
            return "partitions";
        }
        if (resourceType == ResourceType.MasterPartition) {
            return "partitions/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.ServerPartition) {
            return "partitions";
        }
        if (resourceType == ResourceType.ServerPartition) {
            return "partitions/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.Topology) {
            return "topology";
        }
        if (resourceType == ResourceType.Topology) {
            return "topology/" + ownerOrResourceId;
        }
        if (isFeed && resourceType == ResourceType.DatabaseAccount) {
            return "databaseaccount";
        }
        if (resourceType == ResourceType.DatabaseAccount) {
            return "databaseaccount/" + ownerOrResourceId;
        }
        if (resourceType == ResourceType.ClientEncryptionKey) {
            ResourceId clientEncryptionKeyId = ResourceId.parse(ownerOrResourceId);
            return "dbs/" + clientEncryptionKeyId.getDatabaseId().toString() + "/" + "clientencryptionkeys" + "/" + clientEncryptionKeyId.getClientEncryptionKeyId().toString();
        }
        String errorMessage = "invalid resource type";
        throw new IllegalStateException(errorMessage);
    }

    public static PathInfo parsePathSegments(String resourceUrl) {
        Pair<Boolean, ResourceId> result;
        String segmentTwo;
        String[] segments = StringUtils.strip(resourceUrl, "/").split("/");
        if (segments == null || segments.length < 1) {
            return null;
        }
        int uriSegmentsCount = segments.length;
        String segmentOne = StringUtils.strip(segments[uriSegmentsCount - 1], "/");
        String string = segmentTwo = uriSegmentsCount >= 2 ? StringUtils.strip(segments[uriSegmentsCount - 2], "/") : "";
        if (!(uriSegmentsCount < 2 || "media".compareTo(segments[0]) == 0 || "offers".compareTo(segments[0]) == 0 || "partitions".compareTo(segments[0]) == 0 || "databaseaccount".compareTo(segments[0]) == 0 || (result = ResourceId.tryParse(segments[1])).getLeft().booleanValue() && result.getRight().isDatabaseId())) {
            return PathsHelper.parseNameSegments(resourceUrl, segments);
        }
        if (uriSegmentsCount % 2 != 0 && PathsHelper.isResourceType(segmentOne)) {
            return new PathInfo(true, segmentOne, segmentOne.compareToIgnoreCase("dbs") != 0 ? segmentTwo : "", false);
        }
        if (PathsHelper.isResourceType(segmentTwo)) {
            return new PathInfo(false, segmentTwo, segmentOne, false);
        }
        return null;
    }

    public static boolean tryParsePathSegments(String resourceUrl, PathInfo pathInfo, String clientVersion) {
        Pair<Boolean, ResourceId> result;
        String segmentTwo;
        pathInfo.resourcePath = "";
        pathInfo.resourceIdOrFullName = "";
        pathInfo.isFeed = false;
        pathInfo.isNameBased = false;
        if (StringUtils.isEmpty(resourceUrl)) {
            return false;
        }
        String trimmedStr = StringUtils.strip(resourceUrl, "/");
        String[] segments = StringUtils.split(trimmedStr, "/");
        if (segments == null || segments.length < 1) {
            return false;
        }
        int uriSegmentsCount = segments.length;
        String segmentOne = segments[uriSegmentsCount - 1];
        String string = segmentTwo = uriSegmentsCount >= 2 ? segments[uriSegmentsCount - 2] : "";
        if (!(uriSegmentsCount < 2 || "media".compareTo(segments[0]) == 0 || "offers".compareTo(segments[0]) == 0 || "partitions".compareTo(segments[0]) == 0 || "databaseaccount".compareTo(segments[0]) == 0 || "topology".compareTo(segments[0]) == 0 || "ridranges".compareTo(segments[0]) == 0 || (result = ResourceId.tryParse(segments[1])).getLeft().booleanValue() && result.getRight().isDatabaseId())) {
            pathInfo.isNameBased = true;
            return PathsHelper.tryParseNameSegments(resourceUrl, segments, pathInfo);
        }
        if (uriSegmentsCount % 2 != 0 && PathsHelper.isResourceType(segmentOne)) {
            pathInfo.isFeed = true;
            pathInfo.resourcePath = segmentOne;
            if (!segmentOne.equalsIgnoreCase("dbs")) {
                pathInfo.resourceIdOrFullName = segmentTwo;
            }
        } else if (PathsHelper.isResourceType(segmentTwo)) {
            pathInfo.isFeed = false;
            pathInfo.resourcePath = segmentTwo;
            pathInfo.resourceIdOrFullName = segmentOne;
            if (!StringUtils.isEmpty(clientVersion) && pathInfo.resourcePath.equalsIgnoreCase("media")) {
                Object attachmentId = null;
                boolean bl = false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean tryParseNameSegments(String resourceUrl, String[] segments, PathInfo pathInfo) {
        pathInfo.isFeed = false;
        pathInfo.resourceIdOrFullName = "";
        pathInfo.resourcePath = "";
        if (segments == null || segments.length < 1) {
            return false;
        }
        if (segments.length % 2 == 0) {
            if (PathsHelper.isResourceType(segments[segments.length - 2])) {
                pathInfo.resourcePath = segments[segments.length - 2];
                pathInfo.resourceIdOrFullName = PathsHelper.unescapeJavaAndTrim(resourceUrl);
                return true;
            }
        } else if (PathsHelper.isResourceType(segments[segments.length - 1])) {
            pathInfo.isFeed = true;
            pathInfo.resourcePath = segments[segments.length - 1];
            String resourceIdOrFullName = resourceUrl.substring(0, StringUtils.removeEnd(resourceUrl, "/").lastIndexOf("/"));
            pathInfo.resourceIdOrFullName = PathsHelper.unescapeJavaAndTrim(resourceIdOrFullName);
            return true;
        }
        return false;
    }

    public static PathInfo parseNameSegments(String resourceUrl, String[] segments) {
        if (segments == null || segments.length < 1) {
            return null;
        }
        if (segments.length % 2 == 0) {
            if (PathsHelper.isResourceType(segments[segments.length - 2])) {
                return new PathInfo(false, segments[segments.length - 2], PathsHelper.unescapeJavaAndTrim(resourceUrl), true);
            }
        } else if (PathsHelper.isResourceType(segments[segments.length - 1])) {
            return new PathInfo(true, segments[segments.length - 1], PathsHelper.unescapeJavaAndTrim(resourceUrl.substring(0, StringUtils.removeEnd(resourceUrl, "/").lastIndexOf("/"))), true);
        }
        return null;
    }

    public static String unescapeJavaAndTrim(String resourceUrl) {
        int endExclusiveIndex;
        int startInclusiveIndex;
        if (resourceUrl == null) {
            return null;
        }
        for (startInclusiveIndex = 0; startInclusiveIndex < resourceUrl.length() && resourceUrl.charAt(startInclusiveIndex) == '/'; ++startInclusiveIndex) {
        }
        if (startInclusiveIndex == resourceUrl.length()) {
            return "";
        }
        for (endExclusiveIndex = resourceUrl.length(); endExclusiveIndex > startInclusiveIndex && resourceUrl.charAt(endExclusiveIndex - 1) == '/'; --endExclusiveIndex) {
        }
        for (int startLoopIndex = startInclusiveIndex; startLoopIndex < endExclusiveIndex; ++startLoopIndex) {
            if (resourceUrl.charAt(startLoopIndex) != '\\') continue;
            return StringEscapeUtils.unescapeJava(StringUtils.strip(resourceUrl, "/"));
        }
        if (startInclusiveIndex == 0 && endExclusiveIndex == resourceUrl.length()) {
            return resourceUrl;
        }
        return resourceUrl.substring(startInclusiveIndex, endExclusiveIndex);
    }

    private static boolean isResourceType(String resourcePathSegment) {
        if (StringUtils.isEmpty(resourcePathSegment)) {
            return false;
        }
        switch (resourcePathSegment.toLowerCase(Locale.ROOT)) {
            case "attachments": 
            case "colls": 
            case "dbs": 
            case "permissions": 
            case "users": 
            case "docs": 
            case "sprocs": 
            case "triggers": 
            case "udfs": 
            case "conflicts": 
            case "media": 
            case "offers": 
            case "partitions": 
            case "databaseaccount": 
            case "topology": 
            case "pkranges": 
            case "schemas": 
            case "clientencryptionkeys": {
                return true;
            }
        }
        return false;
    }

    public static String generatePathForNameBased(ResourceType resourceType, String resourceOwnerFullName, String resourceName) {
        switch (resourceType) {
            case Database: {
                return "dbs/" + resourceName;
            }
            case DocumentCollection: {
                return resourceOwnerFullName + "/" + "colls" + "/" + resourceName;
            }
            case StoredProcedure: {
                return resourceOwnerFullName + "/" + "sprocs" + "/" + resourceName;
            }
            case UserDefinedFunction: {
                return resourceOwnerFullName + "/" + "udfs" + "/" + resourceName;
            }
            case Trigger: {
                return resourceOwnerFullName + "/" + "triggers" + "/" + resourceName;
            }
            case Attachment: {
                return resourceOwnerFullName + "/" + "attachments" + "/" + resourceName;
            }
            case Conflict: {
                return resourceOwnerFullName + "/" + "conflicts" + "/" + resourceName;
            }
            case Document: {
                return resourceOwnerFullName + "/" + "docs" + "/" + resourceName;
            }
            case Offer: {
                return resourceOwnerFullName + "/" + "offers" + "/" + resourceName;
            }
            case Permission: {
                return resourceOwnerFullName + "/" + "permissions" + "/" + resourceName;
            }
            case User: {
                return resourceOwnerFullName + "/" + "users" + "/" + resourceName;
            }
            case PartitionKeyRange: {
                return resourceOwnerFullName + "/" + "pkranges" + "/" + resourceName;
            }
        }
        return null;
    }

    public static String getCollectionPath(String resourceFullName) {
        String trimmedResourceFullName;
        int index;
        if (resourceFullName != null && (index = PathsHelper.indexOfNth(trimmedResourceFullName = Utils.trimBeginningAndEndingSlashes(resourceFullName), '/', 4)) > 0) {
            return trimmedResourceFullName.substring(0, index);
        }
        return resourceFullName;
    }

    public static String getDatabasePath(String resourceFullName) {
        int index;
        if (resourceFullName != null && (index = PathsHelper.indexOfNth(resourceFullName, '/', 2)) > 0) {
            return resourceFullName.substring(0, index);
        }
        return resourceFullName;
    }

    public static String getParentByIndex(String resourceFullName, int segmentIndex) {
        int index = PathsHelper.indexOfNth(resourceFullName, '/', segmentIndex);
        if (index > 0) {
            return resourceFullName.substring(0, index);
        }
        index = PathsHelper.indexOfNth(resourceFullName, '/', segmentIndex - 1);
        if (index > 0) {
            return resourceFullName;
        }
        return null;
    }

    public static boolean isNameBased(String resourceIdOrFullName) {
        return resourceIdOrFullName != null && !resourceIdOrFullName.isEmpty() && resourceIdOrFullName.length() > 4 && resourceIdOrFullName.charAt(3) == '/';
    }

    private static int indexOfNth(String str, char value, int nthOccurance) {
        int remaining = nthOccurance;
        char[] characters = str.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i] != value || --remaining != 0) continue;
            return i;
        }
        return -1;
    }

    public static ResourceType getResourcePathSegment(String resourcePathSegment) throws BadRequestException {
        if (StringUtils.isEmpty(resourcePathSegment)) {
            String message = String.format("STRING agument %s is null or empty", "resourcePathSegment");
            throw new BadRequestException(message);
        }
        switch (resourcePathSegment) {
            case "attachments": {
                return ResourceType.Attachment;
            }
            case "colls": {
                return ResourceType.DocumentCollection;
            }
            case "dbs": {
                return ResourceType.Database;
            }
            case "permissions": {
                return ResourceType.Permission;
            }
            case "users": {
                return ResourceType.User;
            }
            case "docs": {
                return ResourceType.Document;
            }
            case "sprocs": {
                return ResourceType.StoredProcedure;
            }
            case "udfs": {
                return ResourceType.UserDefinedFunction;
            }
            case "triggers": {
                return ResourceType.Trigger;
            }
            case "conflicts": {
                return ResourceType.Conflict;
            }
            case "offers": {
                return ResourceType.Offer;
            }
            case "schemas": {
                return ResourceType.Schema;
            }
        }
        String errorMessage = String.format("Resource type %s is unknown", resourcePathSegment);
        throw new BadRequestException(errorMessage);
    }

    public static String getResourcePath(ResourceType resourceType) throws BadRequestException {
        switch (resourceType) {
            case Database: {
                return "dbs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Document: {
                return "docs";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case Trigger: {
                return "triggers";
            }
            case Conflict: {
                return "conflicts";
            }
            case Attachment: {
                return "attachments";
            }
            case User: {
                return "users";
            }
            case Permission: {
                return "permissions";
            }
            case Offer: {
                return "offers";
            }
            case MasterPartition: 
            case ServerPartition: {
                return "partitions";
            }
            case PartitionKeyRange: {
                return "pkranges";
            }
            case Media: {
                return "/media";
            }
            case Schema: {
                return "schemas";
            }
            case DatabaseAccount: 
            case Topology: {
                return "/";
            }
        }
        String errorMessage = String.format("Resource type %s is unknown", resourceType.toString());
        throw new BadRequestException(errorMessage);
    }

    public static boolean validateResourceFullName(ResourceType resourceType, String resourceFullName) {
        String[] segments = StringUtils.split(resourceFullName, '/');
        String[] resourcePathArray = PathsHelper.getResourcePathArray(resourceType);
        if (resourcePathArray == null) {
            return false;
        }
        if (segments.length != resourcePathArray.length * 2) {
            return false;
        }
        for (int i = 0; i < resourcePathArray.length; ++i) {
            if (resourcePathArray[i].compareTo(segments[2 * i]) == 0) continue;
            return false;
        }
        return true;
    }

    private static String[] getResourcePathArray(ResourceType resourceType) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("dbs");
        if (resourceType == ResourceType.Permission || resourceType == ResourceType.User) {
            segments.add("users");
            if (resourceType == ResourceType.Permission) {
                segments.add("permissions");
            }
        } else if (resourceType == ResourceType.ClientEncryptionKey) {
            segments.add("clientencryptionkeys");
        } else if (resourceType == ResourceType.DocumentCollection || resourceType == ResourceType.StoredProcedure || resourceType == ResourceType.UserDefinedFunction || resourceType == ResourceType.Trigger || resourceType == ResourceType.Conflict || resourceType == ResourceType.Attachment || resourceType == ResourceType.Document || resourceType == ResourceType.PartitionKeyRange || resourceType == ResourceType.Schema) {
            segments.add("colls");
            if (resourceType == ResourceType.StoredProcedure) {
                segments.add("sprocs");
            } else if (resourceType == ResourceType.UserDefinedFunction) {
                segments.add("udfs");
            } else if (resourceType == ResourceType.Trigger) {
                segments.add("triggers");
            } else if (resourceType == ResourceType.Conflict) {
                segments.add("conflicts");
            } else if (resourceType == ResourceType.Schema) {
                segments.add("schemas");
            } else if (resourceType == ResourceType.Document || resourceType == ResourceType.Attachment) {
                segments.add("docs");
                if (resourceType == ResourceType.Attachment) {
                    segments.add("attachments");
                }
            } else if (resourceType == ResourceType.PartitionKeyRange) {
                segments.add("pkranges");
            }
        } else if (resourceType != ResourceType.Database) {
            return null;
        }
        return (String[])segments.stream().toArray(String[]::new);
    }

    public static boolean validateResourceId(ResourceType resourceType, String resourceId) {
        if (resourceType == ResourceType.Conflict) {
            return PathsHelper.validateConflictId(resourceId);
        }
        if (resourceType == ResourceType.Database) {
            return PathsHelper.validateDatabaseId(resourceId);
        }
        if (resourceType == ResourceType.DocumentCollection) {
            return PathsHelper.validateDocumentCollectionId(resourceId);
        }
        if (resourceType == ResourceType.Document) {
            return PathsHelper.validateDocumentId(resourceId);
        }
        if (resourceType == ResourceType.Permission) {
            return PathsHelper.validatePermissionId(resourceId);
        }
        if (resourceType == ResourceType.StoredProcedure) {
            return PathsHelper.validateStoredProcedureId(resourceId);
        }
        if (resourceType == ResourceType.Trigger) {
            return PathsHelper.validateTriggerId(resourceId);
        }
        if (resourceType == ResourceType.UserDefinedFunction) {
            return PathsHelper.validateUserDefinedFunctionId(resourceId);
        }
        if (resourceType == ResourceType.User) {
            return PathsHelper.validateUserId(resourceId);
        }
        if (resourceType == ResourceType.Attachment) {
            return PathsHelper.validateAttachmentId(resourceId);
        }
        if (resourceType == ResourceType.ClientEncryptionKey) {
            return PathsHelper.validateClientEncryptionKeyId(resourceId);
        }
        logger.error(String.format("ValidateResourceId not implemented for Type %s in ResourceRequestHandler", resourceType.toString()));
        return false;
    }

    public static boolean validateDatabaseId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getDatabase() != 0;
    }

    public static boolean validateDocumentCollectionId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getDocumentCollection() != 0;
    }

    public static boolean validateDocumentId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getDocument() != 0L;
    }

    public static boolean validateConflictId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getConflict() != 0L;
    }

    public static boolean validateAttachmentId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getAttachment() != 0;
    }

    public static boolean validatePermissionId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getPermission() != 0L;
    }

    public static boolean validateStoredProcedureId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getStoredProcedure() != 0L;
    }

    public static boolean validateTriggerId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getTrigger() != 0L;
    }

    public static boolean validateUserDefinedFunctionId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getUserDefinedFunction() != 0L;
    }

    public static boolean validateUserId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getUser() != 0;
    }

    public static boolean validateClientEncryptionKeyId(String resourceIdString) {
        Pair<Boolean, ResourceId> pair = ResourceId.tryParse(resourceIdString);
        return pair.getLeft() != false && pair.getRight().getClientEncryptionKey() != 0;
    }

    public static boolean isPublicResource(Resource resourceType) {
        return resourceType instanceof Database || resourceType instanceof DocumentCollection || resourceType instanceof StoredProcedure || resourceType instanceof UserDefinedFunction || resourceType instanceof Trigger || resourceType instanceof Conflict || resourceType instanceof User || resourceType instanceof Permission || resourceType instanceof Document || resourceType instanceof Offer;
    }
}

