/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BulkProcessingThresholds;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.util.Beta;
import java.time.Duration;

@Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class BulkProcessingOptions<TContext> {
    private int maxMicroBatchSize = 100;
    private int maxMicroBatchConcurrency = 1;
    private double maxMicroBatchRetryRate = 0.2;
    private double minMicroBatchRetryRate = 0.1;
    private Duration maxMicroBatchInterval = Duration.ofMillis(1000L);
    private final TContext batchContext;
    private final BulkProcessingThresholds<TContext> thresholds;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;

    @Beta(value=Beta.SinceVersion.V4_17_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingOptions(TContext batchContext, BulkProcessingThresholds<TContext> thresholds) {
        this.batchContext = batchContext;
        this.thresholds = thresholds == null ? new BulkProcessingThresholds() : thresholds;
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingOptions(TContext batchContext) {
        this(batchContext, null);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingOptions() {
        this(null);
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getMaxMicroBatchSize() {
        return this.maxMicroBatchSize;
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingOptions<TContext> setMaxMicroBatchSize(int maxMicroBatchSize) {
        this.maxMicroBatchSize = maxMicroBatchSize;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public int getMaxMicroBatchConcurrency() {
        return this.maxMicroBatchConcurrency;
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingOptions<TContext> setMaxMicroBatchConcurrency(int maxMicroBatchConcurrency) {
        this.maxMicroBatchConcurrency = maxMicroBatchConcurrency;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Duration getMaxMicroBatchInterval() {
        return this.maxMicroBatchInterval;
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingOptions<TContext> setMaxMicroBatchInterval(Duration maxMicroBatchInterval) {
        this.maxMicroBatchInterval = maxMicroBatchInterval;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_17_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public double getMaxTargetedMicroBatchRetryRate() {
        return this.maxMicroBatchRetryRate;
    }

    @Beta(value=Beta.SinceVersion.V4_17_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingOptions<TContext> setTargetedMicroBatchRetryRate(double minRetryRate, double maxRetryRate) {
        if (minRetryRate < 0.0) {
            throw new IllegalArgumentException("The maxRetryRate must not be a negative value");
        }
        if (minRetryRate > maxRetryRate) {
            throw new IllegalArgumentException("The minRetryRate must not exceed the maxRetryRate");
        }
        this.maxMicroBatchRetryRate = maxRetryRate;
        this.minMicroBatchRetryRate = minRetryRate;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_17_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public double getMinTargetedMicroBatchRetryRate() {
        return this.minMicroBatchRetryRate;
    }

    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public TContext getBatchContext() {
        return this.batchContext;
    }

    @Beta(value=Beta.SinceVersion.V4_17_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public BulkProcessingThresholds<TContext> getThresholds() {
        return this.thresholds;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    static {
        ImplementationBridgeHelpers.CosmosBulkProcessingOptionsHelper.setCosmosBulkProcessingOptionAccessor(new ImplementationBridgeHelpers.CosmosBulkProcessingOptionsHelper.CosmosBulkProcessingOptionAccessor(){

            @Override
            public <T> void setOperationContext(BulkProcessingOptions<T> bulkProcessingOptions, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                bulkProcessingOptions.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public <T> OperationContextAndListenerTuple getOperationContext(BulkProcessingOptions<T> bulkProcessingOptions) {
                return bulkProcessingOptions.getOperationContextAndListenerTuple();
            }
        });
    }
}

