/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosStoredProcedure;
import com.azure.cosmos.CosmosTrigger;
import com.azure.cosmos.CosmosUserDefinedFunction;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureResponse;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.CosmosUserDefinedFunctionResponse;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosScripts {
    private final CosmosContainer container;
    private final CosmosAsyncScripts asyncScripts;

    CosmosScripts(CosmosContainer container, CosmosAsyncScripts asyncScripts) {
        this.container = container;
        this.asyncScripts = asyncScripts;
    }

    public CosmosStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties) {
        return this.blockStoredProcedureResponse(this.asyncScripts.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions()));
    }

    public CosmosStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) {
        return this.blockStoredProcedureResponse(this.asyncScripts.createStoredProcedure(properties, options));
    }

    public CosmosPagedIterable<CosmosStoredProcedureProperties> readAllStoredProcedures() {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllStoredProcedures(new CosmosQueryRequestOptions()));
    }

    CosmosPagedIterable<CosmosStoredProcedureProperties> readAllStoredProcedures(CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllStoredProcedures(options));
    }

    public CosmosPagedIterable<CosmosStoredProcedureProperties> queryStoredProcedures(String query, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryStoredProcedures(query, options));
    }

    public CosmosPagedIterable<CosmosStoredProcedureProperties> queryStoredProcedures(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryStoredProcedures(querySpec, options));
    }

    public CosmosStoredProcedure getStoredProcedure(String id) {
        return new CosmosStoredProcedure(id, this.container, this.asyncScripts.getStoredProcedure(id));
    }

    public CosmosUserDefinedFunctionResponse createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) {
        return this.blockUDFResponse(this.asyncScripts.createUserDefinedFunction(properties));
    }

    public CosmosPagedIterable<CosmosUserDefinedFunctionProperties> readAllUserDefinedFunctions() {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllUserDefinedFunctions(new CosmosQueryRequestOptions()));
    }

    CosmosPagedIterable<CosmosUserDefinedFunctionProperties> readAllUserDefinedFunctions(CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllUserDefinedFunctions(options));
    }

    public CosmosPagedIterable<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(String query, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryUserDefinedFunctions(new SqlQuerySpec(query), options));
    }

    public CosmosPagedIterable<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryUserDefinedFunctions(querySpec, options));
    }

    public CosmosUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosUserDefinedFunction(id, this.container, this.asyncScripts.getUserDefinedFunction(id));
    }

    public CosmosTriggerResponse createTrigger(CosmosTriggerProperties properties) {
        return this.blockTriggerResponse(this.asyncScripts.createTrigger(properties));
    }

    public CosmosPagedIterable<CosmosTriggerProperties> readAllTriggers() {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllTriggers(new CosmosQueryRequestOptions()));
    }

    CosmosPagedIterable<CosmosTriggerProperties> readAllTriggers(CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllTriggers(options));
    }

    public CosmosPagedIterable<CosmosTriggerProperties> queryTriggers(String query, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryTriggers(query, options));
    }

    public CosmosPagedIterable<CosmosTriggerProperties> queryTriggers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryTriggers(querySpec, options));
    }

    public CosmosTrigger getTrigger(String id) {
        return new CosmosTrigger(id, this.container, this.asyncScripts.getTrigger(id));
    }

    CosmosStoredProcedureResponse blockStoredProcedureResponse(Mono<CosmosStoredProcedureResponse> storedProcedureResponseMono) {
        try {
            return (CosmosStoredProcedureResponse)storedProcedureResponseMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    CosmosUserDefinedFunctionResponse blockUDFResponse(Mono<CosmosUserDefinedFunctionResponse> responseMono) {
        try {
            return (CosmosUserDefinedFunctionResponse)responseMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    CosmosTriggerResponse blockTriggerResponse(Mono<CosmosTriggerResponse> responseMono) {
        try {
            return (CosmosTriggerResponse)responseMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return UtilBridgeInternal.createCosmosPagedIterable(cosmosPagedFlux);
    }
}

